-- ##########################################
-- #	Balloon Wheels						#
-- #	version: 1.0						#
-- #	Date: 22.12.2012					#
-- #	author: [FSM]Webby					#
-- #	hp: fieldstar.forumprofi.de			#
-- #										#
-- # 	Keine Vernderung ohne				# 
-- # 	meine Erlaubnis!					#
-- # 	No modification without				# 
-- # 	my permission!						#
-- #										#
-- #	history:							#
-- #	v1.0	Project started				#
-- #										#
-- ########################################## 	

balloonWheels = {};

function balloonWheels.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function balloonWheels:load(xmlFile)
	self.wheelToBalloonLeft1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.balloonWheels.wheelToBalloonLeft1#index"));
	self.wheelToBalloonLeft2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.balloonWheels.wheelToBalloonLeft2#index"));
	self.wheelToBalloonRight1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.balloonWheels.wheelToBalloonRight1#index"));
	self.wheelToBalloonRight2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.balloonWheels.wheelToBalloonRight2#index"));
	
	self.bwLX, self.bwLY, self.bwLZ = getScale(self.wheelToBalloonLeft1);
	self.bwLX, self.bwLY, self.bwLZ = getScale(self.wheelToBalloonLeft2);
	self.bwRX, self.bwRY, self.bwRZ = getScale(self.wheelToBalloonRight1);
	self.bwRX, self.bwRY, self.bwRZ = getScale(self.wheelToBalloonRight2);
	
	
	self.balloonWheelsState = false;
end;

function balloonWheels:delete()
end;

function balloonWheels:mouseEvent(posX, posY, isDown, isUp, button)
end;

function balloonWheels:keyEvent(unicode, sym, modifier, isDown)
end;

function balloonWheels:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.BALLOONWHEELS) then
			self.balloonWheelsState = not self.balloonWheelsState;
		end;
		
		if self.balloonWheelsState == true then
			setScale(self.wheelToBalloonLeft1, (self.bwLX / 100) + 1, self.bwLY ,self.bwLZ);
			setScale(self.wheelToBalloonLeft2, (self.bwLX / 100) + 1, self.bwLY ,self.bwLZ);
			setScale(self.wheelToBalloonRight1, (self.bwRX / 100) + 1, self.bwRY ,self.bwRZ);
			setScale(self.wheelToBalloonRight2, (self.bwRX / 100) + 1, self.bwRY ,self.bwRZ);
		elseif self.balloonWheelsState == false then
			setScale(self.wheelToBalloonLeft1, self.bwLX, self.bwLY ,self.bwLZ);
			setScale(self.wheelToBalloonLeft2, self.bwLX, self.bwLY ,self.bwLZ);
			setScale(self.wheelToBalloonRight1, self.bwRX, self.bwRY ,self.bwRZ);
			setScale(self.wheelToBalloonRight2, self.bwRX, self.bwRY ,self.bwRZ);
		end;
	end;
end;

function balloonWheels:draw()
	if self.balloonWheelsState then
		g_currentMission:addHelpButtonText(g_i18n:getText("BALLOONON"), InputBinding.BALLOONWHEELS);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("BALLOONOFF"), InputBinding.BALLOONWHEELS);
	end;
end;

function balloonWheels:onLeave()
	
end;
