--
-- VariableDriver
-- Specialization for VariableDriver
--
-- @author  	71biTi (Shed Tuning System, STS)
-- @version 	v1.0
-- @date  		21/12/12
-- @history:	v1.0 - Initial version
--

VariableDriver = {};

function VariableDriver.prerequisitesPresent(specializations)
    return true;
end;

function VariableDriver:load(xmlFile)	

	self.setDriver = SpecializationUtil.callSpecializationsFunction("setDriver");

	self.driver1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drivers#index1"));
	self.driver2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drivers#index2"));
	self.driverId = 0;
end;

function VariableDriver:delete()
end;

function VariableDriver:readStream(streamId, connection)
	self:setDriver(streamReadInt8(streamId), true);
end;

function VariableDriver:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.driverId);	
end;

function VariableDriver:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VariableDriver:keyEvent(unicode, sym, modifier, isDown)
end;

function VariableDriver:update(dt)
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.Variable_Drivers) then
				self:setDriver(math.abs(self.driverId - 1));
			end;
		end;
	end;
end;

function VariableDriver:draw()
	g_currentMission:addHelpButtonText(g_i18n:getText("Variable_driver"), InputBinding.Variable_Drivers);
end;

function VariableDriver:setDriver(driver, noEventSend)
	VariableDriverEvent.sendEvent(self, driver, noEventSend);

	setVisibility(self.driver1, driver == 0);
	setVisibility(self.driver2, driver == 1);
	self.driverId = driver;
end;

function VariableDriver:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self:setDriver(Utils.getNoNil(getXMLInt(xmlFile, key.."#driverId"),0), true);
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function VariableDriver:getSaveAttributesAndNodes(nodeIdent)	
    local attributes = 'driverId="'.. tostring(self.driverId) .. '"';
    return attributes, nil;
end;





VariableDriverEvent = {};
VariableDriverEvent_mt = Class(VariableDriverEvent, Event);

InitEventClass(VariableDriverEvent, "VariableDriverEvent");

function VariableDriverEvent:emptyNew()
    local self = Event:new(VariableDriverEvent_mt);
    return self;
end;

function VariableDriverEvent:new(vehicle, driver)
    local self = VariableDriverEvent:emptyNew()
    self.vehicle = vehicle;
	self.driver = driver;
    return self;
end;

function VariableDriverEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.driver = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function VariableDriverEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.driver);	
end;

function VariableDriverEvent:run(connection)
	self.vehicle:setDriver(self.driver, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(VariableDriverEvent:new(self.vehicle, self.driver), nil, connection, self.vehicle);
	end;
end;

function VariableDriverEvent.sendEvent(vehicle, driver, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(VariableDriverEvent:new(vehicle, driver), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(VariableDriverEvent:new(vehicle, driver));
		end;
	end;
end;
