--
-- ChangeRim
-- Specialization for ChangeRim
--
-- @author  	71biTi (Shed Tuning System, STS)
-- @version 	v1.0
-- @date  		30/12/12
-- @history:	v1.0 - Initial version
--

ChangeRim = {};

function ChangeRim.prerequisitesPresent(specializations)
    return true;
end;

function ChangeRim:load(xmlFile)	

	self.setRim = SpecializationUtil.callSpecializationsFunction("setRim");

	self.rim1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rims1#index1"));
	self.rim2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rims1#index2"));
	self.rim3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rims2#index1"));
	self.rim4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rims2#index2"));
	self.rim5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rims3#index1"));
	self.rim6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rims3#index2"));
	self.rim7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rims4#index1"));
	self.rim8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rims4#index2"));
	self.rimId = 0;
end;

function ChangeRim:delete()
end;

function ChangeRim:readStream(streamId, connection)
	self:setRim(streamReadInt8(streamId), true);
end;

function ChangeRim:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.rimId);	
end;

function ChangeRim:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ChangeRim:keyEvent(unicode, sym, modifier, isDown)
end;

function ChangeRim:update(dt)
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.Change_Rims) then
				self:setRim(math.abs(self.rimId - 1));
			end;
		end;
	end;
end;

function ChangeRim:draw()
	g_currentMission:addHelpButtonText(g_i18n:getText("Change_rim"), InputBinding.Change_Rims);
end;

function ChangeRim:setRim(rim, noEventSend)
	ChangeRimEvent.sendEvent(self, rim, noEventSend);

	setVisibility(self.rim1, rim == 0);
	setVisibility(self.rim3, rim == 0);
	setVisibility(self.rim5, rim == 0);
	setVisibility(self.rim7, rim == 0);
	setVisibility(self.rim2, rim == 1);
	setVisibility(self.rim4, rim == 1);
	setVisibility(self.rim6, rim == 1);
	setVisibility(self.rim8, rim == 1);
	self.rimId = rim;
end;

function ChangeRim:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self:setRim(Utils.getNoNil(getXMLInt(xmlFile, key.."#rimId"),0), true);
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function ChangeRim:getSaveAttributesAndNodes(nodeIdent)	
    local attributes = 'rimId="'.. tostring(self.rimId) .. '"';
    return attributes, nil;
end;





ChangeRimEvent = {};
ChangeRimEvent_mt = Class(ChangeRimEvent, Event);

InitEventClass(ChangeRimEvent, "ChangeRimEvent");

function ChangeRimEvent:emptyNew()
    local self = Event:new(ChangeRimEvent_mt);
    return self;
end;

function ChangeRimEvent:new(vehicle, rim)
    local self = ChangeRimEvent:emptyNew()
    self.vehicle = vehicle;
	self.rim = rim;
    return self;
end;

function ChangeRimEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.rim = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ChangeRimEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.rim);	
end;

function ChangeRimEvent:run(connection)
	self.vehicle:setRim(self.rim, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(ChangeRimEvent:new(self.vehicle, self.rim), nil, connection, self.vehicle);
	end;
end;

function ChangeRimEvent.sendEvent(vehicle, rim, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ChangeRimEvent:new(vehicle, rim), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ChangeRimEvent:new(vehicle, rim));
		end;
	end;
end;
