-- @Author	???

-- @Edit	Anpassungen fr die Ifko World
-- @Date	06/07/2013

-- Edit by	Ifko[nator]

HaspelSpeed = {};

function HaspelSpeed.initSpecialization()
    Vehicle.registerJointType("HaspelSpeed");
end;

function HaspelSpeed.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function HaspelSpeed:load(xmlFile)
	
	self.HaspelSpeed = {};
	
	self.HaspelSpeed.speed = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.vario#speed"), 11);
	self.HaspelSpeed.speedScaleTime = 5000;
	self.HaspelSpeed.speedScaleBackup = self.reelSpeedScale;
	self.HaspelSpeed.rollSpeedBackup = self.rollNodes[1].speed;
	
	self.reelSpeedScale = 0;
	for _, rollNode in pairs(self.rollNodes) do
		rollNode.speed = 0;
	end;
end;

function HaspelSpeed:delete()
end;

function HaspelSpeed:readStream(streamId, connection)
end;

function HaspelSpeed:writeStream(streamId, connection)
end;

function HaspelSpeed:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HaspelSpeed:keyEvent(unicode, sym, modifier, isDown)
end;

function HaspelSpeed:update(dt)
	if self:getIsActive() and self.reelStarted then
		if self.attacherVehicle ~= nil and self.attacherVehicle.allowsThreshing ~= nil then
			if not self.attacherVehicle.allowsThreshing then
				self.lastAreaBiggerZero = false;
				if self.lastAreaBiggerZero ~= self.lastAreaBiggerZeroSent then
					self:raiseDirtyFlags(self.cutterGroundFlag);
					self.lastAreaBiggerZeroSent = self.lastAreaBiggerZero;
				end;
			end;
		end;
	
		local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.HaspelSpeed.speed, 1.3));
	
		local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.HaspelSpeed.speedScaleBackup * percent}, {0}, 1, self.HaspelSpeed.speedScaleTime, dt, false);
		self.reelSpeedScale = speedScale[1];
		for _, rollNode in pairs(self.rollNodes) do
			local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.HaspelSpeed.rollSpeedBackup * percent}, {0}, 1, self.HaspelSpeed.speedScaleTime, dt, false);
			rollNode.speed = rollSpeed[1];
		end;
		
		
	else
		if self.reelSpeedScale ~= 0 or self.rollNodes[1].speed ~= 0 then
			local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.HaspelSpeed.speed, 1.5));
			
			local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.HaspelSpeed.speedScaleBackup * percent}, {0}, 1, self.HaspelSpeed.speedScaleTime*1.5, dt, true);
			self.reelSpeedScale = speedScale[1];
			rotate(self.reelNode, -dt*self.reelSpeed*self.reelSpeedScale, 0, 0);
			for _, rollNode in pairs(self.rollNodes) do
				local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.HaspelSpeed.rollSpeedBackup * percent}, {0}, 1, self.HaspelSpeed.speedScaleTime*1.5, dt, true);
				rollNode.speed = rollSpeed[1];
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;
			
			local atx, aty, atz = getRotation(self.reelNode);
			for i=1, self.spikesCount do
				local spike = getChildAt(self.spikesRootNode, i-1);
				setRotation(spike, -atx, aty, atz);
			end;
		end;
	end;
end;

function HaspelSpeed:updateTick(dt)
	
end;

function HaspelSpeed:draw()	
end;

function HaspelSpeed:onAttach(attacherVehicle)
	
end;

function HaspelSpeed:onDetach()
	Cutter.updateExtraObjects(self);
end;
