--
-- NGS_601_F_35
-- Specialization for NGS_601_F_35

NGS_601_F_35 = {};

function NGS_601_F_35.prerequisitesPresent(specializations)
    return true;
end;


function NGS_601_F_35:load(xmlFile)
	self.getIsAreaActive = Utils.overwrittenFunction(self.getIsAreaActive, NGS_601_F_35.getIsAreaActive);
	self.setAllumer = SpecializationUtil.callSpecializationsFunction("setAllumer");	
	
	-- Rotor --	
	self.animation = {};
	self.animation.animCharSet = 0;
	self.animationEnabled = false;

	local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trommel#rootNode"));

	if rootNode ~= nil then
		self.animation.animCharSet = getAnimCharacterSet(rootNode);
		if self.animation.animCharSet ~= 0 then
			self.animation.clip = getAnimClipIndex(self.animation.animCharSet, getXMLString(xmlFile, "vehicle.trommel#animationClip"));
			if self.animation.clip >= 0 then
				assignAnimTrackClip(self.animation.animCharSet, 0, self.animation.clip);
				self.animation.speedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.trommel#speedScale"), 1);
				setAnimTrackSpeedScale(self.animation.animCharSet, self.animation.clip, self.animation.speedScale);
				setAnimTrackLoopState(self.animation.animCharSet, 0, true);
			end;
		end;
	end;
	self.allumer = false;
	self.animationSpeed = 0;
	self.animation.offsetTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.trommel#offsetTime"), 3) * 1000;
	
	local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
    if workSound ~= nil and workSound ~= "" then
        workSound = Utils.getFilename(workSound, self.baseDirectory);
        self.workSound = createSample("workSound");
        self.workSoundEnabled = false;
        loadSample(self.workSound, workSound, false);
        self.workSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#pitchOffset"), 1);
        self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#volume"), 1);
    end;
end;

function NGS_601_F_35:delete()
	if self.workSound ~= nil then
        delete(self.workSound);
		self.workSound = nil;
    end;
end;

function NGS_601_F_35:mouseEvent(posX, posY, isDown, isUp, button)
end;

function NGS_601_F_35:keyEvent(unicode, sym, modifier, isDown)
end;
function NGS_601_F_35:readStream(streamId, connection)
   self:setAllumer(streamReadBool(streamId), true);
end;

function NGS_601_F_35:writeStream(streamId, connection)
	streamWriteBool(streamId, self.allumer);
end;

function NGS_601_F_35:readUpdateStream(streamId, timestamp, connection)
end;

function NGS_601_F_35:writeUpdateStream(streamId, connection, dirtyMask)
end;

function NGS_601_F_35:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
		  self:setAllumer(not self.allumer);
		end;
	end;
end;

function NGS_601_F_35:updateTick(dt)
	if self:getIsActive() then
		if self.allumer then	
            if not self.animationEnabled then
                enableAnimTrack(self.animation.animCharSet, 0);
                self.animationEnabled = true;
			else
				if self.animationSpeed < (self.animation.speedScale - 0.01) then
					local newSpeed = Utils.getMovedLimitedValues({self.animationSpeed}, {self.animation.speedScale}, {0}, 1, self.animation.offsetTime, dt, false);
					self.animationSpeed = newSpeed[1];
					setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animationSpeed);
				end;
            end;
			if not self.workSoundEnabled and self:getIsActiveForSound() then
				playSample(self.workSound, 0, self.workSoundVolume, 0);
				setSamplePitch(self.workSound, self.workSoundPitchOffset);
				self.workSoundEnabled = true;
			end;
		else
			if self.animationEnabled then
				if self.animationSpeed < 0.01 then
					disableAnimTrack(self.animation.animCharSet, 0);
					self.animationEnabled = false;
				else
					enableAnimTrack(self.animation.animCharSet, 0);
					local newSpeed = Utils.getMovedLimitedValues({self.animationSpeed}, {self.animation.speedScale}, {0}, 1, self.animation.offsetTime, dt, true);
					self.animationSpeed = newSpeed[1];
					setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animationSpeed);
				end;
			end;
			if self.workSoundEnabled then
				stopSample(self.workSound);
				self.workSoundEnabled = false;
			end;
        end;
	end;
end;

function NGS_601_F_35:draw()
end;

function NGS_601_F_35:onDeactivate()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
	end;
	self.allumer = false;
end;

function NGS_601_F_35:onLeave()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
	end;
	self.allumer = false;
	
	if self.workSound ~= nil then
		stopSample(self.workSound);
	end;
end;

function NGS_601_F_35:onDetach()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
	end;
	self.allumer = false;
	if self.workSound ~= nil then
		stopSample(self.workSound);
	end;
end;
function NGS_601_F_35:onAttach()
	if self.animationEnabled then
		disableAnimTrack(self.animation.animCharSet, 0);
		self.animationEnabled = false;
	end;
	self.allumer = false;
end;

function NGS_601_F_35:setAllumer(allumer, noEventSend)
	SetAllumerEvent.sendEvent(self, allumer, noEventSend)
	self.allumer = allumer;
end;

function NGS_601_F_35:getIsAreaActive(superFunc, area)
    if superFunc ~= nil then
		return superFunc(self, area) and self.allumer;
    end;
	return self.allumer;	
end;