-- RealPowerTakeoffInput
-- Specialization for real power shaft animations
--
-- @author Tobias F. (John Deere 6930)
-- @date 10/09/2013
--

RealPowerTakeoffInput = {};

function RealPowerTakeoffInput.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function RealPowerTakeoffInput:load(xmlFile)
	if self.ptoInput ~= nil then
		if self.ptoInput.rootNode ~= nil then			
			self.ptoInput.realPto = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.powerTakeoffInput#realPto"), false);
		
			local rootNode = self.ptoInput.rootNode;			
			self.ptoInput.realNode = getChildAt(rootNode, 1);
			self.ptoInput.realPunch = getChildAt(self.ptoInput.realNode, 0);
			local fixPoint = getChildAt(self.ptoInput.realPunch, 0);
			self.ptoInput.realReferencePoint = getChildAt(self.ptoInput.attachNode, 0);
			
			local ax, ay, az = getWorldTranslation(self.ptoInput.realPunch);
			local bx, by, bz = getWorldTranslation(fixPoint);		
			self.ptoInput.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
end;

function RealPowerTakeoffInput:delete()
end;

function RealPowerTakeoffInput:readStream(streamId, connection)
end;

function RealPowerTakeoffInput:writeStream(streamId, connection)
end;

function RealPowerTakeoffInput:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RealPowerTakeoffInput:keyEvent(unicode, sym, modifier, isDown)
end;

function RealPowerTakeoffInput:updateTick(dt)
end;

function RealPowerTakeoffInput:update(dt)
	if self.ptoInput.realPto then
		local ax, ay, az = getWorldTranslation(self.ptoInput.realNode);
		local bx, by, bz = getWorldTranslation(self.ptoInput.realReferencePoint);
		local x, y, z = worldDirectionToLocal(getParent(self.ptoInput.realNode), bx-ax, by-ay, bz-az);
		setDirection(self.ptoInput.realNode, x, y, z, 0, -1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		setTranslation(self.ptoInput.realPunch, 0, 0, distance-self.ptoInput.punchDistance);			
	end;
end;

function RealPowerTakeoffInput:draw()
end;