SetActiveMCEvent = {};
SetActiveMCEvent_mt = Class(SetActiveMCEvent, Event);

InitEventClass(SetActiveMCEvent, "SetActiveMCEvent");

function SetActiveMCEvent:emptyNew()
    local self = Event:new(SetActiveMCEvent_mt);
    self.className="SetActiveMCEvent";
    return self;
end;

function SetActiveMCEvent:new(object, state)
    local self = SetActiveMCEvent:emptyNew()
    self.object = object;
	self.state = state;
    return self;
end;

function SetActiveMCEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadInt8(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetActiveMCEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.state);
end;

function SetActiveMCEvent:run(connection)
    self.object:setActiveMC(self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetActiveMCEvent:new(self.object, self.state), nil, connection, self.object);
    end;
end;

function SetActiveMCEvent.sendEvent(vehicle, state, noEventSend)
    if state ~= vehicle.activeMC then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(SetActiveMCEvent:new(vehicle, state), nil, nil, vehicle);
            else
                g_client:getServerConnection():sendEvent(SetActiveMCEvent:new(vehicle, state));
            end;
        end;
    end;
end;

