--
-- Copyright � 2013 Joacim Sigfridsson <joxxer@msn.com>
-- This work is free. You can redistribute it and/or modify it under the
-- terms of the Do What The Fuck You Want To Public License, Version 2,
-- as published by Sam Hocevar. See http://www.wtfpl.net/ for more details.
--
--
-- MovingPartsInterior
-- Specialization for MovingPartsInterior 
--
-- @author  	JoXXer
-- @date  		27/03/13
--
-- @history	v1.0 - Initial implementation
--			v1.0.5 - 07/06/13 - All dependencies for ManualIgnition-specialization removed
--			v1.2 - 02/08/13 - General overhaul, fixed various bugs and implementation-issues. SpeedoMeter support added
--			v1.2.1 - 27/08/13 - Raped by Martl; used code of modelleicher

MovingPartsInterior = {};

function MovingPartsInterior.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function MovingPartsInterior:load(xmlFile)
	self.clutchPedal = {};
	self.clutchPedal.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.clutchPedal#index"));
	self.clutchPedal.maxRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.clutchPedal#maxRot"), 0));
	self.clutchPedal.minRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.clutchPedal#minRot"), 0));
	self.clutchPedal.movementSpeed = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.clutchPedal#movementSpeed"), 0)/1000;
	
	self.brakePedal = {};
	self.brakePedal.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.brakePedal#index"));
	self.brakePedal.maxRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.brakePedal#maxRot"), 0));
	self.brakePedal.minRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.brakePedal#minRot"), 0));
	self.brakePedal.movementSpeed = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.brakePedal#movementSpeed"), 0)/1000;
	
	self.footThrottle = {};
	self.footThrottle.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.footThrottle#index"));
	
	self.handThrottle = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.handThrottle#index"));
	self.handThrottleTemp1Rot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.handThrottle#speed1rot"));
	self.handThrottleTemp2Rot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.handThrottle#speed2rot"));
	self.handThrottleTemp3Rot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.handThrottle#speed3rot"));
	self.handThrottleTemp4Rot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.handThrottle#speed4rot"));	
	self.htHrot = 0;
	
	self.speedoMeter = {};
	self.speedoMeter.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.speedoMeter#index"));
	self.speedoMeter.startRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.speedoMeter#startRot"), 0));
	self.speedoMeter.maxRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.speedoMeter#maxRot"), 0));
	self.speedoMeter.middleRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.speedoMeter#middleRot"), 0));
	self.speedoMeter.firstRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.speedoMeter#firstRot"), 0));
	self.speedoMeter.maxSpeed = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.speedoMeter#maxSpeed"), 0);
	self.speedoMeter.middleSpeed = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.speedoMeter#middleSpeed"), 0);
	self.speedoMeter.firstSpeed = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.speedoMeter#firstSpeed"), 0);
	self.speedoMeter.speedPercentageMax = math.deg(self.speedoMeter.maxRot - self.speedoMeter.middleRot)/(self.speedoMeter.maxSpeed - self.speedoMeter.middleSpeed);
	self.speedoMeter.speedPercentageMiddle = math.deg(self.speedoMeter.middleRot - self.speedoMeter.firstRot)/(self.speedoMeter.middleSpeed - self.speedoMeter.firstSpeed);
	self.speedoMeter.speedPercentageFirst = math.deg(self.speedoMeter.firstRot)/self.speedoMeter.firstSpeed;
	
	self.fuelMeter = {};
	self.fuelMeter.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fuelMeter#index"));
	self.fuelMeter.fullRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.fuelMeter#fullRot"), 0));
	self.fuelMeter.modifier = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.fuelMeter#modifier"), 0);
	local fuelX, fuelY, fuelZ = getRotation(self.fuelMeter.index);
	self.fuelMeter.startRot = fuelY;
	self.fuelMeter.totalRot = (self.fuelMeter.fullRot - self.fuelMeter.startRot) * self.fuelMeter.modifier;
	if self.fuelMeter.modifier == 1 then
		self.fuelMeter.fuelPercentage = self.fuelCapacity/100;
	else
		self.fuelMeter.fuelPercentage = math.deg(self.fuelMeter.totalRot)/self.fuelCapacity;
	end;
	self.fuelMeter.hasMovedUp = false;
end;

function MovingPartsInterior:delete()
end;

function MovingPartsInterior:readStream(streamId, connection)
end;

function MovingPartsInterior:writeStream(streamId, connection)
end;

function MovingPartsInterior:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MovingPartsInterior:keyEvent(unicode, sym, modifier, isDown)
end;

function MovingPartsInterior:update(dt)

	if self:getIsActive() then
		if self.isMotorStarted then
			if self.handThrottle ~= nil then
				local rot = 0;
				if self.motor.speedLevel == 1 then
					rot = self.handThrottleTemp1Rot
				elseif self.motor.speedLevel == 2 then
					rot = self.handThrottleTemp2Rot
				elseif self.motor.speedLevel == 3 then
					rot = self.handThrottleTemp3Rot
				elseif self.motor.speedLevel == 4 then
					rot = self.handThrottleTemp4Rot
				end;
				if self.htHrot < rot then
					self.htHrot = math.min(rot, self.htHrot +1);
					setRotation(self.handThrottle, 0, Utils.degToRad(self.htHrot), 0)
				elseif self.htHrot > rot then
					self.htHrot = math.max(rot, self.htHrot -1);
					setRotation(self.handThrottle, 0, Utils.degToRad(self.htHrot), 0)
				end;
			end;
		end;
	end;

	if self:getIsActive() then
		if self.lastAcceleration ~= 0 then
			if self.footThrottle.index ~= nil then
				local footThrottleMovement = self.lastAcceleration/4;
				if footThrottleMovement < 0 then
					footThrottleMovement = -footThrottleMovement;
				end;
				setRotation(self.footThrottle.index, -footThrottleMovement, 0, 0);
			end;
		end;
			
			if (self.ignitionMode == nil or self.ignitionMode >= 2) and self.speedoMeter.index ~= nil then
				local rotX, rotY, rotZ = getRotation(self.speedoMeter.index);

				local kmh = math.min(100, math.max(0, self.lastSpeed*self.speedDisplayScale*3600)) - 0.00008 *dt;
				
				if kmh < self.speedoMeter.firstSpeed then
					local speedRot = math.rad(kmh * self.speedoMeter.speedPercentageFirst);
					setRotation(self.speedoMeter.index, rotX, speedRot, rotZ);
				elseif kmh < self.speedoMeter.middleSpeed then
					local speedRot = math.rad((kmh - self.speedoMeter.firstSpeed) * self.speedoMeter.speedPercentageMiddle) + math.rad(self.speedoMeter.firstSpeed * self.speedoMeter.speedPercentageFirst);
					setRotation(self.speedoMeter.index, rotX, speedRot, rotZ);
				elseif kmh < self.speedoMeter.maxSpeed then
					local speedRot = math.rad((kmh - self.speedoMeter.middleSpeed) * self.speedoMeter.speedPercentageMax) + math.rad((self.speedoMeter.middleSpeed - self.speedoMeter.firstSpeed) * self.speedoMeter.speedPercentageMiddle) + math.rad(self.speedoMeter.firstSpeed * self.speedoMeter.speedPercentageFirst);
					setRotation(self.speedoMeter.index, rotX, speedRot, rotZ);
				else
				end;
					
			end;
			
			if self.fuelMeter.index ~= nil then
				local rotX, rotY, rotZ = getRotation(self.fuelMeter.index);
				if self.fuelMeter.modifier == 1 then
					local fuelDifference = self.fuelCapacity - self.fuelFillLevel;
					local fuelMeterRot = math.rad(fuelDifference/100)*self.fuelMeter.fuelPercentage*10;
					if rotY < -fuelMeterRot and self.fuelMeter.hasMovedUp ~= true then
						setRotation(self.fuelMeter.index, 0, rotY + dt * 0.001 , 0);
					else
						self.fuelMeter.hasMovedUp = true;
						setRotation(self.fuelMeter.index, 0, -fuelMeterRot , 0);
					end;
				elseif self.fuelMeter.modifier == -1 then
					local fuelMeterRot = math.rad(self.fuelFillLevel*self.fuelMeter.fuelPercentage);
					if rotY > -fuelMeterRot and self.fuelMeter.hasMovedUp ~= true then
						setRotation(self.fuelMeter.index, 0, rotY - dt * 0.001 , 0);
					else
						self.fuelMeter.hasMovedUp = true;
						setRotation(self.fuelMeter.index, 0, -fuelMeterRot , 0);
					end;
				end;
			end;
	
			if self.movingDirection == 1 and self.lastAcceleration <= 0 or self.movingDirection == -1 and self.lastAcceleration >= 0 or self.lastAcceleration == 0 then
				if self.clutchPedal.index ~= nil then
					local rotX, rotY, rotZ = getRotation(self.clutchPedal.index);
					if rotX > self.clutchPedal.maxRot then
						setRotation(self.clutchPedal.index, rotX - dt * self.clutchPedal.movementSpeed, rotY, rotZ);
					end;
				end;
			else
				if self.clutchPedal.index ~= nil then
					local rotX, rotY, rotZ = getRotation(self.clutchPedal.index);
					if rotX < self.clutchPedal.minRot then
						setRotation(self.clutchPedal.index, rotX + dt * self.clutchPedal.movementSpeed, rotY, rotZ);
					end;
				end;
			end;
			
			if self.movingDirection == 1 and self.lastAcceleration <= 0 or self.movingDirection == -1 and self.lastAcceleration >= 0 then
				if self.brakePedal.index ~= nil then
					local rotX1, rotY1, rotZ1 = getRotation(self.brakePedal.index);
					if rotX1 > self.brakePedal.maxRot then
						setRotation(self.brakePedal.index, rotX1 - dt * (self.brakePedal.movementSpeed/2), rotY, rotZ);
					end;
				end;
			else
				if self.brakePedal.index ~= nil then
					local rotX1, rotY1, rotZ1 = getRotation(self.brakePedal.index);
					if rotX1 < self.brakePedal.minRot then
						setRotation(self.brakePedal.index, rotX1 + dt * self.brakePedal.movementSpeed, rotY, rotZ);
					end;
				end;
			end;
		else
			if self.clutchPedal.index ~= nil then
				local rotX, rotY, rotZ = getRotation(self.clutchPedal.index);
				if rotX < self.clutchPedal.minRot then
					setRotation(self.clutchPedal.index, rotX + dt * self.clutchPedal.movementSpeed, rotY, rotZ);
				end;
			end;
			
			if self.brakePedal.index ~= nil then
				local rotX1, rotY1, rotZ1 = getRotation(self.brakePedal.index);
				if rotX1 < self.brakePedal.minRot then
					setRotation(self.brakePedal.index, rotX1 + dt * self.brakePedal.movementSpeed, rotY, rotZ);
				end;
			end;
	
			if self.fuelMeter.index ~= nil then
				local rotX, rotY, rotZ = getRotation(self.fuelMeter.index);
				if self.fuelMeter.modifier == 1 then
					if rotY > self.fuelMeter.startRot and self.fuelMeter.hasMovedUp == true then
						setRotation(self.fuelMeter.index, 0, rotY - dt * 0.001 , 0);
					else
						self.fuelMeter.hasMovedUp = false;
					end;
				elseif self.fuelMeter.modifier == -1 then
					if rotY < self.fuelMeter.startRot and self.fuelMeter.hasMovedUp == true then
						setRotation(self.fuelMeter.index, 0, rotY + dt * 0.001 , 0);
					else
						self.fuelMeter.hasMovedUp = false;
					end;
				end;
			end;	
		end;
end;

function MovingPartsInterior:updateTick(dt)
end;

function MovingPartsInterior:draw()	
end;