--
-- InteractiveButtons
-- Specialization for an interactive control button
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.1
-- @date  		29/08/11
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--				v2.1 - improvements
--
-- free for noncommerical-usage
--

InteractiveButtons = {};

function InteractiveButtons.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(InteractiveControl, specializations);
end;

function InteractiveButtons:load(xmlFile)

	local i=0;
	while true do
		local buttonName = string.format("vehicle.interactiveComponents.buttons.button(%d)", i);	
		if not hasXMLProperty(xmlFile, buttonName) then
			break;
		end;
		local name = Utils.getNoNil(g_i18n:getText(getXMLString(xmlFile, buttonName .. "#name")), "ERROR");
		local mark = Utils.indexToObject(self.components, getXMLString(xmlFile, buttonName .. "#mark"));
		local highlight = getChildAt(mark, 0);
		local size = Utils.getNoNil(getXMLFloat(xmlFile, buttonName .. "#size"), 0.1);
		local event = getXMLString(xmlFile, buttonName .. "#event");
		local onMessage = g_i18n:getText(Utils.getNoNil(getXMLString(xmlFile, buttonName .. "#onMessage"), "ic_button_on"));
		local offMessage =  g_i18n:getText(Utils.getNoNil(getXMLString(xmlFile, buttonName .. "#offMessage") , "ic_button_off"));
	
		local button = Button:new(nil, highlight, name, mark, size, event, self, onMessage, offMessage, self.infoBar);
		
		button.synch = Utils.getNoNil(getXMLBool(xmlFile, buttonName .. "#synch"), true);

		table.insert(self.interactiveObjects, button);
		i = i + 1;
	end;
end;

function InteractiveButtons:delete()
end;

function InteractiveButtons:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveButtons:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveButtons:update(dt)	
end;

function InteractiveButtons:draw()
end;



--
-- Button Class
-- Specifies an interactive Button
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  29/08/11
--

Button = {};

function Button:new(node, highlight, name, mark, size, event, vehicle, onMessage, offMessage, infobar)

	local Button_mt = Class(Button, InteractiveComponentInterface);	
    local instance = InteractiveComponentInterface:new(node, highlight, name, mark, size, onMessage, offMessage, infobar, Button_mt);

	instance.vehicle = vehicle;
	instance.event = event;
	
	return instance;	
end;

function Button:delete()
	InteractiveComponentInterface.delete(self);
end;

function Button:mouseEvent(posX, posY, isDown, isUp, button)
	InteractiveComponentInterface.mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Button:keyEvent(unicode, sym, modifier, isDown)
	InteractiveComponentInterface.keyEvent(self, unicode, sym, modifier, isDown);
end;

function Button:update(dt)
	if self.vehicle ~= nil then
	    if self.event == "toggleFrontLight" then
	        self.isOpen = (self.vehicle.lightsTypesMask == 1 or self.vehicle.lightsTypesMask == 3 or self.vehicle.lightsTypesMask == 5);
	    elseif self.event == "toggleWorkLightFront" then
	        self.isOpen = (self.vehicle.lightsTypesMask == 2 or self.vehicle.lightsTypesMask == 3);
	    elseif self.event == "toggleWorkLightRear" then
	        self.isOpen = (self.vehicle.lightsTypesMask == 4 or self.vehicle.lightsTypesMask == 5);
	    elseif self.event == "toggleIgnition" then
	        self.isOpen = (self.vehicle.ignitionMode == 2);
		end;
	end;
	InteractiveComponentInterface.update(self, dt);
end;

function Button:draw()
	InteractiveComponentInterface.draw(self);
end;

function Button:doAction(noEventSend, forceAction)
	if self.vehicle ~= nil then
		if self.event == "toggleFrontLight" then
            if forceAction == nil then
			    if self.vehicle.lightsTypesMask == 0 then
				    self.vehicle:setLightsTypesMask(1, true);
			    elseif self.vehicle.lightsTypesMask == 1 then
				    self.vehicle:setLightsTypesMask(0, true);
			    elseif self.vehicle.lightsTypesMask == 2 then
				    self.vehicle:setLightsTypesMask(3, true);
			    elseif self.vehicle.lightsTypesMask == 3 then
				    self.vehicle:setLightsTypesMask(2, true);
			    elseif self.vehicle.lightsTypesMask == 4 then
				    self.vehicle:setLightsTypesMask(5, true);
			    elseif self.vehicle.lightsTypesMask == 5 then
				    self.vehicle:setLightsTypesMask(4, true);
			    end;
			end;
		elseif self.event == "toggleWorkLightFront" then
            if forceAction == nil then
			    if self.vehicle.lightsTypesMask == 0 then
				    self.vehicle:setLightsTypesMask(2, true);
			    elseif self.vehicle.lightsTypesMask == 1 then
				    self.vehicle:setLightsTypesMask(2, true);
			    elseif self.vehicle.lightsTypesMask == 2 then
				    self.vehicle:setLightsTypesMask(0, true);
			    elseif self.vehicle.lightsTypesMask == 3 then
				    self.vehicle:setLightsTypesMask(1, true);
			    elseif self.vehicle.lightsTypesMask == 4 then
				    self.vehicle:setLightsTypesMask(2, true);
			    elseif self.vehicle.lightsTypesMask == 5 then
				    self.vehicle:setLightsTypesMask(3, true);
			    end;
			end;
		elseif self.event == "toggleWorkLightRear" then
            if forceAction == nil then
			    if self.vehicle.lightsTypesMask == 0 then
				    self.vehicle:setLightsTypesMask(4, true);
			    elseif self.vehicle.lightsTypesMask == 1 then
				    self.vehicle:setLightsTypesMask(5, true);
			    elseif self.vehicle.lightsTypesMask == 2 then
				    self.vehicle:setLightsTypesMask(4, true);
			    elseif self.vehicle.lightsTypesMask == 3 then
				    self.vehicle:setLightsTypesMask(5, true);
			    elseif self.vehicle.lightsTypesMask == 4 then
				    self.vehicle:setLightsTypesMask(0, true);
			    elseif self.vehicle.lightsTypesMask == 5 then
				    self.vehicle:setLightsTypesMask(1, true);
			    end;
			end;
		elseif self.event == "toggleIgnition" then
            if forceAction == nil then
				if self.vehicle.ignitionMode == 0 then
					self.vehicle:setManualIgnitionMode(1, true);
				elseif self.vehicle.ignitionMode == 1 then
					self.vehicle:setManualIgnitionMode(2, true);
				elseif self.vehicle.ignitionMode == 2 then
					self.vehicle:setManualIgnitionMode(0, true);
				end;
			end;
        end;		
	end;
end;

function Button:onEnter(dt)
	InteractiveComponentInterface.onEnter(self, dt);
end;

function Button:onExit(dt)
	InteractiveComponentInterface.onExit(self, dt);
end;

function Button:setActive()
	InteractiveComponentInterface.setActive(self, isActive);
end;

function Button:setVisible(isVisible)
	InteractiveComponentInterface.setVisible(self, isVisible);
end;