--
-- Specialization for Deutz Fahr 6207
--
-- @author:    	Xentro (www.fs-uk.com)(Marcus@Xentro.se)
-- @version:    v0.1
-- @date:       2013-03-03
-- @edit:		Martl; used code of fruktor and John Deere 6930
--
Vehicle.registerJointType("deutzLoader");
Vehicle.registerJointType("deutzBucket");

DeutzFahr6207 = {};

function DeutzFahr6207.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function DeutzFahr6207:load(xmlFile)
	self.rearCoupling = {};
	self.rearCoupling.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rearCoupling#index"));
	self.rearCoupling.topArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rearCoupling#topArm"));
	
	for i,j in pairs(self.mc[3]) do
		local x,y,z = getTranslation(self.movingTools[j].node);
		self.movingTools[j].origPos = {x,y,z};		
	end;
		
	self.lastRotXArm1 = 0;
	self.arm1 = {};
	self.arm1.idx = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontlader.hauptarm#index"));
	self.arm1.charset = getAnimCharacterSet(self.arm1.idx);
	self.arm1.clipIdx = getAnimClipIndex(self.arm1.charset, getXMLString(xmlFile, "vehicle.frontlader.hauptarm#clip"));	
	assignAnimTrackClip(self.arm1.charset, 0, self.arm1.clipIdx);
	setAnimTrackLoopState(self.arm1.charset, 0, false);
	self.arm1.duration = getAnimClipDuration(self.arm1.charset, self.arm1.clipIdx);	
	
	local x1,y1,z1 = getRotation(self.movingTools[1].node);
	local prct = (x1 - self.movingTools[1].rotMin) / (self.movingTools[1].rotMax - self.movingTools[1].rotMin);
	self.lastRotXArm1 = x1;
	enableAnimTrack(self.arm1.charset, 0);
	setAnimTrackTime(self.arm1.charset, 0, prct*self.arm1.duration, true);
	disableAnimTrack(self.arm1.charset, 0);			

    self.setIncreaseRpm = SpecializationUtil.callSpecializationsFunction("setIncreaseRpm");
    self.saveMinimumRpm = self.motor.minRpm;	
end;

function DeutzFahr6207:delete()
end;

function DeutzFahr6207:mouseEvent(posX, posY, isDown, isUp, button)
end;

function DeutzFahr6207:keyEvent(unicode, sym, modifier, isDown)
end;

function DeutzFahr6207:update(dt)
	if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.RESET_MOVEABLE_SEAT_MC) then							-- 
				for i,j in pairs(self.mc[3]) do
					setTranslation(self.movingTools[j].node, unpack(self.movingTools[j].origPos));
					self.movingTools[j].curTrans = { unpack(self.movingTools[j].origPos) };
					Cylindered.setDirty(self, self.movingTools[j]);
				end;
			end;		
		end;
	end;
	
	if self.isClient then
		if self:getIsActive() then
			local rpmInc = 0;
			
			local x1,y1,z1 = getRotation(self.movingTools[1].node);
			if x1 ~= self.lastRotXArm1 then
				local prct = (x1 - self.movingTools[1].rotMin) / (self.movingTools[1].rotMax - self.movingTools[1].rotMin);
				self.lastRotXArm1 = x1;
				enableAnimTrack(self.arm1.charset, 0);
				setAnimTrackTime(self.arm1.charset, 0, prct*self.arm1.duration, true);
				disableAnimTrack(self.arm1.charset, 0);	
				rpmInc = rpmInc + 180;
			end

			if rpmInc ~= 0 then
				self:setIncreaseRpm(dt, rpmInc, true);
			else
				self:setIncreaseRpm(dt, rpmInc, false);
			end;
		end
	end;
end;

function DeutzFahr6207:updateTick(dt)
	if self.extraWeights ~= nil then
		if self.extraWeights.currentLevel > 0 then
			self.attacherJoints[5].jointIndex = -2;
		else
			if self.attacherJoints[5].jointIndex == -2 then
				self.attacherJoints[5].jointIndex = 0;
			elseif self.attacherJoints[5].jointIndex == -1 or self.attacherJoints[5].jointIndex > 0 then
				self.extraWeights.allowInput = false;
			elseif self.attacherJoints[5].jointIndex == 0 then
				self.extraWeights.allowInput = true;
			end;
		end;
	end;
end;

function DeutzFahr6207:draw()	
	g_currentMission:addHelpButtonText(g_i18n:getText("RESET_MOVEABLE_SEAT_MC"), InputBinding.RESET_MOVEABLE_SEAT_MC);
end;

function DeutzFahr6207:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;
	
	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if jointIndex == 1 then
			setVisibility(self.rearCoupling.node, false);
			setVisibility(self.rearCoupling.topArm, true);
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILER or jointType == Vehicle.JOINTTYPE_TRAILERLOW then	
			setVisibility(self.rearCoupling.node, true);
			setVisibility(self.rearCoupling.topArm, false);
	end;
	self.updateJoint = true;
end;

function DeutzFahr6207:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;
	if jointIndex == 1 then
		setVisibility(self.rearCoupling.node, true);
		setVisibility(self.rearCoupling.topArm, false);
	end;
end;

function DeutzFahr6207:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;

function DeutzFahr6207:onLeave()
end;

function DeutzFahr6207:onEnter()
end;

function DeutzFahr6207:setIncreaseRpm(dt, increase, isActive)

	if self.saveMinimumRpm ~= 0 then
		if dt ~= nil then
			if isActive == true then
				self.motor.minRpm = math.max(self.motor.minRpm-(dt*2), -increase);
			else
				self.motor.minRpm = math.min(self.motor.minRpm+(dt*5), self.saveMinimumRpm);
			end;
		else
			self.motor.minRpm = self.saveMinimumRpm;
		end;
		if self.isMotorStarted then
			local fuelUsed = 0.00000004*math.abs(self.motor.minRpm);
			self:setFuelFillLevel(self.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;