SetIsAutoSteerBackStoppedEvent = {};
SetIsAutoSteerBackStoppedEvent_mt = Class(SetIsAutoSteerBackStoppedEvent, Event);

InitEventClass(SetIsAutoSteerBackStoppedEvent, "SetIsAutoSteerBackStoppedEvent");

function SetIsAutoSteerBackStoppedEvent:emptyNew()
    local self = Event:new(SetIsAutoSteerBackStoppedEvent_mt);
    self.className = "SetIsAutoSteerBackStoppedEvent";
    return self;
end;

function SetIsAutoSteerBackStoppedEvent:new(object, isStopped)
    local self = SetIsAutoSteerBackStoppedEvent:emptyNew()
    self.object = object;
	self.isStopped = isStopped;
    return self;
end;

function SetIsAutoSteerBackStoppedEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isStopped = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetIsAutoSteerBackStoppedEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isStopped);
end;

function SetIsAutoSteerBackStoppedEvent:run(connection)
    self.object:setIsAutoSteerBackStopped(self.isStopped, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetIsAutoSteerBackStoppedEvent:new(self.object, self.isStopped), nil, connection, self.object);
    end;
end;

function SetIsAutoSteerBackStoppedEvent.sendEvent(vehicle, isStopped, noEventSend)
    if isStopped ~= vehicle.autoSteerBack.isStopped then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(SetIsAutoSteerBackStoppedEvent:new(vehicle, isStopped), nil, nil, vehicle);
            else
                g_client:getServerConnection():sendEvent(SetIsAutoSteerBackStoppedEvent:new(vehicle, isStopped));
            end;
        end;
    end;
end;