--
-- AlternativeTippingShovel
--
-- @author:    	Xentro (www.fs-uk.com)(Marcus@Xentro.se)
-- @version:    v1.0
-- @date:       2013-05-05
--
--

AlternativeTippingShovel = {};

function AlternativeTippingCombine:shovelLoad(xmlFile)
	local node = getXMLString(xmlFile, "vehicle.alternativeTipping#loadPoint");
	self.altTipRayDistance = getXMLString(xmlFile, "vehicle.alternativeTipping#rayDistance");
	
	if node ~= nil then
		node = Utils.indexToObject(self.components, node);
	else
		node = self.shovelTipReferenceNode;
	end;
	
	self.altTipPoint = node;
	
	if self.altTipPoint == nil then
		if self.shovelNodes ~= nil then
			for n in pairs(self.shovelNodes) do
				self.altTipPoint = n;
				break;
			end;
		else
			print("Warning: It's strongly suggested that you add an shovelTipReferenceNode or shovelNode to " .. tostring(self.customEnvironment));
		end;
	end;
	
	self.overrideAltHeapShovelLoad = false;
end;
Shovel.load = Utils.appendedFunction(Shovel.load, AlternativeTippingCombine.shovelLoad);

function AlternativeTippingShovel:shovelUpdateTick(dt)
	if self:getIsActive() and not self.overrideAltHeapShovelLoad then
		local emptySpeed = self:getShovelEmptyingSpeed();
		
		if emptySpeed <= 0 then
			if self.altTipPoint ~= nil then
				self.objectFound = nil;
				-- self.trailerFound = nil;
				
				if self.fillLevel < self.capacity and g_currentMission.shovelRayDistance ~= nil then
					local x, y, z = getWorldTranslation(self.altTipPoint);
					raycastAll(x, y, z, 0, -1, 0, "findTrailerRaycastCallback", Utils.getNoNil(self.altTipRayDistance, g_currentMission.shovelRayDistance), self);
					
					if self.objectFound ~= nil then
						if self.objectFound.isExtendedTrigger then
							self.objectFound:addShovel(self);
						end;
					end;
				end;
			end;
		end;
	end;
end;
Shovel.updateTick = Utils.appendedFunction(Shovel.updateTick, AlternativeTippingShovel.shovelUpdateTick);

function AlternativeTippingShovel:findTrailerRaycastCallback(superFunc, transformId, x, y, z, distance)
	local trailer = g_currentMission.objectToTrailer[transformId];
	if trailer ~= nil and trailer ~= self then
		if trailer:allowFillType(self.currentFillType) and trailer.getAllowFillFromAir ~= nil and trailer:getAllowFillFromAir() then
			self.trailerFound = trailer;
			self.trailerFoundSupported = true;
		else
			if self.trailerFound == nil then
				self.trailerFound = trailer;
				self.trailerFoundSupported = false;
			end
		end
		
		return false;
	end;
	
	local object = g_currentMission:getNodeObject(transformId);
	if object ~= nil and object ~= self and object.addShovelFillLevel ~= nil and object.getAllowShovelFillType ~= nil then
		local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, y, z);
		
		if y > (terrainHeight - g_currentMission.shovelTerrainHeapHeightOffset) then	-- only allow unload to heaps above ground level.
			if object:getAllowShovelFillType(self.currentFillType) then
				self.objectFound = object;
				self.objectFoundSupported = true;
			else
				if self.objectFound == nil then
					self.objectFound = object;
					self.objectFoundSupported = false;
				end;
			end;
			
			return false;
		end;
	end;
	return true;
end;
Shovel.findTrailerRaycastCallback = Utils.overwrittenFunction(Shovel.findTrailerRaycastCallback, AlternativeTippingShovel.findTrailerRaycastCallback);

function AlternativeTippingShovel:load(xmlFile)
	if SpecializationUtil.hasSpecialization(Shovel, self.specializations) then
		if g_currentMission.alternativeTipTrigger ~= nil then
			if not g_currentMission.alternativeTipTrigger.overrideTrailerFruitLimit then
				for fillType in pairs(self.fillTypes) do
					if fillType ~= Fillable.FILLTYPE_UNKNOWN then
						if not g_currentMission.alternativeTipTrigger:isTrailerFruitAllowed(fillType) then
							g_currentMission.alternativeTipTrigger:addTrailerFruit(fillType);
						end;
					end;
				end;
			end;
		end;
	end;
end;
Fillable.load = Utils.appendedFunction(Fillable.load, AlternativeTippingShovel.load);

function AlternativeTippingShovel:delete()
	if SpecializationUtil.hasSpecialization(Shovel, self.specializations) then
		if g_currentMission.alternativeTipTrigger ~= nil then
			if not g_currentMission.alternativeTipTrigger.overrideTrailerFruitLimit then
				for fillType in pairs(self.fillTypes) do
					if fillType ~= Fillable.FILLTYPE_UNKNOWN then
						if fillType ~= Fillable.FILLTYPE_SUGARBEET and fillType ~= Fillable.FILLTYPE_POTATO and (Fillable.FILLTYPE_ONION ~= nil and fillType ~= Fillable.FILLTYPE_ONION) and (Fillable.FILLTYPE_CARROT ~= nil and fillType ~= Fillable.FILLTYPE_CARROT) and fillType ~= Fillable.FILLTYPE_SILAGE and fillType ~= Fillable.FILLTYPE_MANURE then
							g_currentMission.alternativeTipTrigger:removeTrailerFruit(fillType);
							g_currentMission.alternativeTipTrigger.updateShovel = true;
						end;
					end;
				end;
			end;
		end;
	end;
end;
Fillable.delete = Utils.appendedFunction(Fillable.delete, AlternativeTippingShovel.delete);

function AlternativeTippingShovel:updateTick(dt)
	if g_currentMission.alternativeTipTrigger ~= nil then
		if SpecializationUtil.hasSpecialization(Shovel, self.specializations) then
			if not g_currentMission.alternativeTipTrigger.overrideTrailerFruitLimit then
				if g_currentMission.alternativeTipTrigger.updateShovel or g_currentMission.alternativeTipTrigger.forceUpdateShovel then
					for fillType in pairs(self.fillTypes) do
						if fillType ~= Fillable.FILLTYPE_UNKNOWN then
							if not g_currentMission.alternativeTipTrigger:isTrailerFruitAllowed(fillType) then
								g_currentMission.alternativeTipTrigger:addTrailerFruit(fillType);
							end;
						end;
					end;
					
					g_currentMission.alternativeTipTrigger.updateShovel = false;
					g_currentMission.alternativeTipTrigger.forceUpdateShovel = false;
				end;
			end;
			
			if self.fillLevel == 0 and self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
				self:setFillLevel(0, Fillable.FILLTYPE_UNKNOWN, true);
			end;
		end;
	end;
end;
Fillable.updateTick = Utils.appendedFunction(Fillable.updateTick, AlternativeTippingShovel.updateTick);