--
-- DynamicUnloading
-- Specialization for DynamicUnloading
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		02/11/11
-- @history:	v1.0 - Initial version
--

DynamicUnloading = {};

function DynamicUnloading.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function DynamicUnloading:load(xmlFile)
	self.dynamicUnloading = {};
	self.dynamicUnloading.backup = self.literPerSecond;
	self.dynamicUnloading.time = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.dynamicUnloading#time"), 8) * 1000;	
	
end;

function DynamicUnloading:delete()
end;

function DynamicUnloading:readStream(streamId, connection)
end;

function DynamicUnloading:writeStream(streamId, connection)
end;

function DynamicUnloading:mouseEvent(posX, posY, isDown, isUp, button)
end;

function DynamicUnloading:keyEvent(unicode, sym, modifier, isDown)
end;

function DynamicUnloading:update(dt)
end;

function DynamicUnloading:updateTick(dt)

	if self.augerState then
		if self.savePS ~= nil then
			local newScale = Utils.getMovedLimitedValues({self.literPerSecond}, {self.dynamicUnloading.backup}, {1}, 1, self.dynamicUnloading.time, dt, false);
			self.literPerSecond = newScale[1];
			local scale = self.literPerSecond / self.dynamicUnloading.backup;
			setShaderParameter(self.savePS[1].shape, "alphaScale", scale, 0, 0, 0, false);
		end;
	else
		if self.literPerSecond ~= 1 then
			local newScale = Utils.getMovedLimitedValues({self.literPerSecond}, {self.dynamicUnloading.backup}, {1}, 1, self.dynamicUnloading.time / 3, dt, true);
			self.literPerSecond = newScale[1];
		end;
	end;
end;

function DynamicUnloading:draw()
end;