--
-- Light
-- author: werik
--

Light = {};

function Light.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Light:load(xmlFile)
      self.thenlight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.thenlight#index"));
      self.thenlightActive = false;

      self.cabinlight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cabinlight#index"));
      self.cabinlightActive = false;

      self.pipelight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipelight#index"));
      self.pipelightActive = false;

      self.pipeIslight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeIslight#index"));
      self.pipeIslightActive = false;
end;

function Light:readStream(streamId, connection)
end;

function Light:writeStream(streamId, connection)
end;

function Light:delete()
end;

 
function Light:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Light:keyEvent(unicode, sym, modifier, isDown)
if isDown and sym == Input.KEY_k then
	    self.cabinlightActive = not self.cabinlightActive;
	end;
if isDown and sym == Input.KEY_l then
	    self.pipelightActive = not self.pipelightActive;
	end;
end;
 
function Light:update(dt)

if self.isThreshing then
	setVisibility(self.thenlight, self.thenlightActive);
	self.thenlightActive = true;
         else
             setVisibility(self.thenlight, self.thenlightActive);
             self.thenlightActive = false;
     end;
if self.isEntered then
		setVisibility(self.cabinlight, self.cabinlightActive);
	end;
if self.isEntered then
		setVisibility(self.pipelight, self.pipelightActive);
	end;
 if self.pipeIsUnloading then
	setVisibility(self.pipeIslight, self.pipeIslightActive);
	self.pipeIslightActive = true;
         else
             setVisibility(self.pipeIslight, self.pipeIslightActive);
             self.pipeIslightActive = false;
     end;
end;

function Light:onLeave()
end;

function Light:draw()
end;
