--
-- Rolles
-- author: werik
--

Rolles = {};

function Rolles.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cylindered, specializations);
end;

function Rolles:load(xmlFile)
	
self.wentelatorNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wentelator#index"));
	self.wentelatorRotationScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wentelator#rotationScale"), 1);
	self.isTurnedOn = false;

end;

function Rolles:readStream(streamId, connection)
end;

function Rolles:writeStream(streamId, connection)
end;

function Rolles:delete()
end;

 
function Rolles:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Rolles:keyEvent(unicode, sym, modifier, isDown)

     if isDown then
		if sym == Input.KEY_k then
			if self.isTurnedOn == false then
				self.isTurnedOn = true;
			else
				self.isTurnedOn = false;
			end;
		end;		
		
	end;
end;
 
function Rolles:update(dt)
        if self.isTurnedOn then
        if self.wentelatorNode1 ~= nil then
				rotate(self.wentelatorNode1, self.wentelatorRotationScale * 5 * 1, 0, 0);
			end;			

        end;
end;

function Rolles:onLeave()
end;

function Rolles:draw()
end;
