--
-- PowerShaft
-- Specialization for PowerShaft
--
-- @author  Manuel Leithner
-- @date  26/07/09
---------------------------------------
-- hydraulic hose
-- Specialization for hydraulic hose joint
--
-- @author  PeterJ - LS-UK modteam
-- @date  02/06/2012
--
-- Copyright (C) FS-UK modteam, Confidential, All Rights Reserved.
--

ImplementLinksJF1450 = {};
ImplementLinksJF1450.stat = {};

function ImplementLinksJF1450.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function ImplementLinksJF1450:load(xmlFile)
	
	---- attachable pto ----
	self.powerShaft = {};		
	self.powerShaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ImplementLinks.powerShaft#index"));
	local x,y,z = getRotation(self.powerShaft.node);
	self.powerShaft.rot = {x,y,z};
	self.powerShaft.part = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ImplementLinks.powerShaft#part"));
	x,y,z = getTranslation(self.powerShaft.part);
	self.powerShaft.trans = {x,y,z};
	self.powerShaft.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ImplementLinks.powerShaft#fixPoint"));
	if self.powerShaft.node ~= nil then
		local ax, ay, az = getWorldTranslation(self.powerShaft.part);
		local bx, by, bz = getWorldTranslation(self.powerShaft.fixPoint);		
		self.powerShaft.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		self.usePTO = true;
		self.PTOattached = self.powerShaft.node;
	end;
	self.attacherVehiclePowerShaft = nil;
	
	self.setPTO = SpecializationUtil.callSpecializationsFunction("setPTO");
	self.PTOdeattached = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ImplementLinks.powerShaft#deattached"));
	self.enableManualPTOattach = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.ImplementLinks.powerShaft#manualAttach"), false);	
	if self.enableManualPTOattach then	
		setVisibility(self.PTOdeattached,true);
		setVisibility(self.PTOattached,false);
	else
		setVisibility(self.PTOdeattached,false);
		setVisibility(self.PTOattached,true);
	end;
	
	self.PTOJFId = true;
	
	---- hydraulic hose ----
	self.hose = {};		
	self.hose.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ImplementLinks.hose#index"));
	local x,y,z = getRotation(self.hose.node);
	self.hose.rot = {x,y,z};
	self.hose.part = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ImplementLinks.hose#part"));
	x,y,z = getTranslation(self.hose.part);
	self.hose.trans = {x,y,z};
	self.hose.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ImplementLinks.hose#fixPoint"));
	if self.hose.node ~= nil then
		local ax, ay, az = getWorldTranslation(self.hose.part);
		local bx, by, bz = getWorldTranslation(self.hose.fixPoint);		
		self.hose.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		self.useHose = true;
	end;
	self.attacherVehicleHose = nil;
	
	self.doJointSearch = false;
end;

function ImplementLinksJF1450:delete()
end;

function ImplementLinksJF1450:readStream(streamId, connection)
	self.isLoading = true;
	local PTO = streamReadBool(streamId);
	self:setPTO(PTO, true);
end;
  
function ImplementLinksJF1450:writeStream(streamId, connection)
	streamWriteBool(streamId, self.PTOJFId);
end;

function ImplementLinksJF1450:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local PTOlinked = getXMLBool(xmlFile, key.."#PTOdetached");
		if PTOlinked ~= nil then
			self:setPTO(PTOlinked);
			self.PTOJFId = PTOlinked;
		end;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;
  
function ImplementLinksJF1450:getSaveAttributesAndNodes(nodeIdent)
	local attributes = ' ';

	local mystring = 'PTOdetached="' .. tostring(self.PTOJFId) ..'"';	
	attributes = attributes .. mystring;

    local node = nil;
	return attributes, node;
end;

function ImplementLinksJF1450:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ImplementLinksJF1450:keyEvent(unicode, sym, modifier, isDown)
end;

function ImplementLinksJF1450:update(dt)
	
	if self.doJointSearch then
		for i=1, table.getn(self.attacherVehicle.attachedImplements) do
			if self.attacherVehicle.attachedImplements[i].object == self then			
				local index = self.attacherVehicle.attachedImplements[i].jointDescIndex;
				local joint = self.attacherVehicle.attacherJoints[index];	
				if joint.powerShaftAttacher ~= nil then
					self.attacherVehiclePowerShaft = joint.powerShaftAttacher;
				end;
				if joint.hydrahoseAttacher ~= nil then
					self.attacherVehicleHose = joint.hydrahoseAttacher;
				end;
			end;
		end;
		self.doJointSearch = false;
	end;
	

	
	if self.enableManualPTOattach then
		if not self:getIsActive() and self.isAttached then
			if self.playerInRange then
				if InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
					self:setPTO(not self.PTOJFId);
				end;
				if self.PTOJFId then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("ATTACHPTOJF"), self.typeDesc), InputBinding.ACTIVATE_OBJECT);
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("DETACHPTOJF"), self.typeDesc), InputBinding.ACTIVATE_OBJECT);
				end;
			end;
		end;
	end;
	
end;

function ImplementLinksJF1450:updateTick(dt)	

	if g_currentMission.player ~= nil and self.PTOdeattached ~= nil then
		local nearestDistance = 2.5;
		local x1,y1,z1 = getWorldTranslation(self.PTOdeattached);
		local x2,y2,z2 = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(x1-x2,y1-y2,z1-z2);
		if distance < nearestDistance then
			self.playerInRange = true; 
		else
			self.playerInRange = false; 
		end;
	end;
	
	if self:getIsActive() or not self:getIsActive() then
		if self.attacherVehiclePowerShaft ~= nil and self.usePTO then		
			local ax, ay, az = getWorldTranslation(self.powerShaft.node);
			local bx, by, bz = getWorldTranslation(self.attacherVehiclePowerShaft);
			local x, y, z = worldDirectionToLocal(getParent(self.powerShaft.node), bx-ax, by-ay, bz-az);
			setDirection(self.powerShaft.node, x, y, z, 0, -1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.powerShaft.part, 0, 0, distance-self.powerShaft.distance);		
		end;
		if self.attacherVehicleHose ~= nil and self.useHose then		
			local ax, ay, az = getWorldTranslation(self.hose.node);
			local bx, by, bz = getWorldTranslation(self.attacherVehicleHose);
			local x, y, z = worldDirectionToLocal(getParent(self.hose.node), bx-ax, by-ay, bz-az);
			setDirection(self.hose.node, x, y, z, 0, 1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setScale(self.hose.part, 1, 1, distance/self.hose.distance);
		end;		
	end;
end;

function ImplementLinksJF1450:draw()
end;

function ImplementLinksJF1450:onAttach(attacherVehicle)
	self.isAttached = true;
	self.doJointSearch = true;
end;

function ImplementLinksJF1450:onDetach()
	self.isAttached = false;
	self.PTOJFId = true;
	if self.PTOJFId then	
		setTranslation(self.powerShaft.part, unpack(self.powerShaft.trans));
		setRotation(self.powerShaft.node, unpack(self.powerShaft.rot));
		self.attacherVehiclePowerShaft = nil;
		if self.enableManualPTOattach then	
			setVisibility(self.PTOdeattached,true);
			setVisibility(self.PTOattached,false);
		end;
	end;
	setRotation(self.hose.node, unpack(self.hose.rot));
	setScale(self.hose.part, 1, 1, 1);
	self.attacherVehicleHose = nil;
end;


function ImplementLinksJF1450:setPTO(PTO, noEventSend)
	if PTO ~= self.PTOJFId then
		 if noEventSend == nil or noEventSend == false then
			  if g_server ~= nil then
				  g_server:broadcastEvent(PTOJFEvent:new(self, PTO), nil, nil, self);
			  else
				  g_client:getServerConnection():sendEvent(PTOJFEvent:new(self, PTO));
			  end;
		  end;	
		  
		self.PTOJFId = PTO;
		
		if not self.PTOJFId then
			setVisibility(self.PTOdeattached,false);
			setVisibility(self.PTOattached,true);
		elseif self.PTOJFId then
			setVisibility(self.PTOdeattached,true);
			setVisibility(self.PTOattached,false);
		end;
	end;
end;

PTOJFEvent = {};
PTOEvent_mt = Class(PTOJFEvent, Event);

InitEventClass(PTOJFEvent, "PTOJFEvent");

function PTOJFEvent:emptyNew()
    local self = Event:new(PTOEvent_mt);
    self.className="PTOJFEvent";
    return self;
end;

function PTOJFEvent:new(object, PTO)
    local self = PTOJFEvent:emptyNew()
    self.object = object;
	self.PTO = PTO;
    return self;
end;

function PTOJFEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.PTO = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function PTOJFEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));	
	streamWriteBool(streamId, self.PTO);	
end;

function PTOJFEvent:run(connection)
	self.object:setPTO(self.PTO, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(PTOJFEvent:new(self.object, self.PTO), nil, connection, self.object);
	end;
end;
