-- NI Modding
--
-- author  	Henly20 
-- date  	20-11-2012.
-- ni_modding@hotmail.com
-- http://nimodding.wordpress.com

Frame = {};

function Frame.prerequisitesPresent(specializations)
	Vehicle.registerJointType("HMV");
    return true;
end;

function Frame:load(xmlFile)
	self.HMVFrame = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.HMVFrame#index"));
 	setVisibility((self.HMVFrame), false);
end;

function Frame:delete()
end;

function Frame:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Frame:keyEvent(unicode, sym, modifier, isDown)
end;

function Frame:update(dt)

	for i, jointDesc in pairs(self.componentJoints) do
		setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;
end;

function Frame:draw()	
	if self:getIsActive() then
			g_currentMission:addExtraPrintText("Key Z/X                                Move Frame in/out");
	end;
end;

function Frame:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function Frame:onAttach(attacherVehicle)


end;

function Frame:onDetach()

end;

function Frame:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;
	if jointIndex == 1 then	
		if jointType == Vehicle.JOINTTYPE_HMV then
			setVisibility((self.HMVFrame), true);
		end;
	end
		
	self.updateJoint = true;	
	
    local object = implement.object;
    if object.attacherJoint.jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		Frame.addJF1450Trigger(self, object);
	end;	
end;

function Frame:detachImplement(implementIndex)

	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;
	
	if jointIndex == 1 then
		setVisibility((self.HMVFrame), false);
	end;

    local object = self.attachedImplements[implementIndex].object;
    if object.attacherJoint.jointType == Vehicle.JOINTTYPE_TRAILERLOW then
        Frame.removeJF1450Trigger(self, object);
    end;	
end;

function Frame.addJF1450Trigger(self, JF1450)
    if self.isServer then
        if JF1450.aiTrailerTrigger ~= nil then
            addTrigger(JF1450.aiTrailerTrigger, "onTrailerTrigger", self);
		end;
    end;
end;

function Frame:removeJF1450Trigger(JF1450)
    if self.isServer then
        if JF1450.aiTrailerTrigger ~= nil then
            removeTrigger(JF1450.aiTrailerTrigger);
        end;
    end;
end;

