variableQLinkW = {};

function variableQLinkW.prerequisitesPresent(specializations) return true; end;

function variableQLinkW:load(xmlFile)	
	self.setcurrentQLinkW = SpecializationUtil.callSpecializationsFunction("setcurrentQLinkW");
	self.currentQLinkW = 4;
	self.qLinkMenuW = false;
	self.qLink_range = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.inputAttacherJoints.inputAttacherJoint#index"));	
	self.changeTires1 = getXMLString(xmlFile, "vehicle.changeTires1#animationName");
	self.changeTires2 = getXMLString(xmlFile, "vehicle.changeTires2#animationName"); end;

function variableQLinkW:delete() end;

function variableQLinkW:readStream(streamId, connection) self:setcurrentQLinkW(streamReadInt8(streamId), true); end;

function variableQLinkW:writeStream(streamId, connection) streamWriteInt8(streamId, self.currentQLinkW); end;

function variableQLinkW:setcurrentQLinkW(int, noEventSend) self.currentQLinkW = int; setcurrentQLinkWEvent.sendEvent(self, int, noEventSend); end;

function variableQLinkW:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local currentQLinkW = getXMLInt(xmlFile, key .. "#currentQLinkW");
	if currentQLinkW ~= nil then self:setcurrentQLinkW(currentQLinkW); end;
	return BaseMission.VEHICLE_LOAD_OK; end;
 
function variableQLinkW:getSaveAttributesAndNodes(nodeIdent) local attributes = 'currentQLinkW="' .. self.currentQLinkW .. '" '; return attributes; end;

function variableQLinkW:mouseEvent(posX, posY, isDown, isUp, button) end;

function variableQLinkW:keyEvent(unicode, sym, modifier, isDown) end;

function variableQLinkW:update(dt)
	if g_currentMission.player ~= nil then
		local nearestDistance1 = 7;	local nearestDistance2 = 100;			
		local x1,y1,z1 = getWorldTranslation(self.qLink_range); local x2,y2,z2 = getWorldTranslation(g_currentMission.player.rootNode);		
		local distance1 = Utils.vector3Length(x1-x2,y1-y2,z1-z2);	
		local distance2 = Utils.vector3Length(g_currentMission.storeSpawnPlaces[1].startX-x2,g_currentMission.storeSpawnPlaces[1].startY-y2,g_currentMission.storeSpawnPlaces[1].startZ-z2);			
		if distance1 < nearestDistance1 and distance2 < nearestDistance2 then
			if not self.qLinkMenuW then
				if InputBinding.hasEvent(InputBinding.VARIABLE_QLINK) then	self.qLinkMenuW = true;	end; end;
			if self.qLinkMenuW then
				if InputBinding.hasEvent(InputBinding.VARIABLE_QLINK_1) and self.currentQLinkW ~= 0 then self.qLinkMenuW = false;
				elseif InputBinding.hasEvent(InputBinding.VARIABLE_QLINK_2) and self.currentQLinkW ~= 1 then self.qLinkMenuW = false;
				elseif InputBinding.hasEvent(InputBinding.VARIABLE_QLINK_3) and self.currentQLinkW ~= 2 then self.qLinkMenuW = false;
				elseif InputBinding.hasEvent(InputBinding.VARIABLE_QLINK_4) and self.currentQLinkW ~= 3 then self.qLinkMenuW = false;
				elseif InputBinding.hasEvent(InputBinding.VARIABLE_QLINK_5) and self.currentQLinkW ~= 4 then self:setcurrentQLinkW(4); g_currentMission:addSharedMoney(-1000); self.qLinkMenuW = false;
				elseif InputBinding.hasEvent(InputBinding.VARIABLE_QLINK_6) and self.currentQLinkW ~= 5 then self:setcurrentQLinkW(5); g_currentMission:addSharedMoney(-1000); self.qLinkMenuW = false;	end; end;
		else self.qLinkMenuW = false; end; end; end;

function variableQLinkW:updateTick(dt)
	if self.currentQLinkW == 0 then	
	elseif self.currentQLinkW == 1 then	
	elseif self.currentQLinkW == 2 then	
	elseif self.currentQLinkW == 3 then		
	elseif self.currentQLinkW == 4 then self:playAnimation(self.changeTires1, 1);
	elseif self.currentQLinkW == 5 then self:playAnimation(self.changeTires2, 1); end; end;

function variableQLinkW:onAttach() end;

function variableQLinkW:onDetach() end;

function variableQLinkW:draw() end;

setcurrentQLinkWEvent = {};
setcurrentQLinkWEvent_mt = Class(setcurrentQLinkWEvent, Event);

InitEventClass(setcurrentQLinkWEvent, "setcurrentQLinkWEvent");

function setcurrentQLinkWEvent:emptyNew() local self = Event:new(setcurrentQLinkWEvent_mt); self.className="setcurrentQLinkWEvent"; return self; end;

function setcurrentQLinkWEvent:new(vehicle, currentQLinkW) local self = setcurrentQLinkWEvent:emptyNew() self.vehicle = vehicle; self.currentQLinkW = currentQLinkW; return self; end;

function setcurrentQLinkWEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id); self.currentQLinkW = streamReadInt8(streamId);
	self.vehicle:setcurrentQLinkW(self.currentQLinkW, true);
	if not connection:getIsServer() then g_server:broadcastEvent(setcurrentQLinkWEvent:new(self.vehicle, self.currentQLinkW), nil, connection, self.vehicle); end; end;

function setcurrentQLinkWEvent:writeStream(streamId, connection) streamWriteInt32(streamId, networkGetObjectId(self.vehicle)); streamWriteInt8(streamId, self.currentQLinkW); end;

function setcurrentQLinkWEvent.sendEvent(vehicle, currentQLinkW, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then	g_server:broadcastEvent(setcurrentQLinkWEvent:new(vehicle, currentQLinkW), nil, nil, vehicle);
		else g_client:getServerConnection():sendEvent(setcurrentQLinkWEvent:new(vehicle, currentQLinkW)); end; end; end;