variableQLink = {};

function variableQLink.prerequisitesPresent(specializations) return true; end;

function variableQLink:load(xmlFile)	
	self.setCurrentQLink = SpecializationUtil.callSpecializationsFunction("setCurrentQLink");
	self.currentQLink = 0;
	self.qLinkMenu = false;
	self.qLink_range = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.inputAttacherJoints.inputAttacherJoint#index"));
	self.crosetto = getXMLString(xmlFile, "vehicle.crosetto#animationName");
	self.blackBeauty = getXMLString(xmlFile, "vehicle.blackBeauty#animationName");
	self.fendt = getXMLString(xmlFile, "vehicle.fendt#animationName");
	self.johnDeere = getXMLString(xmlFile, "vehicle.johnDeere#animationName"); end;

function variableQLink:delete() end;

function variableQLink:readStream(streamId, connection) self:setCurrentQLink(streamReadInt8(streamId), true); end;

function variableQLink:writeStream(streamId, connection) streamWriteInt8(streamId, self.currentQLink); end;

function variableQLink:setCurrentQLink(int, noEventSend) self.currentQLink = int; setCurrentQLinkEvent.sendEvent(self, int, noEventSend); end;

function variableQLink:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local currentQLink = getXMLInt(xmlFile, key .. "#currentQLink");
	if currentQLink ~= nil then	self:setCurrentQLink(currentQLink); end;
	return BaseMission.VEHICLE_LOAD_OK; end;
 
function variableQLink:getSaveAttributesAndNodes(nodeIdent) local attributes = 'currentQLink="' .. self.currentQLink .. '" '; return attributes; end;

function variableQLink:mouseEvent(posX, posY, isDown, isUp, button) end;

function variableQLink:keyEvent(unicode, sym, modifier, isDown) end;

function variableQLink:update(dt)
	if g_currentMission.player ~= nil then
		local nearestDistance1 = 7;	local nearestDistance2 = 100;			
		local x1,y1,z1 = getWorldTranslation(self.qLink_range);	local x2,y2,z2 = getWorldTranslation(g_currentMission.player.rootNode);		
		local distance1 = Utils.vector3Length(x1-x2,y1-y2,z1-z2);
		local distance2 = Utils.vector3Length(g_currentMission.storeSpawnPlaces[1].startX-x2,g_currentMission.storeSpawnPlaces[1].startY-y2,g_currentMission.storeSpawnPlaces[1].startZ-z2);			
		if distance1 < nearestDistance1 and distance2 < nearestDistance2 then
			if not self.qLinkMenu then g_currentMission:addHelpButtonText(g_i18n:getText("VARIABLE_QLINK"), InputBinding.VARIABLE_QLINK);	
				if InputBinding.hasEvent(InputBinding.VARIABLE_QLINK) then self.qLinkMenu = true; end; end;
			if self.qLinkMenu then
				g_currentMission:addHelpButtonText(g_i18n:getText("VARIABLE_QLINK_1"), InputBinding.VARIABLE_QLINK_1);
				g_currentMission:addHelpButtonText(g_i18n:getText("VARIABLE_QLINK_2"), InputBinding.VARIABLE_QLINK_2);
				g_currentMission:addHelpButtonText(g_i18n:getText("VARIABLE_QLINK_3"), InputBinding.VARIABLE_QLINK_3);
				g_currentMission:addHelpButtonText(g_i18n:getText("VARIABLE_QLINK_4"), InputBinding.VARIABLE_QLINK_4);
				g_currentMission:addHelpButtonText(g_i18n:getText("VARIABLE_QLINK_5"), InputBinding.VARIABLE_QLINK_5);
				g_currentMission:addHelpButtonText(g_i18n:getText("VARIABLE_QLINK_6"), InputBinding.VARIABLE_QLINK_6);
				if InputBinding.hasEvent(InputBinding.VARIABLE_QLINK_1) and self.currentQLink ~= 0 then	self:setCurrentQLink(0); g_currentMission:addSharedMoney(-5000); self.qLinkMenu = false;
				elseif InputBinding.hasEvent(InputBinding.VARIABLE_QLINK_2) and self.currentQLink ~= 1 then	self:setCurrentQLink(1); g_currentMission:addSharedMoney(-5000); self.qLinkMenu = false;
				elseif InputBinding.hasEvent(InputBinding.VARIABLE_QLINK_3) and self.currentQLink ~= 2 then	self:setCurrentQLink(2); g_currentMission:addSharedMoney(-5000); self.qLinkMenu = false;
				elseif InputBinding.hasEvent(InputBinding.VARIABLE_QLINK_4) and self.currentQLink ~= 3 then	self:setCurrentQLink(3); g_currentMission:addSharedMoney(-5000); self.qLinkMenu = false;
				elseif InputBinding.hasEvent(InputBinding.VARIABLE_QLINK_5) and self.currentQLink ~= 4 then	self.qLinkMenu = false;
				elseif InputBinding.hasEvent(InputBinding.VARIABLE_QLINK_6) and self.currentQLink ~= 5 then	self.qLinkMenu = false; end; end;
		elseif distance1 < nearestDistance1 and attacherVehicle == nil then	g_currentMission:addExtraPrintText(g_i18n:getText("VARIABLE_QLINK_RANGE1")); g_currentMission:addExtraPrintText(g_i18n:getText("VARIABLE_QLINK_RANGE2"));
		else self.qLinkMenu = false; end; end; end;

function variableQLink:updateTick(dt)
	if self.currentQLink == 0 then	self:playAnimation(self.crosetto, 1);
	elseif self.currentQLink == 1 then self:playAnimation(self.blackBeauty, 1);
	elseif self.currentQLink == 2 then self:playAnimation(self.fendt, 1);
	elseif self.currentQLink == 3 then self:playAnimation(self.johnDeere, 1);
	elseif self.currentQLink == 4 then
	elseif self.currentQLink == 5 then end; end;

function variableQLink:onAttach() end;

function variableQLink:onDetach() end;

function variableQLink:draw() end;

setCurrentQLinkEvent = {};
setCurrentQLinkEvent_mt = Class(setCurrentQLinkEvent, Event);
InitEventClass(setCurrentQLinkEvent, "setCurrentQLinkEvent");

function setCurrentQLinkEvent:emptyNew() local self = Event:new(setCurrentQLinkEvent_mt); self.className="setCurrentQLinkEvent"; return self; end;

function setCurrentQLinkEvent:new(vehicle, currentQLink) local self = setCurrentQLinkEvent:emptyNew() self.vehicle = vehicle; self.currentQLink = currentQLink; return self; end;

function setCurrentQLinkEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id); self.currentQLink = streamReadInt8(streamId); self.vehicle:setCurrentQLink(self.currentQLink, true);
	if not connection:getIsServer() then g_server:broadcastEvent(setCurrentQLinkEvent:new(self.vehicle, self.currentQLink), nil, connection, self.vehicle); end; end;

function setCurrentQLinkEvent:writeStream(streamId, connection) streamWriteInt32(streamId, networkGetObjectId(self.vehicle)); streamWriteInt8(streamId, self.currentQLink); end;

function setCurrentQLinkEvent.sendEvent(vehicle, currentQLink, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then g_server:broadcastEvent(setCurrentQLinkEvent:new(vehicle, currentQLink), nil, nil, vehicle);
		else g_client:getServerConnection():sendEvent(setCurrentQLinkEvent:new(vehicle, currentQLink)); end; end; end;