flagShader = {};

function flagShader.prerequisitesPresent(specializations) return true; end;

function flagShader:load(xmlFile)
	self.dynPlanes = {};
	local i=0;
	while true do i = i + 1;
		local node = Utils.indexToObject( self.components, getXMLString(xmlFile, string.format("vehicle.flagShader.dynPlane%d#idx", i)));
		if node == nil then break; end;
		local scale = Utils.getNoNil( getXMLBool(xmlFile,  string.format("vehicle.flagShader.dynPlane%d#scale", i)), false );
		local e = {}; e.node = node; e.scale = scale;
		table.insert(self.dynPlanes, e); end;
	self.dynPlanesActive = true; end;

function flagShader:delete() end;

function flagShader:mouseEvent(posX, posY, isDown, isUp, button) end;

function flagShader:keyEvent(unicode, sym, modifier, isDown) end;

function flagShader:readStream(streamId, connection)
	for i,plane in pairs(self.dynPlanes) do
		if plane.scale then setScale(plane.node, 1, 1.0, 1); end; end; end;

function flagShader:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	for i,plane in pairs(self.dynPlanes) do
		if plane.scale then	setScale(plane.node, 1, 1.0, 1); end; end;	
	return BaseMission.VEHICLE_LOAD_OK; end;

function flagShader:getSaveAttributesAndNodes(nodeIdent) local node = nil; return attributes, node; end;

function flagShader:update(dt)
	if self:getIsActive() then
		for i,plane in pairs(self.dynPlanes) do
			if plane.scale then
				local sx, sy, sz = getScale(plane.node)
				local newS = Utils.getMovedLimitedValues({sy}, {1.0}, {0.5}, 1, 4000, dt);
				setScale(plane.node, 1, newS[1], 1); end; end; end; end;

function flagShader:updateTick(dt)
	if self.attacherVehicle ~= nil then	local spd = self.lastSpeed*3600;		
		if spd < 5 and self.dynPlanesActive == true then self.dynPlanesActive = false;
			for i,plane in pairs(self.dynPlanes) do setShaderParameter(plane.node, "displacementSpeedFrequencyAndTexOff", 0.1, 0, 0, 0.05,false); end;
		elseif self.dynPlanesActive == false and spd > 5 then self.dynPlanesActive = true;
			for i,plane in pairs(self.dynPlanes) do	setShaderParameter(plane.node, "displacementSpeedFrequencyAndTexOff", 0.1, 4, 0.9, 0.05,false); end; end;	
	else local spd = self.lastSpeed*3600;
		if spd < 5 and self.dynPlanesActive == true then self.dynPlanesActive = false;
			for i,plane in pairs(self.dynPlanes) do	setShaderParameter(plane.node, "displacementSpeedFrequencyAndTexOff", 0.1, 0, 0, 0.05,false); end; end; end; end;

function flagShader:onAttach(attacherVehicle) self.attacherVehicle = attacherVehicle; self.attacherVehicleCopy = attacherVehicle; end;

function flagShader:onDetach() self.attacherVehicle = nil; end;

function flagShader:writeStream(streamId, connection) end;

function flagShader:readStreamUpdate(streamId, connection) end;

function flagShader:writeStreamUpdate(streamId, connection) end;

function flagShader:draw() end;