crosetto_CMR200 = {};

function crosetto_CMR200.prerequisitesPresent(specializations) return true; end;

function crosetto_CMR200:load(xmlFile)
	self.axle1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.axis#index1"));
	self.axle2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.axis#index2"));
	self.axle3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.axis#index3"));
	self.molla = {}; self.molla.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.molla(0)#index"));
	local x,y,z = getRotation(self.molla.node);
	self.molla.part = {x,y,z}; self.molla.part = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.molla(0)#part"));
	x,y,z = getTranslation(self.molla.part);	
	self.molla.fixPoint = {x,y,z}; self.molla.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.molla(0)#fixPoint"));	
	local ax, ay, az = getWorldTranslation(self.molla.node);
	local bx, by, bz = getWorldTranslation(self.molla.fixPoint);		
	self.molla.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	
	self.molla.target = {x,y,z}; self.molla.target = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.molla(0)#target")); end;

function crosetto_CMR200:delete() end;

function crosetto_CMR200:mouseEvent(posX, posY, isDown, isUp, button) end;

function crosetto_CMR200:keyEvent(unicode, sym, modifier, isDown) end;

function crosetto_CMR200:update(dt)
	if self:getIsActive() then
		xr1,_,_ = getRotation(self.axle1); xr2,_,_ = getRotation(self.axle2); xr3,_,_ = getRotation(self.axle3);
		xrw1,yrw1,zrw1 = getRotation(self.wheels[1].repr);
		xrw2,yrw2,zrw2 = getRotation(self.wheels[2].repr);
		xrw3,yrw3,zrw3 = getRotation(self.wheels[3].repr);
		xrw4,yrw4,zrw4 = getRotation(self.wheels[4].repr);
		xrw5,yrw5,zrw5 = getRotation(self.wheels[5].repr);
		xrw6,yrw6,zrw6 = getRotation(self.wheels[6].repr);
		self.newRot1 = zrw1 - xr1; self.newRot2 = zrw3 - xr2; self.newRot3 = zrw5 - xr3;
		setRotation(self.wheels[1].repr, xrw1,yrw1,self.newRot1)
		setRotation(self.wheels[2].repr, xrw2,yrw2,self.newRot1)
		setRotation(self.wheels[3].repr, xrw3,yrw3,self.newRot2)
		setRotation(self.wheels[4].repr, xrw4,yrw4,self.newRot2)
		setRotation(self.wheels[5].repr, xrw5,yrw5,self.newRot3)
		setRotation(self.wheels[6].repr, xrw6,yrw6,self.newRot3) end;
	if self.molla.target ~= nil then		
		local ax, ay, az = getWorldTranslation(self.molla.part);
		local bx, by, bz = getWorldTranslation(self.molla.target);
		local x, y, z = worldDirectionToLocal(getParent(self.molla.part), bx-ax, by-ay, bz-az);
		local upX, upY, upZ = 0,1,0;
		if math.abs(y) > Utils.vector3Length(x, y, z) then	upY = 0;
			if y > 0 then upZ = 1; else upZ = -1; end; end;
		setDirection(self.molla.part, x, y, z, upX, upY, upZ);
		local len = Utils.vector3Length(ax-bx, ay-by, az-bz);
		setScale(self.molla.part, 1, 1, len/self.molla.distance); end; end;

function crosetto_CMR200:loadFromAttributesAndNodes(xmlFile, key, resetVehicles) return BaseMission.VEHICLE_LOAD_OK; end;

function crosetto_CMR200:getSaveAttributesAndNodes(nodeIdent) end;

function crosetto_CMR200:updateTick(dt) end;

function crosetto_CMR200:draw() end;

function crosetto_CMR200:onAttach(attacherVehicle, jointDescIndex) end;

function crosetto_CMR200:onDetach() end;

function crosetto_CMR200:onDeactivate() end;