-- Car Future
--
-- Specialization for Car Future mod
--
-- @date  01.04.2012
--
-- All Rights Reserved.

CarFuture = {};

function CarFuture.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function CarFuture:load(xmlFile)
    hornSoundFile = Utils.getFilename("superHorn.wav", self.baseDirectory);
    self.hornSoundId = createSample("CarFutureHornSound");
    loadSample(self.hornSoundId, hornSoundFile, false);
    self.hornPlaying = false;
end;

function CarFuture:delete()
    delete(self.burnerSoundId);
end;

function CarFuture:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CarFuture:keyEvent(unicode, sym, modifier, isDown)
end;

function FCarFuture:update(dt)
	if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.isPressed(InputBinding.CarFuture_SILLYHORN) then
        if not self.hornPlaying then
            playSample(self.hornSoundId, 0, 1, 0);
            self.hornPlaying = true;
        end;
    else
        if self.hornPlaying then
            stopSample(self.hornSoundId);
            self.hornPlaying = false;
        end;
    end;
end;

function CarFuture:draw()
    g_currentMission:addHelpButtonText(g_i18n:getText("Silly Horn"), InputBinding.CarFuture_SILLYHORN);
end;