-- by "Marhu" 
-- v 1.0
-- Date: 07.03.2013
-- CowWaterMod

CowWaterMod = {}

g_CowWaterModLoadDir = g_currentModDirectory;

if AnimalHusbandry.load ~= nil then
	local orgload = AnimalHusbandry.load
	AnimalHusbandry.load = function(a, b, c, d, e, f)
		if b == "cow" then
			CowWaterMod.Cow = a
			local tipTriggersIndex = getUserAttribute(c, "tipTriggersIndex");
			if tipTriggersIndex ~= nil then
				local tipTriggersId = Utils.indexToObject(c, tipTriggersIndex);
				if tipTriggersId ~= nil then
					local triggerRoot = getChildAt(Utils.loadSharedI3DFile(g_CowWaterModLoadDir.."Trigger.i3d"), 0);
					if triggerRoot then
						link(tipTriggersId, triggerRoot);			
						CowWaterMod.tipTrigger = triggerRoot
					end
				end
			end
		end
		
		local ra = orgload(a, b, c, d, e, f)
		return ra
	end;
end


		
function CowWaterMod:loadMap(name)

	if self.Cow.getHasSpaceForTipping ~= nil then
		local orggetHasSpaceForTipping = self.Cow.getHasSpaceForTipping
		self.Cow.getHasSpaceForTipping = function(a, b, c, d, e, f)
			local ra, rb, rc, rd = orggetHasSpaceForTipping(a, b, c, d, e, f)
			if b == Fillable.FILLTYPE_WATER then
				if a.totalNumAnimals * (60*6) >= a.tipTriggersFillLevels[Fillable.FILLTYPE_WATER][1].fillLevel then
					return true 
				end
			end
			return ra
		end;
	end;	
	
	if self.Cow.minuteChanged ~= nil then
		local orgminuteChanged = self.Cow.minuteChanged
		self.Cow.minuteChanged = function(a, b, c, d, e, f)
			local ra, rb, rc, rd = orgminuteChanged(a, b, c, d, e, f)
			if a.updateMinutes == 0 then
				local bedarf = a.totalNumAnimals * (60/1440*a.updateMinutesInterval) -- eine Kuh 60 l/tag
				local WasserLevel = a.tipTriggersFillLevels[Fillable.FILLTYPE_WATER][1].fillLevel
				a.tipTriggersFillLevels[Fillable.FILLTYPE_WATER][1].fillLevel = math.max(0, WasserLevel - bedarf)
				if a.tipTriggersFillLevels[Fillable.FILLTYPE_WATER][1].fillLevel > 0 then
					a.productivity = a.productivity + .1
					a.fillLevelMilk = a.fillLevelMilk + (a.totalNumAnimals * 0.04956 * a.updateMinutesInterval)
				end
			end
		end;
	end;
	
	if self.Cow.delete ~= nil then
		local orgdelete = self.Cow.delete
		self.Cow.delete = function(a, b, c, d, e, f)
			orgdelete(a, b, c, d, e, f)
			CowWaterMod.tipTrigger = nil
		end;
	end;
		
	if self.Cow.writeStream ~= nil then
		local orgwriteStream = self.Cow.writeStream
		self.Cow.writeStream = function(a, b, c, d, e, f)
			orgwriteStream(a, b, c, d, e, f)
			streamWriteFloat32(b,a.tipTriggersFillLevels[Fillable.FILLTYPE_WATER][1].fillLevel)
		end;
	end;
	
	if self.Cow.readStream ~= nil then
		local orgreadStream = self.Cow.readStream
		self.Cow.readStream = function(a, b, c, d, e, f)
			orgreadStream(a, b, c, d, e, f)
			a.tipTriggersFillLevels[Fillable.FILLTYPE_WATER][1].fillLevel = streamReadFloat32(b)
		end;
	end;
	if self.Cow.writeUpdateStream ~= nil then
		local orgwriteUpdateStream = self.Cow.writeUpdateStream
		self.Cow.writeUpdateStream = function(a, b, c, d, e, f)
			orgwriteUpdateStream(a, b, c, d, e, f)
			streamWriteFloat32(b,a.tipTriggersFillLevels[Fillable.FILLTYPE_WATER][1].fillLevel)
		end;
	end;
	
	if self.Cow.readUpdateStream ~= nil then
		local orgreadUpdateStream = self.Cow.readUpdateStream
		self.Cow.readUpdateStream = function(a, b, c, d, e, f)
			orgreadUpdateStream(a, b, c, d, e, f)
			a.tipTriggersFillLevels[Fillable.FILLTYPE_WATER][1].fillLevel = streamReadFloat32(b)
		end;
	end;
	
	for i = 1 ,table.getn(self.Cow.tipTriggers) do
		if self.Cow.tipTriggers[i].acceptedFillTypes[Fillable.FILLTYPE_WATER] then
			self.Cow.tipTriggersFillLevels[Fillable.FILLTYPE_WATER] = {
					   [1] = {
						  ["tipTriggerIndex"] = i;
						  ["tipTrigger"] = self.Cow.tipTriggers[i];
						  ["fillLevel"] = 0;
					   };
					};
		end
	end

	if g_currentMission.missionPDA.statsPages[3].func ~= nil then
		local orgstatsPages = g_currentMission.missionPDA.statsPages[3].func
		g_currentMission.missionPDA.statsPages[3].func = function(a, b, c, d, e, f)
			local ra, rb, rc, rd = orgstatsPages(a, b, c, d, e, f)
			local x = g_currentMission.missionPDA.pdaCol1
			local h = g_currentMission.missionPDA.pdaFontSize
			local y = g_currentMission.missionPDA.pdaTitleY - (g_currentMission.missionPDA.pdaRowSpacing * 10 ) - (h * 1)
			local desc = Fillable.fillTypeIndexToDesc[Fillable.FILLTYPE_WATER].nameI18N
			renderText(x, y, h, string.format("%s",desc.." [l]"));
			x = g_currentMission.missionPDA.pdaCol2
			renderText(x, y, h, string.format("%d",a.tipTriggersFillLevels[Fillable.FILLTYPE_WATER][1].fillLevel));
		end;
	end;
	
end;

function CowWaterMod:deleteMap()
end;
function CowWaterMod:mouseEvent(posX, posY, isDown, isUp, button)
end;
function CowWaterMod:keyEvent(unicode, sym, modifier, isDown)
end;
function CowWaterMod:update(dt)
end;
function CowWaterMod:draw()
end;

addModEventListener(CowWaterMod);