--
-- Cornwell_Farm
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

Cornwell_Farm = {}

local Cornwell_Farm_mt = Class(Cornwell_Farm, Mission00);


function Cornwell_Farm:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = Cornwell_Farm_mt;
    end;
    local self = Cornwell_Farm:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function Cornwell_Farm:delete()
    Cornwell_Farm:superClass().delete(self);
end;

function Cornwell_Farm:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/map.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function Cornwell_Farm:loadMap01Finished(node, arguments)

    self:loadMapXMLFile(Utils.getFilename("Cornwell_Farm.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -187, 603, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), -195, 588, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

	-- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -138, 444, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- Grass Heaps
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -140 , 509, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
	-- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), -174, 416, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), -187, 492, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), -126, 492, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

	-- spinnery
    g_currentMission.missionPDA:createMapHotspot("woolDeliveryHotspot", Utils.getFilename("$dataS/missions/hud_pda_spot_spinnery.png", self.baseDirectory), -251, 627, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
   
    -- egg sellpoint
    self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("$dataS/missions/hud_pda_spot_eggs.png", self.baseDirectory), -253, 607, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
    Cornwell_Farm:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function Cornwell_Farm:onStartMission()
    Cornwell_Farm:superClass().onStartMission(self);
end;

function Cornwell_Farm:mouseEvent(posX, posY, isDown, isUp, button)
    Cornwell_Farm:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Cornwell_Farm:keyEvent(unicode, sym, modifier, isDown)
    Cornwell_Farm:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function Cornwell_Farm:update(dt)
    Cornwell_Farm:superClass().update(self, dt);
end;

function Cornwell_Farm:draw()
    Cornwell_Farm:superClass().draw(self);
end;