SetAllumerEvent = {};
SetAllumerEvent_mt = Class(SetAllumerEvent, Event);

InitEventClass(SetAllumerEvent, "SetAllumerEvent");

function SetAllumerEvent:emptyNew()
	local self = Event:new(SetAllumerEvent_mt);
	self.className="SetAllumerEvent";
	return self;
end;

function SetAllumerEvent:new(vehicle, allumer)
	local self = SetAllumerEvent:emptyNew()
	self.vehicle = vehicle;
	self.allumer = allumer;
	return self;
end;

function SetAllumerEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.allumer = streamReadBool(streamId);
	self.vehicle = networkGetObject(id);
	self:run(connection);
end;

function SetAllumerEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.allumer);
end;

function SetAllumerEvent:run(connection)   
	self.vehicle:setAllumer(self.allumer, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetAllumerEvent:new(vehicle, self.allumer), nil, connection, self.vehicle);
	end;
end;

function SetAllumerEvent.sendEvent(vehicle, allumer, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetAllumerEvent:new(vehicle, allumer), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetAllumerEvent:new(vehicle, allumer));
		end;
	end;
end;