SetPSActiveEvent = {};
SetPSActiveEvent_mt = Class(SetPSActiveEvent, Event);

InitEventClass(SetPSActiveEvent, "SetPSActiveEvent");

function SetPSActiveEvent:emptyNew()
    local self = Event:new(SetPSActiveEvent_mt);
    self.className="SetPSActiveEvent";
    return self;
end;

function SetPSActiveEvent:new(object, activatePS)
    local self = SetPSActiveEvent:emptyNew()
    self.object = object;
	self.activatePS = activatePS;
    return self;
end;

function SetPSActiveEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.activatePS = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetPSActiveEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.activatePS);
end;

function SetPSActiveEvent:run(connection)
    self.object:setCollectPSActive(self.activatePS, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetPSActiveEvent:new(self.object, self.activatePS), nil, connection, self.object);
    end;
end;

function SetPSActiveEvent.sendEvent(vehicle, activatePS, noEventSend)
    if activatePS ~= vehicle.activateCollectPS then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(SetPSActiveEvent:new(vehicle, activatePS), nil, nil, vehicle);
            --else
              --  g_client:getServerConnection():sendEvent(SetPSActiveEvent:new(vehicle, activatePS));
            end;
        end;
    end;
end;

