--
-- Rotation
-- Specialization for all the user-controlled rotating parts on a vehicle
--
-- @author  Templaer
-- @date  19/11/09
--

rotation = {};

function rotation.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function rotation:load(xmlFile)
--Back Hidraulic
	self.doRotate = SpecializationUtil.callSpecializationsFunction("doRotate");
    local rotationNode11 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation11#index"));
        self.rotation11 = {};
          self.rotation11.node = rotationNode11;

	local rotationNode12 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation12#index"));
        self.rotation12 = {};
          self.rotation12.node = rotationNode12;
		  
	local rotationNode14 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation14#index"));
        self.rotation14 = {};
          self.rotation14.node = rotationNode14;
		  
   local rotationNode13 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation13#index"));
        self.bottomArm2 = {};
          self.bottomArm2.node = rotationNode13;
    self.rotatingParts = {};
--Front Hidraulic
	local rotationNode21 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation21#index"));
        self.rotation21 = {};
          self.rotation21.node = rotationNode21;

	local rotationNode22 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation22#index"));
        self.rotation22 = {};
          self.rotation22.node = rotationNode22;
		  
   local rotationNode23 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation23#index"));
        self.bottomArm3 = {};
          self.bottomArm3.node = rotationNode23;
    self.rotatingParts = {};
    local rotatingPartsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rotatingParts#count"), 0);	
	for i=1, rotatingPartsCount do
		local namei = string.format("vehicle.rotatingParts.rotatingPart%d", i);
		local rotatingPart = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
		
		self.rotatingParts[i] = {};
		self.rotatingParts[i].node = rotatingPart;
		
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, namei .. "#minRot"));
        self.rotatingParts[i].minRot = {};
        self.rotatingParts[i].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotatingParts[i].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotatingParts[i].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, namei .. "#maxRot"));
		self.rotatingParts[i].maxRot = {};
        self.rotatingParts[i].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotatingParts[i].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotatingParts[i].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
		--x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, namei .. "#minTrans"));
        --self.rotatingParts[i].minTrans = {};
        --self.rotatingParts[i].minTrans[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        --self.rotatingParts[i].minTrans[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        --self.rotatingParts[i].minTrans[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
		--x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, namei .. "#maxTrans"));
		--self.rotatingParts[i].maxTrans = {};
        --self.rotatingParts[i].maxTrans[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        --self.rotatingParts[i].maxTrans[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        --self.rotatingParts[i].maxTrans[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
		self.rotatingParts[i].rotTime = Utils.getNoNil(getXMLString(xmlFile, namei .. "#rotTime"), 2)*1000;
	end;
	
	self.isLeftDoorOpen = false;
	self.isRightDoorOpen = false;
	self.isRearWindowOpen = false;
	self.isFrontWindowOpen = false;
end;

function rotation:delete()
end;

function rotation:mouseEvent(posX, posY, isDown, isUp, button)
end;

function rotation:keyEvent(unicode, sym, modifier, isDown)
end;

function rotation:update(dt)	
--Lenksule    
	if self.isEntered then
		if self.rotatingParts[1] ~= nil then
			if InputBinding.hasEvent(InputBinding.IGNITION_START) then
				self.isRearWindowOpen = not self.isRearWindowOpen;
			end;
			
			self:doRotate(1, self.isRearWindowOpen, dt);	
		end;
--Back Hidraulic
		if self.rotation11.node ~= nil and self.bottomArm2.node ~= nil then
	    rBBArmX, rBBArmY, rBBArmZ = getRotation(self.bottomArm2.node);
        setRotation(self.rotation11.node, -0.125+rBBArmX*1, 0, 0, 0);
        end;
	    if self.rotation12.node ~= nil and self.bottomArm2.node ~= nil then
        setRotation(self.rotation12.node, rBBArmX*-1, 0, 0, 0);
        end;
		if self.rotation14.node ~= nil and self.bottomArm2.node ~= nil then
        setRotation(self.rotation14.node, 0.1+rBBArmX*-1.05, 0, 0, 0);
        end;
--Front Hidraulic
		if self.rotation21.node ~= nil and self.bottomArm3.node ~= nil then
	    rBBArmX, rBBArmY, rBBArmZ = getRotation(self.bottomArm3.node);
        setRotation(self.rotation21.node, 0.023+rBBArmX*0.058, 0, 0, 0);
        end;
	    if self.rotation22.node ~= nil and self.bottomArm3.node ~= nil then
        setRotation(self.rotation22.node, -0.36+rBBArmX*-0.9, 0, 0, 0);
        end;
--		if self.rotatingParts[2] ~= nil then
--			if InputBinding.hasEvent(InputBinding.RIGHTDOOR) then	
--				self.isRightDoorOpen = not self.isRightDoorOpen;
--			end;
--			
--			self:doRotate(2, self.isRightDoorOpen, dt);
--		end;
		
--		if self.rotatingParts[3] ~= nil then		
--			if InputBinding.hasEvent(InputBinding.WINDOW) then	
--				self.isRearWindowOpen = not self.isRearWindowOpen;
--			end;
--		
--			self:doRotate(3, self.isRearWindowOpen, dt);
--		end;
		
--		if self.rotatingParts[4] ~= nil then
--			if InputBinding.hasEvent(InputBinding.FRONTWINDOW) then	
--				self.isFrontWindowOpen = not self.isFrontWindowOpen;
--			end;
--			
--			self:doRotate(4, self.isFrontWindowOpen, dt);
--		end;
	end;
end;

function rotation:draw()  
	if self.rotatingParts[4] ~= nil then

	else

	end;
end;

-- Additional function(s)
function rotation:doRotate(index, boolean, dt)
	local x, y, z = getRotation(self.rotatingParts[index].node);
	local rot = {x,y,z};
	local newRot = Utils.getMovedLimitedValues(rot, self.rotatingParts[index].maxRot, self.rotatingParts[index].minRot, 3, self.rotatingParts[index].rotTime, dt, not boolean);
	setRotation(self.rotatingParts[index].node, unpack(newRot));
	
	--local x, y, z = getTranslation(self.rotatingParts[index].node);
	--local trans = {x,y,z};
	--local newTrans = Utils.getMovedLimitedValues(trans, self.rotatingParts[index].maxTrans, self.rotatingParts[index].minTrans, 3, self.rotatingParts[index].rotTime, dt, not boolean);
	--setTranslation(self.rotatingParts[index].node, unpack(newTrans));
end;
