--
-- Combine
-- This is the specialization for combines
--
-- @author  Stefan Geiger
-- @date  30/11/08
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

Tucano480 = {};

function Tucano480.prerequisitesPresent(specializations)
    Vehicle.registerJointType("cutter");
    Vehicle.registerJointType("trailerCombine");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Tucano480:load(xmlFile)

	self.controlpath = Utils.getFilename("textures/menu.jpg", self.baseDirectory);
    self.hudClaasWidth = 0.815;
    self.hudClaasHeight = 0.16;
	self.hudClaasPosX = 0.01;
    self.hudClaasPosY = 0.01;
    self.hudClaasOverlay = Overlay:new("hudClaasOverlay", self.controlpath, self.hudClaasPosX, self.hudClaasPosY, self.hudClaasWidth, self.hudClaasHeight);
	
	self.controlpathAI = Utils.getFilename("textures/menuAI.png", self.baseDirectory);
    self.hudClaasAIWidth = 0.20;
    self.hudClaasAIHeight = 0.32;
	self.hudClaasAIPosX = 0.01;
    self.hudClaasAIPosY = 0.5;
    self.hudClaasAIOverlay = Overlay:new("hudClaasAIOverlay", self.controlpathAI, self.hudClaasAIPosX, self.hudClaasAIPosY, self.hudClaasAIWidth, self.hudClaasAIHeight);

    self.ignitionKey = false;
	self.allowedIgnition = false;                                                  
    self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);

    local motorMinRpm = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motor#minRpm"), 1000);
    local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 800);
    motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 1000);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 1800);
    local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3};
    self.motorMaxRpmLimit = motorMaxRpm;
	
	self.korntankTimer = 2000;
	self.fuellstand = false;
	self.korntank = false;
    self.rotorFan2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotorFan2#index"));
	self.cos = 300;
	
	self.dustParticleSystems = {};
    local dustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems#count"), 0);
    for i=1, dustParticleSystemCount do
        local namei = string.format("vehicle.dustParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	self.dustParticleSystems2 = {};
    local dustParticleSystemCount2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems2#count"), 0);
    for i=1, dustParticleSystemCount2 do
        local namei2 = string.format("vehicle.dustParticleSystems2.part%d", i);
		local nodei2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei2 .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems2, namei2, nodei2, false, nil, self.baseDirectory)			
    end;
	
	self.dustParticleSystems3 = {};
    local dustParticleSystemCount3 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems3#count"), 0);
    for i=1, dustParticleSystemCount3 do
        local namei3 = string.format("vehicle.dustParticleSystems3.part%d", i);
		local nodei3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei3 .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems3, namei3, nodei3, false, nil, self.baseDirectory)			
    end;
	
	self.dustParticleSystems4 = {};
    local dustParticleSystemCount4 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems4#count"), 0);
    for i=1, dustParticleSystemCount4 do
        local namei4 = string.format("vehicle.dustParticleSystems4.part%d", i);
		local nodei4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei4 .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems4, namei4, nodei4, false, nil, self.baseDirectory)			
    end;
	
	--MAIZE
	self.dustParticleSystems5 = {};
    local dustParticleSystemCount5 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems5#count"), 0);
    for i=1, dustParticleSystemCount5 do
        local namei5 = string.format("vehicle.dustParticleSystems5.part%d", i);
		local nodei5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei5 .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems5, namei5, nodei5, false, nil, self.baseDirectory)			
    end;
	
	self.dustParticleSystems6 = {};
    local dustParticleSystemCount6 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems6#count"), 0);
    for i=1, dustParticleSystemCount6 do
        local namei6 = string.format("vehicle.dustParticleSystems6.part%d", i);
		local nodei6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei6 .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems6, namei6, nodei6, false, nil, self.baseDirectory)			
    end;

	self.dustParticleSystems7 = {};
    local dustParticleSystemCount7 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems7#count"), 0);
    for i=1, dustParticleSystemCount7 do
        local namei7 = string.format("vehicle.dustParticleSystems7.part%d", i);
		local nodei7 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei7 .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems7, namei7, nodei7, false, nil, self.baseDirectory)			
    end;
	--MAIZE END
	
	--RAPE	
	self.dustParticleSystems8 = {};
    local dustParticleSystemCount8 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems8#count"), 0);
    for i=1, dustParticleSystemCount8 do
        local namei8 = string.format("vehicle.dustParticleSystems8.part%d", i);
		local nodei8 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei8 .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems8, namei8, nodei8, false, nil, self.baseDirectory)			
    end;
	
	self.dustParticleSystems9 = {};
    local dustParticleSystemCount9 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems9#count"), 0);
    for i=1, dustParticleSystemCount9 do
        local namei9 = string.format("vehicle.dustParticleSystems9.part%d", i);
		local nodei9 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei9 .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems9, namei9, nodei9, false, nil, self.baseDirectory)			
    end;
	
	self.dustParticleSystems10 = {};
    local dustParticleSystemCount10 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems10#count"), 0);
    for i=1, dustParticleSystemCount10 do
        local namei10 = string.format("vehicle.dustParticleSystems10.part%d", i);
		local nodei10 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei10 .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems10, namei10, nodei10, false, nil, self.baseDirectory)			
    end;
	--RAPE END
	
	--SLOMA
	self.dustParticleSystems11 = {};
    local dustParticleSystemCount11 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems11#count"), 0);
    for i=1, dustParticleSystemCount11 do
        local namei11 = string.format("vehicle.dustParticleSystems11.part%d", i);
		local nodei11 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei11 .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems11, namei11, nodei11, false, nil, self.baseDirectory)			
    end;
	--SLOMA END	
	
--[[Arbeitslicht start]]--
	self.extra_lights = {};
    self.extra_lights.front = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.extra_lights.front#index"));
    self.extra_lights.heck = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.extra_lights.heck#index"));	
    self.frontlightActive = false;	
    self.hecklightActive = false;	
--[[Arbeitslicht ende]]--	

	self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
	self.brakelightsActive = false;
    self.braking = false;	
    self.brakeOn = false;
	
	self.abtanken = false;
	self.hydraulicSoundAllow = false;
	self.combineName = getXMLString(xmlFile, "vehicle.name.de");
	self.warningPlayed = false;
	
    self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenKey = getXMLString(xmlFile, "vehicle.rundumleuchten#key");
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;
		
	hydraulicSoundFile = Utils.getFilename("sounds/Tucano480/hydraulicUp.wav", self.baseDirectory);
    self.hydraulicSoundId = createSample("hydraulicSound");
    loadSample(self.hydraulicSoundId, hydraulicSoundFile, false);
    self.hydraulicPlaying = false;
	
	warningSoundFile = Utils.getFilename("sounds/Tucano480/warning.wav", self.baseDirectory);
    self.warningSoundId = createSample("warningSound");
    loadSample(self.warningSoundId, warningSoundFile, false);
    self.warningPlaying = false;
	
    local rotationPartNodeLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 2)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft2#index"));
    if rotationPartNodeLeft2 ~= nil then
        self.rotationPartLeft2 = {};
        self.rotationPartLeft2.node = rotationPartNodeLeft2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#minRot"));
        self.rotationPartLeft2.minRot = {};
        self.rotationPartLeft2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#maxRot"));
        self.rotationPartLeft2.maxRot = {};
        self.rotationPartLeft2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotationPartLeft2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#rotTime"), 2)*1000;
        self.rotationPartLeft2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft3#index"));
    if rotationPartNodeLeft3 ~= nil then
        self.rotationPartLeft3 = {};
        self.rotationPartLeft3.node = rotationPartNodeLeft3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft3#minRot"));
        self.rotationPartLeft3.minRot = {};
        self.rotationPartLeft3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft3#maxRot"));
        self.rotationPartLeft3.maxRot = {};
        self.rotationPartLeft3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotationPartLeft3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft3#rotTime"), 2)*1000;
        self.rotationPartLeft3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft3#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft4#index"));
    if rotationPartNodeLeft4 ~= nil then
        self.rotationPartLeft4 = {};
        self.rotationPartLeft4.node = rotationPartNodeLeft4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft4#minRot"));
        self.rotationPartLeft4.minRot = {};
        self.rotationPartLeft4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft4#maxRot"));
        self.rotationPartLeft4.maxRot = {};
        self.rotationPartLeft4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotationPartLeft4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft4#rotTime"), 2)*1000;
        self.rotationPartLeft4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft4#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft10 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft10#index"));
    if rotationPartNodeLeft10 ~= nil then
        self.rotationPartLeft10 = {};
        self.rotationPartLeft10.node = rotationPartNodeLeft10;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft10#minRot"));
        self.rotationPartLeft10.minRot = {};
        self.rotationPartLeft10.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft10.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft10.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft10#maxRot"));
        self.rotationPartLeft10.maxRot = {};
        self.rotationPartLeft10.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft10.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft10.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotationPartLeft10.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft10#rotTime"), 2)*1000;
        self.rotationPartLeft10.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft10#touchRotLimit"), 10));
    end;

    local rotationPartNodeLeft11 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft11#index"));
    if rotationPartNodeLeft11 ~= nil then
        self.rotationPartLeft11 = {};
        self.rotationPartLeft11.node = rotationPartNodeLeft11;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft11#minRot"));
        self.rotationPartLeft11.minRot = {};
        self.rotationPartLeft11.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft11.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft11.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft11#maxRot"));
        self.rotationPartLeft11.maxRot = {};
        self.rotationPartLeft11.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft11.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft11.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotationPartLeft11.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft11#rotTime"), 2)*1000;
        self.rotationPartLeft11.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft11#touchRotLimit"), 10));
    end;
	
	self.rullight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rullight#index"));
    self.allowGrainTankFruitType = Tucano480.allowGrainTankFruitType;
    self.emptyGrainTankIfLowFillLevel = Tucano480.emptyGrainTankIfLowFillLevel;
    self.setGrainTankFillLevel = SpecializationUtil.callSpecializationsFunction("setGrainTankFillLevel");
    self.startThreshing = SpecializationUtil.callSpecializationsFunction("startThreshing");
    self.stopThreshing = SpecializationUtil.callSpecializationsFunction("stopThreshing");
    self.openPipe = SpecializationUtil.callSpecializationsFunction("openPipe");
    self.closePipe = SpecializationUtil.callSpecializationsFunction("closePipe");
    self.findTrailerRaycastCallback = Tucano480.findTrailerRaycastCallback;

    local threshingStartSound = getXMLString(xmlFile, "vehicle.threshingStartSound#file");
    if threshingStartSound ~= nil and threshingStartSound ~= "" then
        threshingStartSound = Utils.getFilename(threshingStartSound, self.baseDirectory); 
        self.threshingStartSound = createSample("threshingStartSound");
        loadSample(self.threshingStartSound, threshingStartSound, false);
        self.threshingStartSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStartSound#pitchOffset"), 1);
        self.threshingStartSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStartSound#pitchScale"), 0);
        self.threshingStartSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStartSound#pitchMax"), 2.0);
    end;

    local cutterthreshingSound = getXMLString(xmlFile, "vehicle.cutterthreshingSound#file");
    if cutterthreshingSound ~= nil and cutterthreshingSound ~= "" then
        cutterthreshingSound = Utils.getFilename(cutterthreshingSound, self.baseDirectory); 
        self.cutterthreshingSound = createSample("cutterthreshingSound");
        loadSample(self.cutterthreshingSound, cutterthreshingSound, false);
        self.cutterthreshingSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cutterthreshingSound#pitchOffset"), 1);
        self.cutterthreshingSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cutterthreshingSound#pitchScale"), 0);
        self.cutterthreshingSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cutterthreshingSound#pitchMax"), 2.0);
    end;
	
    local threshingSound = getXMLString(xmlFile, "vehicle.threshingSound#file");
    if threshingSound ~= nil and threshingSound ~= "" then
        threshingSound = Utils.getFilename(threshingSound, self.baseDirectory); 
        self.threshingSound = createSample("threshingSound");
        loadSample(self.threshingSound, threshingSound, false);
        self.threshingSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingSound#pitchOffset"), 1);
        self.threshingSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingSound#pitchScale"), 0);
        self.threshingSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingSound#pitchMax"), 2.0);
    end;

    local threshingStopSound = getXMLString(xmlFile, "vehicle.threshingStopSound#file");
    if threshingStopSound ~= nil and threshingStopSound ~= "" then
        threshingStopSound = Utils.getFilename(threshingStopSound, self.baseDirectory); 
        self.threshingStopSound = createSample("threshingStopSound");
        loadSample(self.threshingStopSound, threshingStopSound, false);
        self.threshingStopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStopSound#pitchOffset"), 1);
        self.threshingStopSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStopSound#pitchScale"), 0);
        self.threshingStopSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStopSound#pitchMax"), 2.0);
    end;

    local pipeSound = getXMLString(xmlFile, "vehicle.pipeSound#file");
    if pipeSound ~= nil and pipeSound ~= "" then
        pipeSound = Utils.getFilename(pipeSound, self.baseDirectory); 
        self.pipeSound = createSample("pipeSound");
        loadSample(self.pipeSound, pipeSound, false);
        self.pipeSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchOffset"), 1);
        self.pipeSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchScale"), 0);
        self.pipeSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipeSound#pitchMax"), 2.0);
    end;

    local hidraulicSound = getXMLString(xmlFile, "vehicle.hidraulicSound#file");
    if hidraulicSound ~= nil and hidraulicSound ~= "" then
        hidraulicSound = Utils.getFilename(hidraulicSound, self.baseDirectory); 
        self.hidraulicSound = createSample("hidraulicSound");
        loadSample(self.hidraulicSound, hidraulicSound, false);
        self.hidraulicSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hidraulicSound#pitchOffset"), 1);
        self.hidraulicSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hidraulicSound#pitchScale"), 0);
        self.hidraulicSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hidraulicSound#pitchMax"), 2.0);
    end;

    self.chopperBlind = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chopperBlind#index"));

    self.pipeParticleSystems = {};
    self.pipe = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipe#index"));
    if self.pipe ~= nil then
        self.pipeRaycastNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipe#raycastNodeIndex"));
        local i = 0;
        while true do
            local key = string.format("vehicle.pipeParticleSystems.pipeParticleSystem(%d)", i);
            local t = getXMLString(xmlFile, key .. "#type");
            if t == nil then
                break;
            end;
            local desc = FruitUtil.fruitTypes[t];
            if desc ~= nil then
                local currentPS = {};
                local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.pipe, false, "$data/vehicles/particleSystems/wheatParticleSystem.i3d", self.baseDirectory);
                self.pipeParticleSystems[desc.index] = currentPS;
                if self.defaultPipeParticleSystem == nil then
                    self.defaultPipeParticleSystem = currentPS;
                end;
                if self.pipeRaycastNode == nil then
                    self.pipeRaycastNode = particleNode;
                end;
            end;
            i = i + 1;
        end;
        if self.pipeRaycastNode == nil then
            self.pipeRaycastNode = self.components[1].node;
        end;
    end;

    self.allowsThreshing = true;
    self.isThreshingStarted = false;

    self.pipeLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeLight#index"));
    self.pipeFlapLid = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeFlapLid#index"));

    self.rotorFan = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotorFan#index"));

    self.grainTankCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainTankCapacity"), 200);
    self.grainTankUnloadingCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainTankUnloadingCapacity"), 10);
    self.grainTankCrowded = false;
    self.grainTankPlanes = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.grainTankPlane.node(%d)", i);
        local t = getXMLString(xmlFile, key.."#type");
        local index = getXMLString(xmlFile, key.."#index");
        if t==nil or index==nil then
            break;
        end;
        local node = Utils.indexToObject(self.components, index);
        if node ~= nil then
            setVisibility(node, false);
            local entry = {};
            entry.node = node;
            local windowNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#windowIndex"));
            if windowNode ~= nil then
                entry.windowNode = windowNode;
                setVisibility(windowNode, false);
            end;
            if self.defaultGrainTankPlane == nil then
                self.defaultGrainTankPlane = entry;
            end;
            self.grainTankPlanes[t] = entry;
        end;
        i = i +1;
    end;
    if self.defaultGrainTankPlane==nil then
        self.grainTankPlanes = nil;
    end;

    self.grainTankPlaneMinY, self.grainTankPlaneMaxY = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.grainTankPlane#minMaxY"));
    if self.grainTankPlaneMinY == nil or self.grainTankPlaneMaxY == nil then
        local animCurve = AnimCurve:new(linearInterpolator4);
        local i = 0;
        while true do
            local key = string.format("vehicle.grainTankPlane.key(%d)", i);
            local t = getXMLFloat(xmlFile, key.."#time");
            local yValue = getXMLFloat(xmlFile, key.."#y");
            local scaleX,scaleY,scaleZ = Utils.getVectorFromString(getXMLString(xmlFile, key.."#scale"));
            if y == nil or scaleX == nil or scaleY == nil or scaleZ == nil then
                break;
            end;
            animCurve:addKeyframe({x=scaleX, y=scaleY, z=scaleZ, w=yValue, time = t});
            i = i +1;
        end;
        if i > 0 then
            self.grainTankPlaneAnimCurve = animCurve;
        end;
        self.grainTankPlaneMinY = 0;
        self.grainTankPlaneMaxY = 0;
    end;

    self.grainTankPlaneWindowMinY, self.grainTankPlaneWindowMaxY = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.grainTankPlane#windowMinMaxY"));
    if self.grainTankPlaneWindowMinY == nil or self.grainTankPlaneWindowMaxY == nil then
        local animCurve = AnimCurve:new(linearInterpolatorN);
        local i = 0;
        while true do
            local key = string.format("vehicle.grainTankPlane.windowKey(%d)", i);
            local t = getXMLFloat(xmlFile, key.."#time");
            local yValue = getXMLFloat(xmlFile, key.."#y");
            local visibility = getXMLBool(xmlFile, key.."#visibility");
            local scaleX,scaleY,scaleZ = Utils.getVectorFromString(getXMLString(xmlFile, key.."#scale"));
            if y == nil or scaleX == nil or scaleY == nil or scaleZ == nil or visibility == nil then
                break;
            end;
            animCurve:addKeyframe({v={scaleX, scaleY, scaleZ, yValue, }, time = t});
            i = i +1;
        end;
        if i > 0 then
            self.grainTankPlaneWindowAnimCurve = animCurve;
        end;
        self.grainTankPlaneWindowMinY = 0;
        self.grainTankPlaneWindowMaxY = 0;
    end;
    self.grainTankPlaneWindowStartY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.grainTankPlane#windowStartY"), 0.0);

    self.chopperParticleSystems = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.chopperParticleSystems.chopperParticleSystem(%d)", i);
        local t = getXMLString(xmlFile, key .. "#type");
        if t == nil then
            break;
        end;
        local desc = FruitUtil.fruitTypes[t];
        if desc ~= nil then
            local currentPS = {};

            local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/threshingChopperParticleSystem.i3d", self.baseDirectory);
            self.chopperParticleSystems[desc.index] = currentPS;
            if self.defaultChopperParticleSystem == nil then
                self.defaultChopperParticleSystem = currentPS;
            end;
        end;
        i = i + 1;
    end;

    self.chopperToggleTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.chopperParticleSystems#toggleTime"), 2500);
    self.chopperEnableTime = nil;
    self.chopperDisableTime = nil;

    self.strawParticleSystems = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.strawParticleSystems.strawParticleSystem(%d)", i);
        local t = getXMLString(xmlFile, key .. "#type");
        if t == nil then
            break;
        end;
        local desc = FruitUtil.fruitTypes[t];
        if desc ~= nil then
            local currentPS = {};

            local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/threshingStrawParticleSystem.i3d", self.baseDirectory);
            self.strawParticleSystems[desc.index] = currentPS;
            if self.defaultStrawParticleSystem == nil then
                self.defaultStrawParticleSystem = currentPS;
            end;
        end;
        i = i + 1;
    end;

    self.strawToggleTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.strawParticleSystems#toggleTime"), 2500);
    self.strawEnableTime = nil;
    self.strawDisableTime = nil;
    self.strawEmitState = false;

    self.combineSize = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.combineSize"), 1);

    local numStrawAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.strawAreas#count"), 0);
    self.strawAreas = {}
    for i=1, numStrawAreas do
        local area = {};
        local areanamei = string.format("vehicle.strawAreas.strawArea%d", i);
        area.start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        area.width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        area.height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
        table.insert(self.strawAreas, area);
    end;

    self.threshingScale = 1;	
    self.isThreshing = false;
	
    self.chopperActivated = false;
    self.defaultChopperState = false;
	
    self.pipeOpening = false;
    self.pipeOpen = false;
    self.pipeClose = true;
    self.pipeParticleActivated = false;
	
    self.grainTankFruitTypes = {};
    self.grainTankFruitTypes[FruitUtil.FRUITTYPE_UNKNOWN] = true;

    local fruitTypes = getXMLString(xmlFile, "vehicle.grainTankFruitTypes#fruitTypes");
    if fruitTypes ~= nil then
        local types = Utils.splitString(" ", fruitTypes);
        for k,v in pairs(types) do
            local desc = FruitUtil.fruitTypes[v];
            if desc ~= nil then
                self.grainTankFruitTypes[desc.index] = true;
            end;
        end;
    end;

    self.currentGrainTankFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.grainTankFillLevel = 0;
    self:setGrainTankFillLevel(0.0, FruitUtil.FRUITTYPE_UNKNOWN);

    self.minThreshold = 0.05;

    self.speedDisplayScale = 1.0;
    self.drawFillLevel = true;

    self.attachedCutters = {};
    self.numAttachedCutters = 0;

    self.lastLastArea = 0;
    self.lastArea = 0;
	
	--wiateka--
	self.Swiatelko1Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko1#index"));
	self.Swiatelko2Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko2#index"));
	self.Swiatelko3Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko3#index"));
	self.Swiatelko4Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko4#index"));
	self.Swiatelko5Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko5#index"));
	self.Swiatelko6Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko6#index"));
	self.Swiatelko7Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko7#index"));
	self.Swiatelko8Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko8#index"));
	self.Swiatelko9Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko9#index"));
	self.Swiatelko10Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko10#index"));
	self.Swiatelko11Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko11#index"));
	self.Swiatelko12Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko12#index"));
	self.Swiatelko13Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko13#index"));
	self.Swiatelko14Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko14#index"));
	self.Swiatelko15Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko15#index"));
	self.Swiatelko16Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko16#index"));
	self.Swiatelko17Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko17#index"));
	self.Swiatelko18Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko18#index"));
	self.Swiatelko19Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko19#index"));
	self.Swiatelko20Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko20#index"));
	self.Swiatelko21Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko21#index"));
	self.Swiatelko22Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko22#index"));
	self.Swiatelko23Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko23#index"));
	self.Swiatelko24Node = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Swiatelko24#index"));
	--end--
	--Hektary--
	self.TreshedNumber = 0;
	self.TreshedTotalNumber = 0;
	--end--
end;

function Tucano480:delete()

    for k,v in pairs(self.pipeParticleSystems) do
        Utils.deleteParticleSystem(v);
    end;
    for k,v in pairs(self.chopperParticleSystems) do
        Utils.deleteParticleSystem(v);
    end;
    for k,v in pairs(self.strawParticleSystems) do
        Utils.deleteParticleSystem(v);
    end;

    if self.threshingStartSound ~= nil then
        delete(self.threshingStartSound);
    end;
    if self.threshingSound ~= nil then
        delete(self.threshingSound);
    end;
    if self.cutterthreshingSound ~= nil then
        delete(self.cutterthreshingSound);
    end;
    if self.threshingStopSound ~= nil then
        delete(self.threshingStopSound);
    end;
    if self.pipeSound ~= nil then
        delete(self.pipeSound);
    end;

end;

function Tucano480:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    local fillLevel = getXMLFloat(xmlFile, key.."#grainTankFillLevel");
    local fruitType = getXMLString(xmlFile, key.."#grainTankFruitType");
    if fillLevel ~= nil and fruitType ~= nil then
        local fruitTypeDesc = FruitUtil.fruitTypes[fruitType];
        if fruitTypeDesc ~= nil then
            self:setGrainTankFillLevel(fillLevel, fruitTypeDesc.index);
        end;
    end;
   local TreshedTotalNumber =  Utils.getNoNil(getXMLFloat(xmlFile, key.."#TreshedTotalNumber"),0);
   self.TreshedTotalNumber = TreshedTotalNumber;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Tucano480:getSaveAttributesAndNodes(nodeIdent)
    local fruitType = "unknown";
    if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        fruitType = FruitUtil.fruitIndexToDesc[self.currentGrainTankFruitType].name;
    end;
    local attributes = 'grainTankFillLevel="'..self.grainTankFillLevel..'" grainTankFruitType="'..fruitType..'"';
	local TreshedTotalNumber= Utils.getNoNil(self.TreshedTotalNumber, 10);
	local attributes = 'TreshedTotalNumber="'..string.format("%.1f",TreshedTotalNumber)..'"';
    return attributes, nil;
end;

function Tucano480:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Tucano480:keyEvent(unicode, sym, modifier, isDown)
	if InputBinding.isPressed(InputBinding.rundum) then
        self.rundumleuchtenAn = not self.rundumleuchtenAn;
        for i=1, self.rundumleuchtenAnz do
			setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
        end;
    end;
	
--[[Arbeitslicht/Rckfahrlicht start]]--
	if InputBinding.isPressed(InputBinding.hecklight) then	
      self.hecklightActive = not self.hecklightActive;
      setVisibility(self.extra_lights.heck, self.hecklightActive);
    end;
	if InputBinding.isPressed(InputBinding.frontlight) then	
      self.frontlightActive = not self.frontlightActive;
      setVisibility(self.extra_lights.front, self.frontlightActive);
    end;	
--[[Arbeitslicht/Rckfahrlicht ende]]--

	if InputBinding.isPressed(InputBinding.abtanken) then
		if self.pipeOpen then
			self.abtanken = not self.abtanken;
		end;
	end;

	if isDown and self.numAttachedCutters > 0 then
		if sym == Input.KEY_KP_2 or sym == Input.KEY_KP_4 or sym == Input.KEY_KP_6 or sym == Input.KEY_KP_8 or sym == Input.KEY_KP_1 or sym == Input.KEY_KP_3 then
			self.hydraulicSoundAllow = true;
		end;
	else
		self.hydraulicSoundAllow = false;
	end;	
	
    if InputBinding.isPressed(InputBinding.dreschen) then
		self.dreschen = not self.dreschen;
	end;
	
    if InputBinding.isPressed(InputBinding.Einstieg) then
		self.rotationMaxLeft = not self.rotationMaxLeft;
	end;
	
    if InputBinding.isPressed(InputBinding.korntank) then
		if self.korntank then
			self.rotationMaxLeft4 = false;
		else
			self.rotationMaxLeft2 = true;
			self.rotationMaxLeft3 = true;
		end;
		self.rotationMaxLeft11 = not self.rotationMaxLeft11;
		self.korntank = not self.korntank;
		self.korntankTimer = 2000;
		self.fuellstand = true;
	end;
	
	if InputBinding.isPressed(InputBinding.Rapstisch) then
		self.stol = not self.stol;
		setVisibility(self.dual2, self.stol);
	end;
	
    if InputBinding.isPressed(InputBinding.Pomoc) then
		self.helpPanel = not self.helpPanel;
	end;
    if InputBinding.isPressed(InputBinding.PomocAI) then
		self.helpPanelAI = not self.helpPanelAI;
	end;
	
end;

function Tucano480:update(dt)

	if g_currentMission.environment ~= nil and g_currentMission.environment.dayNightCycle and
              (g_currentMission.environment.dayTime > (20.5*1000*60*60) or g_currentMission.environment.dayTime < (5.5*1000*60*60)) and
              not self.lightsActive and self.isHired and not self.steeringEnabled then
		self.lightsActive = true;
	end;

	if not self.isHired and self.lightsActive and not self.isEntered or not g_currentMission.environment.dayNightCycle then
		self.lightsActive = false;
	end;

    for k, light in pairs(self.lights) do
        setVisibility(light, self.lightsActive);
    end;

    if not self.isAITractorActivated then
        if self:getIsActiveForInput() then
            if InputBinding.hasEvent(InputBinding.IGNITION) then
		        self.ignitionKey = not self.ignitionKey;
			    self.allowedIgnition = true;
	        end;
	    end;
	    if not self.allowedIgnition and  not self.ignitionKey then
            self.isMotorStarted = false;
            Motorized.stopSounds(self);
	        self.steeringEnabled = false;
            Utils.setEmittingState(self.exhaustParticleSystems, false)
	    end;
	    if not self.ignitionKey then
	        self.motorStopSoundVolume = 0;
        else
	        self.motorStopSoundVolume = self.motorStopSoundVolume2;
	    end;
	    if self.allowedIgnition then
	        if  not self.ignitionKey then
		        self.motorStopSoundVolume = self.motorStopSoundVolume2;
                self:stopMotor();
			    self.steeringEnabled = false;
                self.allowedIgnition = false;	
                for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
                end;
                self:onDeactivateAttachements();
	        elseif self.ignitionKey then
                self:startMotor();
                self.steeringEnabled = true;
                self.allowedIgnition = false;		
       	    end;
	    end;
    elseif not self.ignitionKey and not self.deactivateOnLeave then
		self:stopAITractor();
	end;

	if self.currentGrainTankFruitType == 3 or self.currentGrainTankFruitType == 4 then
		self.dreschen = true;
	end;
	
    if self:getIsActiveForInput() and self.isEntered then
	    if self.motor.speedLevel ~= 0 then
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] >= 10 then
			        self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] - 10;
			    end;
	    	end;
		else
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[3] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[3] = self.motor.maxRpm[3] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[3] >= 10 then
			        self.motor.maxRpm[3] = self.motor.maxRpm[3] - 10;
			    end;
	    	end;
		end;
	end;
	
    for cutter,implement in pairs(self.attachedCutters) do
        local jointDesc = self.attacherJoints[implement.jointDescIndex];
        self.hedernisko = jointDesc.moveDown;
    end;
	
	if self.numAttachedCutters > 0 then
		self.rotationMaxLeft10 = true;
	else
		self.rotationMaxLeft10 = false;
	end;
	
	if self.fuellstand then
		self.korntankTimer = self.korntankTimer - dt;
		if self.korntankTimer < 0 then
			if self.korntank then
				self.rotationMaxLeft4 = true;
			else
				self.rotationMaxLeft2 = false;
				self.rotationMaxLeft3 = false;
			end;
			self.fuellstand = false;
		end;
	end;
	
	if self.isThreshing then
		if self.rotorFan2 ~= nil then
			rotate(self.rotorFan2, 0, 0, -dt*0.015);
		end;
	end;
	
	if not self.isEntered then
		self.abtanken = true;
	end;
	
	--*********************************************************************************************************
	
        setVisibility(self.brakelights, brake);
        if self.brakeOn and not brake then
            if self.brakeSound ~= nil then
                setSamplePitch(self.brakeSound, self.brakeSoundPitchOffset);
                playSample(self.brakeSound, 1, 1, 0);
            end;
            self.brakeOn = false;
        end;
		
        inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);

        if InputBinding.isAxisZero(inputAxisY) then
			inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
        end;
			
		if self.isEntered ~= nil then
			if self.brakelightsActive then
				for i=1, self.numbrakelights do
					local brakelight = self.brakelights[i];
					setVisibility(brakelight, self.brakelightsActive);
				end;
			else
				for i=1, self.numbrakelights do
					local brakelight = self.brakelights[i];
					setVisibility(brakelight, self.brakelightsActive, false);
				end;
			end;
			if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
				self.brakelightsActive = true;
				self.braking = true;
			else
				self.brakelightsActive = false;
				self.braking = false;
			end;
		end;	
	
	--*********************************************************************************************************************************
	
	if self.hydraulicSoundAllow and not self.hydraulicPlaying then
		playSample(self.hydraulicSoundId,0,1,0);
		self.hydraulicPlaying = true;
	elseif not self.hydraulicSoundAllow and self.hydraulicPlaying then
		stopSample(self.hydraulicSoundId);
		self.hydraulicPlaying = false;
	end;
	
    local procent = self.grainTankFillLevel/self.grainTankCapacity*100;
	if procent >= 80 then
		if not self.rundumleuchtenAn then
			self.rundumleuchtenAn = true;
			for i=1, self.rundumleuchtenAnz do
				setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
			end;
		end;
	else
		if not self.isEntered then
			self.rundumleuchtenAn = false;
			for i=1, self.rundumleuchtenAnz do
				setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
			end;
		end;
	end;
	
	if self.isEntered then
		if self.warningPlayed == false then
			if procent >= 70 and procent < 71 then
				playSample(self.warningSoundId, 1, 1, 0);
				self.warningPlayed = true;
			end;
			if procent >= 90 and procent < 91 then
				playSample(self.warningSoundId, 1, 1, 0);
				self.warningPlayed = true;
			end;
			if procent >= 100 and procent < 101 then
				playSample(self.warningSoundId, 1, 1, 0);
				self.warningPlayed = true;
			end;
		end;

		if procent < 70 and procent > 70 then
			self.warningPlayed = false;
		end;
		if procent < 90 and procent > 90 then
			self.warningPlayed = false;
		end;
		if procent < 100 and procent > 100 then
			self.warningPlayed = false;
		end;
	end;
	
	if self.rundumleuchtenAn == true then
		setVisibility(self.rullight, true);
	else
		setVisibility(self.rullight, false);
    end;
		
    if self.rundumleuchtenAnz > 0 then
      if self.rundumleuchtenAn then
        for i=1, self.rundumleuchtenAnz do
          rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
        end;
      end;
    end;

	if self.rotationPartLeft ~= nil then
		local x, y, z = getRotation(self.rotationPartLeft.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft.maxRot, self.rotationPartLeft.minRot, 3, self.rotationPartLeft.rotTime, dt, not self.rotationMaxLeft);
		setRotation(self.rotationPartLeft.node, unpack(newRot));
	end;
		
	if self.rotationPartLeft2 ~= nil then
		local x, y, z = getRotation(self.rotationPartLeft2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft2.maxRot, self.rotationPartLeft2.minRot, 3, self.rotationPartLeft2.rotTime, dt, not self.rotationMaxLeft2);
		setRotation(self.rotationPartLeft2.node, unpack(newRot));
	end;
		
	if self.rotationPartLeft3 ~= nil then
		local x, y, z = getRotation(self.rotationPartLeft3.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft3.maxRot, self.rotationPartLeft3.minRot, 3, self.rotationPartLeft3.rotTime, dt, not self.rotationMaxLeft3);
		setRotation(self.rotationPartLeft3.node, unpack(newRot));
	end;
		
	if self.rotationPartLeft4 ~= nil then
		local x, y, z = getRotation(self.rotationPartLeft4.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft4.maxRot, self.rotationPartLeft4.minRot, 3, self.rotationPartLeft4.rotTime, dt, not self.rotationMaxLeft4);
		setRotation(self.rotationPartLeft4.node, unpack(newRot));
	end;
		
	if self.rotationPartLeft10 ~= nil then
		local x, y, z = getRotation(self.rotationPartLeft10.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft10.maxRot, self.rotationPartLeft10.minRot, 3, self.rotationPartLeft10.rotTime, dt, not self.rotationMaxLeft10);
		setRotation(self.rotationPartLeft10.node, unpack(newRot));
	end;
		
	if self.rotationPartLeft11 ~= nil then
		local x, y, z = getRotation(self.rotationPartLeft11.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft11.maxRot, self.rotationPartLeft11.minRot, 3, self.rotationPartLeft11.rotTime, dt, not self.rotationMaxLeft11);
		setRotation(self.rotationPartLeft11.node, unpack(newRot));
	end;
	
    if self:getIsActive() then
        if self.isThreshingStarted then
            if self.playThreshingSound then
                if self:getIsActiveForSound() then
                    if self.threshingSound ~= nil and self.playThreshingSoundTime <= self.time then
                        playSample(self.threshingSound, 0, 1, 0);
						playSample(self.cutterthreshingSound, 0, 1, 0);
                        self.playThreshingSound = false;
                        self.threshingSoundActive = true;
                    end;
                end;
            end;
        end;
        if self:getIsActiveForInput() then
            if self.grainTankFillLevel < self.grainTankCapacity then
                if InputBinding.hasEvent(InputBinding.ACTIVATE_THRESHING) then
                    if self.isThreshing then
                        self:stopThreshing();
                    else
                        self:startThreshing();
                    end;
                end;
            end;
            if InputBinding.hasEvent(InputBinding.EMPTY_GRAIN) then
                if self.pipeOpening then
                    self:closePipe();
                else
                    self:openPipe();
                end;
            end;
        end;
        if self.grainTankFillLevel >= self.grainTankCapacity then
            self:stopThreshing();
        end;
		if self.isThreshing and self.rotorFan ~= nil then
			rotate(self.rotorFan, dt*0.005, 0, 0);
		end;
        local disableChopperEmit = true;
        local disableStrawEmit = true;
        if self.isThreshing then
            local lastArea = 0;
            local fruitType = FruitUtil.FRUITTYPE_UNKNOWN;
            for cutter,implement in pairs(self.attachedCutters) do
                if cutter.reelStarted then
                    if cutter.lastArea > 0 then
                        for cutter,implement in pairs(self.attachedCutters) do
                            cutter:setFruitType(cutter.currentFruitType);
                            self.currentGrainTankFruitType = cutter.currentFruitType;
                        end;
                        fruitType = cutter.currentFruitType;
                        lastArea = lastArea + cutter.lastArea;
                    end;
                end;
            end;
            self.lastArea = lastArea;
            if lastArea > 0 then
                local fruitDesc = FruitUtil.fruitIndexToDesc[fruitType];
                if fruitDesc.hasStraw then
                    self.chopperActivated = false;
                else
                    self.chopperActivated = true;
                end;
                if self.chopperActivated then
                    if self.chopperEnableTime == nil then
                        self.chopperEnableTime = self.time + self.chopperToggleTime;
                    else
                        self.chopperDisableTime = nil;
                    end;
                    disableChopperEmit = false;
                else
                    if self.strawEnableTime == nil then
                        self.strawEnableTime = self.time + self.strawToggleTime;
                    else
                        self.strawDisableTime = nil;
                    end;
                    disableStrawEmit = false;
                end;
                -- 8000/1200 = 6.66 liter/meter
                -- 8000/1200 / 6 = 1.111 liter/m^2
                -- 8000/1200 / 6 / 2^2 = 0.277777 liter / density pixel (density is 4096^2, on a area of 2048m^2
                local pixelToQm = 2048 / 4096 * 2048 / 4096  / g_currentMission.maxFruitValue; -- 4096px are mapped to 2048m
                local literPerQm = 1;
                if (fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN) then
                    literPerQm = FruitUtil.fruitIndexToDesc[fruitType].literPerQm * (1 + 0.5 * (3 - g_currentMission.missionStats.difficulty));
                end;
                --local literPerPixel = 8000/1200 / 6 / (2*2);
                --literPerPixel = literPerPixel*1.5;
                local qm = lastArea*pixelToQm;
                local newFillLevel = self.grainTankFillLevel+qm*literPerQm*self.threshingScale;
                self:setGrainTankFillLevel(newFillLevel, fruitType);
            end;
        end;
        if disableChopperEmit and self.chopperDisableTime == nil then
            self.chopperDisableTime = self.time + self.chopperToggleTime;
        end;
        if disableStrawEmit and self.strawDisableTime == nil then
            self.strawDisableTime = self.time + self.strawToggleTime;
        end;
        if self.grainTankFillLevel <= 0 then
            for cutter,implement in pairs(self.attachedCutters) do
                cutter:resetFruitType();
            end;
            self.currentGrainTankFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
        end;
        local chopperBlindRotationSpeed = 0.001;
        local minRotX = -83*3.1415/180.0;
        if self.chopperBlind ~= nil then
            local x,y,z = getRotation(self.chopperBlind);
            if self.chopperActivated then
                x = x-dt*chopperBlindRotationSpeed;
                if x < minRotX then
                    x = minRotX;
                end;
            else
                x = x+dt*chopperBlindRotationSpeed;
                if x > 0.0 then
                    x = 0.0;
                end;
            end;
            setRotation(self.chopperBlind, x, y, z);
        end;
        local pipeRotationSpeed = 0.0006;
        local pipeMinRotY = -90*3.1415/180.0;
        local pipeMaxRotX = 10*3.1415/180.0;
        local pipeXRotationSpeed = 0.00006;
        if self.pipe ~= nil then
            local x,y,z = getRotation(self.pipe);
            if self.pipeOpening then
                y = y-dt*pipeRotationSpeed;
                if y < pipeMinRotY then
                    y = pipeMinRotY;
                end;
                x = x+dt*pipeXRotationSpeed;
                if x > pipeMaxRotX then
                    x = pipeMaxRotX;
                end;
            else
                y = y+dt*pipeRotationSpeed;
                if y > 0.0 then
                    y = 0.0;
                end;
                x = x-dt*pipeXRotationSpeed;
                if x < 0.0 then
                    x = 0.0;
                end;
            end;
            setRotation(self.pipe, x, y, z);
            setRotation(self.pipeFlapLid, 0, y, 0);
            self.pipeOpen = (math.abs(pipeMinRotY-y) < 0.01);
            self.pipeClose =  ((x == 0) and (y == 0) );
        end;
        if self.motor ~= nil then
            if self.motor.speedLevel == 1 then
                self.speedDisplayScale = 0.5;
            elseif self.motor.speedLevel == 2 then
                self.speedDisplayScale = 0.6;
            else
                self.speedDisplayScale = 1.0;
            end;
        end;
        if not self.pipeOpen or not self.pipeClose then
            if self.pipeSound ~= nil and not self.pipeSoundEnabled then
                if self:getIsActiveForSound() then
                    setSamplePitch(self.pipeSound, self.pipeSoundPitchOffset);
                    playSample(self.pipeSound, 0, 1, 0);
                    self.pipeSoundEnabled = true;
                end;
            end;
        end;
        if self.pipeOpen then
            if self.pipeSound ~= nil and self.pipeSoundEnabled then
                stopSample(self.pipeSound);
                self.pipeSoundEnabled = false;
            end;
        end;
        if self.pipeClose then
            if self.pipeSound ~= nil and self.pipeSoundEnabled then
                stopSample(self.pipeSound);
                self.pipeSoundEnabled = false;
            end;
        end;
        if self.chopperEnableTime ~= nil and self.chopperEnableTime <= self.time then
            if self.currentChopperParticleSystem ~= nil then
                Utils.setEmittingState(self.currentChopperParticleSystem, false);
				Utils.setEmittingState(self.dustParticleSystems5, false);
				Utils.setEmittingState(self.dustParticleSystems6, false);
				Utils.setEmittingState(self.dustParticleSystems7, false);
				Utils.setEmittingState(self.dustParticleSystems8, false);
				Utils.setEmittingState(self.dustParticleSystems9, false);
				Utils.setEmittingState(self.dustParticleSystems10, false);
            end;
            self.currentChopperParticleSystem = self.chopperParticleSystems[self.currentGrainTankFruitType];
            if self.currentChopperParticleSystem == nil then
                self.currentChopperParticleSystem = self.defaultChopperParticleSystem;
            end;
			if self.currentGrainTankFruitType == 3 then
				Utils.setEmittingState(self.dustParticleSystems8, true);
				Utils.setEmittingState(self.dustParticleSystems9, true);
				Utils.setEmittingState(self.dustParticleSystems10, true);
			else
				Utils.setEmittingState(self.dustParticleSystems7, true);
				Utils.setEmittingState(self.dustParticleSystems6, true);
				Utils.setEmittingState(self.dustParticleSystems5, true);
			end;
			self.rotationMaxRight = true;
            self.chopperEnableTime = nil;
        end;
        if self.strawEnableTime ~= nil and self.strawEnableTime <= self.time then
            if self.currentStrawParticleSystem ~= nil then
                Utils.setEmittingState(self.currentStrawParticleSystem, false);
				Utils.setEmittingState(self.dustParticleSystems, false);
				Utils.setEmittingState(self.dustParticleSystems2, false);
				Utils.setEmittingState(self.dustParticleSystems3, false);
				Utils.setEmittingState(self.dustParticleSystems4, false);
				Utils.setEmittingState(self.dustParticleSystems11, false);
            end;
            self.currentStrawParticleSystem = self.strawParticleSystems[self.currentGrainTankFruitType];
            if self.currentStrawParticleSystem == nil then
                self.currentStrawParticleSystem = self.defaultStrawParticleSystem;
            end;
			Utils.setEmittingState(self.dustParticleSystems2, true);	
			if	not self.dreschen then
				Utils.setEmittingState(self.dustParticleSystems11, true);
				Utils.setEmittingState(self.currentStrawParticleSystem, true);
			else
				Utils.setEmittingState(self.dustParticleSystems3, true);
				Utils.setEmittingState(self.dustParticleSystems4, true);
			end;
			
            self.strawEnableTime = nil;
            self.strawEmitState = true;
        end;
		if not self.dreschen then
			if self.strawEmitState then
				for k, strawArea in pairs(self.strawAreas) do
					local x,y,z = getWorldTranslation(strawArea.start);
					local x1,y1,z1 = getWorldTranslation(strawArea.width);
					local x2,y2,z2 = getWorldTranslation(strawArea.height);
					local old, total = Utils.getFruitWindrowArea(self.currentGrainTankFruitType, x, z, x1, z1, x2, z2);
					local value = 1+math.floor(old / total + 0.7); -- round, biased to the bigger value
					value = math.min(value, g_currentMission.maxWindrowValue);
					Utils.updateFruitWindrowArea(self.currentGrainTankFruitType, x, z, x1, z1, x2, z2, value, true);
				end;
			end;
		end;
    end;
    if self.chopperDisableTime ~= nil and self.chopperDisableTime <= self.time then
        if self.currentChopperParticleSystem ~= nil then
            Utils.setEmittingState(self.currentChopperParticleSystem, false);
			Utils.setEmittingState(self.dustParticleSystems5, false);
			Utils.setEmittingState(self.dustParticleSystems6, false);
			Utils.setEmittingState(self.dustParticleSystems7, false);
			Utils.setEmittingState(self.dustParticleSystems8, false);
			Utils.setEmittingState(self.dustParticleSystems9, false);
			Utils.setEmittingState(self.dustParticleSystems10, false);
        end;
        self.currentChopperParticleSystem = self.chopperParticleSystems[self.currentGrainTankFruitType];
        if self.currentChopperParticleSystem == nil then
            self.currentChopperParticleSystem = self.defaultChopperParticleSystem;
        end;
        Utils.setEmittingState(self.currentChopperParticleSystem, false);
		Utils.setEmittingState(self.dustParticleSystems5, false);
		Utils.setEmittingState(self.dustParticleSystems6, false);
		Utils.setEmittingState(self.dustParticleSystems7, false);
		Utils.setEmittingState(self.dustParticleSystems8, false);
		Utils.setEmittingState(self.dustParticleSystems9, false);
		Utils.setEmittingState(self.dustParticleSystems10, false);
        self.chopperDisableTime = nil;
    end;
    if self.strawDisableTime ~= nil and self.strawDisableTime <= self.time then
        if self.currentStrawParticleSystem ~= nil then
			Utils.setEmittingState(self.currentStrawParticleSystem, false);
			Utils.setEmittingState(self.dustParticleSystems, false);
			Utils.setEmittingState(self.dustParticleSystems2, false);
			Utils.setEmittingState(self.dustParticleSystems3, false);
			Utils.setEmittingState(self.dustParticleSystems4, false);
			Utils.setEmittingState(self.dustParticleSystems11, false);
        end;
        self.currentStrawParticleSystem = self.strawParticleSystems[self.currentGrainTankFruitType];
        if self.currentStrawParticleSystem == nil then
            self.currentStrawParticleSystem = self.defaultStrawParticleSystem;
        end;
        Utils.setEmittingState(self.currentStrawParticleSystem, false);
		Utils.setEmittingState(self.dustParticleSystems, false);
		Utils.setEmittingState(self.dustParticleSystems2, false);
		Utils.setEmittingState(self.dustParticleSystems3, false);
		Utils.setEmittingState(self.dustParticleSystems4, false);
		Utils.setEmittingState(self.dustParticleSystems11, false);
        self.strawDisableTime = nil;
        self.strawEmitState = false;
    end;
    self.lastUnloadingTrailer = nil;
    self.pipeParticleActivated = false;
    if self.pipeOpen and self.abtanken then
        if self.grainTankFillLevel > 0 then
            self.pipeParticleActivated = true;
            -- test if we should drain the grain tank
            self.trailerFound = 0;
            local x,y,z = getWorldTranslation(self.pipeRaycastNode);
            raycastAll(x, y, z, 0, -1, 0, "findTrailerRaycastCallback", 10, self);
            local trailer = g_currentMission.objectToTrailer[self.trailerFound];
            self.lastUnloadingTrailer = trailer;
            if self.trailerFound == 0 or trailer == nil or not trailer:allowFillType(self.currentGrainTankFruitType, true) or not trailer.allowFillFromAir then
                self.pipeParticleActivated = false;
            else
                local deltaLevel = self.grainTankUnloadingCapacity*dt/1000.0;
                deltaLevel = math.min(deltaLevel, trailer.capacity - trailer.fillLevel);
                self.grainTankFillLevel = self.grainTankFillLevel-deltaLevel;
                if self.grainTankFillLevel <= 0.0 then
                    deltaLevel = deltaLevel+self.grainTankFillLevel;
                    self.grainTankFillLevel = 0.0;
                    self.pipeParticleActivated = false;
                end;
                if deltaLevel == 0 then
                    self.pipeParticleActivated = false;
                end;
                self:setGrainTankFillLevel(self.grainTankFillLevel, self.currentGrainTankFruitType);
                trailer:setFillLevel(trailer.fillLevel+deltaLevel, self.currentGrainTankFruitType);
            end;
        end;
    end;
    if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        if self.currentPipeParticleSystem ~= nil then
            Utils.setEmittingState(self.currentPipeParticleSystem, false);
        end;
        if self.pipeParticleActivated then
            self.currentPipeParticleSystem = self.pipeParticleSystems[self.currentGrainTankFruitType];
            if self.currentPipeParticleSystem == nil then
                self.currentPipeParticleSystem = self.defaultPipeParticleSystem;
            end;
            Utils.setEmittingState(self.currentPipeParticleSystem, true);
        end;
    end;
	if not self.rotationMaxLeft4 then
		self.fuellstandprocent = true;
	else
		self.fuellstandprocent = false;
	end;
	if self.isThreshing then
		self.rotationMaxLeft = true;
	end;
	if self.isThreshing or procent > 70 then
		if not self.korntank and self.fuellstandprocent then
			self.rotationMaxLeft2 = true;
			self.rotationMaxLeft3 = true;
			self.rotationMaxLeft11 = true;
			self.korntank = true;
			self.korntankTimer = 2000;
			self.fuellstand = true;
		end;
	else
	end;
	
	--wiateka--
	if procent == 0 then
		setVisibility(self.Swiatelko1Node, false);
		setVisibility(self.Swiatelko2Node, false);
		setVisibility(self.Swiatelko3Node, false);
		setVisibility(self.Swiatelko4Node, false);
		setVisibility(self.Swiatelko5Node, false);
		setVisibility(self.Swiatelko6Node, false);
		setVisibility(self.Swiatelko7Node, false);
		setVisibility(self.Swiatelko8Node, false);
		setVisibility(self.Swiatelko9Node, false);
		setVisibility(self.Swiatelko10Node, false);
		setVisibility(self.Swiatelko11Node, false);
		setVisibility(self.Swiatelko12Node, false);
		setVisibility(self.Swiatelko13Node, false);
		setVisibility(self.Swiatelko14Node, false);
		setVisibility(self.Swiatelko15Node, false);
		setVisibility(self.Swiatelko16Node, false);
		setVisibility(self.Swiatelko17Node, false);
		setVisibility(self.Swiatelko18Node, false);
		setVisibility(self.Swiatelko19Node, false);
		setVisibility(self.Swiatelko20Node, false);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 0 and procent <= 4 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node, false);
		setVisibility(self.Swiatelko3Node, false);
		setVisibility(self.Swiatelko4Node, false);
		setVisibility(self.Swiatelko5Node, false);
		setVisibility(self.Swiatelko6Node, false);
		setVisibility(self.Swiatelko7Node, false);
		setVisibility(self.Swiatelko8Node, false);
		setVisibility(self.Swiatelko9Node, false);
		setVisibility(self.Swiatelko10Node, false);
		setVisibility(self.Swiatelko11Node, false);
		setVisibility(self.Swiatelko12Node, false);
		setVisibility(self.Swiatelko13Node, false);
		setVisibility(self.Swiatelko14Node, false);
		setVisibility(self.Swiatelko15Node, false);
		setVisibility(self.Swiatelko16Node, false);
		setVisibility(self.Swiatelko17Node, false);
		setVisibility(self.Swiatelko18Node, false);
		setVisibility(self.Swiatelko19Node, false);
		setVisibility(self.Swiatelko20Node, false);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 4 and procent <= 8 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node, false);
		setVisibility(self.Swiatelko4Node, false);
		setVisibility(self.Swiatelko5Node, false);
		setVisibility(self.Swiatelko6Node, false);
		setVisibility(self.Swiatelko7Node, false);
		setVisibility(self.Swiatelko8Node, false);
		setVisibility(self.Swiatelko9Node, false);
		setVisibility(self.Swiatelko10Node, false);
		setVisibility(self.Swiatelko11Node, false);
		setVisibility(self.Swiatelko12Node, false);
		setVisibility(self.Swiatelko13Node, false);
		setVisibility(self.Swiatelko14Node, false);
		setVisibility(self.Swiatelko15Node, false);
		setVisibility(self.Swiatelko16Node, false);
		setVisibility(self.Swiatelko17Node, false);
		setVisibility(self.Swiatelko18Node, false);
		setVisibility(self.Swiatelko19Node, false);
		setVisibility(self.Swiatelko20Node, false);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 8 and procent <=12 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node, false);
		setVisibility(self.Swiatelko5Node, false);
		setVisibility(self.Swiatelko6Node, false);
		setVisibility(self.Swiatelko7Node, false);
		setVisibility(self.Swiatelko8Node, false);
		setVisibility(self.Swiatelko9Node, false);
		setVisibility(self.Swiatelko10Node, false);
		setVisibility(self.Swiatelko11Node, false);
		setVisibility(self.Swiatelko12Node, false);
		setVisibility(self.Swiatelko13Node, false);
		setVisibility(self.Swiatelko14Node, false);
		setVisibility(self.Swiatelko15Node, false);
		setVisibility(self.Swiatelko16Node, false);
		setVisibility(self.Swiatelko17Node, false);
		setVisibility(self.Swiatelko18Node, false);
		setVisibility(self.Swiatelko19Node, false);
		setVisibility(self.Swiatelko20Node, false);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 12 and procent <=17 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node, false);
		setVisibility(self.Swiatelko6Node, false);
		setVisibility(self.Swiatelko7Node, false);
		setVisibility(self.Swiatelko8Node, false);
		setVisibility(self.Swiatelko9Node, false);
		setVisibility(self.Swiatelko10Node, false);
		setVisibility(self.Swiatelko11Node, false);
		setVisibility(self.Swiatelko12Node, false);
		setVisibility(self.Swiatelko13Node, false);
		setVisibility(self.Swiatelko14Node, false);
		setVisibility(self.Swiatelko15Node, false);
		setVisibility(self.Swiatelko16Node, false);
		setVisibility(self.Swiatelko17Node, false);
		setVisibility(self.Swiatelko18Node, false);
		setVisibility(self.Swiatelko19Node, false);
		setVisibility(self.Swiatelko20Node, false);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 17 and procent <=21 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node);
		setVisibility(self.Swiatelko6Node, false);
		setVisibility(self.Swiatelko7Node, false);
		setVisibility(self.Swiatelko8Node, false);
		setVisibility(self.Swiatelko9Node, false);
		setVisibility(self.Swiatelko10Node, false);
		setVisibility(self.Swiatelko11Node, false);
		setVisibility(self.Swiatelko12Node, false);
		setVisibility(self.Swiatelko13Node, false);
		setVisibility(self.Swiatelko14Node, false);
		setVisibility(self.Swiatelko15Node, false);
		setVisibility(self.Swiatelko16Node, false);
		setVisibility(self.Swiatelko17Node, false);
		setVisibility(self.Swiatelko18Node, false);
		setVisibility(self.Swiatelko19Node, false);
		setVisibility(self.Swiatelko20Node, false);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 21 and procent <=25 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node);
		setVisibility(self.Swiatelko6Node);
		setVisibility(self.Swiatelko7Node, false);
		setVisibility(self.Swiatelko8Node, false);
		setVisibility(self.Swiatelko9Node, false);
		setVisibility(self.Swiatelko10Node, false);
		setVisibility(self.Swiatelko11Node, false);
		setVisibility(self.Swiatelko12Node, false);
		setVisibility(self.Swiatelko13Node, false);
		setVisibility(self.Swiatelko14Node, false);
		setVisibility(self.Swiatelko15Node, false);
		setVisibility(self.Swiatelko16Node, false);
		setVisibility(self.Swiatelko17Node, false);
		setVisibility(self.Swiatelko18Node, false);
		setVisibility(self.Swiatelko19Node, false);
		setVisibility(self.Swiatelko20Node, false);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 25 and procent <=29 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node);
		setVisibility(self.Swiatelko6Node);
		setVisibility(self.Swiatelko7Node);
		setVisibility(self.Swiatelko8Node, false);
		setVisibility(self.Swiatelko9Node, false);
		setVisibility(self.Swiatelko10Node, false);
		setVisibility(self.Swiatelko11Node, false);
		setVisibility(self.Swiatelko12Node, false);
		setVisibility(self.Swiatelko13Node, false);
		setVisibility(self.Swiatelko14Node, false);
		setVisibility(self.Swiatelko15Node, false);
		setVisibility(self.Swiatelko16Node, false);
		setVisibility(self.Swiatelko17Node, false);
		setVisibility(self.Swiatelko18Node, false);
		setVisibility(self.Swiatelko19Node, false);
		setVisibility(self.Swiatelko20Node, false);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 29 and procent <=33 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node);
		setVisibility(self.Swiatelko6Node);
		setVisibility(self.Swiatelko7Node);
		setVisibility(self.Swiatelko8Node);
		setVisibility(self.Swiatelko9Node, false);
		setVisibility(self.Swiatelko10Node, false);
		setVisibility(self.Swiatelko11Node, false);
		setVisibility(self.Swiatelko12Node, false);
		setVisibility(self.Swiatelko13Node, false);
		setVisibility(self.Swiatelko14Node, false);
		setVisibility(self.Swiatelko15Node, false);
		setVisibility(self.Swiatelko16Node, false);
		setVisibility(self.Swiatelko17Node, false);
		setVisibility(self.Swiatelko18Node, false);
		setVisibility(self.Swiatelko19Node, false);
		setVisibility(self.Swiatelko20Node, false);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 33 and procent <=37 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node);
		setVisibility(self.Swiatelko6Node);
		setVisibility(self.Swiatelko7Node);
		setVisibility(self.Swiatelko8Node);
		setVisibility(self.Swiatelko9Node);
		setVisibility(self.Swiatelko10Node, false);
		setVisibility(self.Swiatelko11Node, false);
		setVisibility(self.Swiatelko12Node, false);
		setVisibility(self.Swiatelko13Node, false);
		setVisibility(self.Swiatelko14Node, false);
		setVisibility(self.Swiatelko15Node, false);
		setVisibility(self.Swiatelko16Node, false);
		setVisibility(self.Swiatelko17Node, false);
		setVisibility(self.Swiatelko18Node, false);
		setVisibility(self.Swiatelko19Node, false);
		setVisibility(self.Swiatelko20Node, false);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 37 and procent <=42 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node);
		setVisibility(self.Swiatelko6Node);
		setVisibility(self.Swiatelko7Node);
		setVisibility(self.Swiatelko8Node);
		setVisibility(self.Swiatelko9Node);
		setVisibility(self.Swiatelko10Node);
		setVisibility(self.Swiatelko11Node, false);
		setVisibility(self.Swiatelko12Node, false);
		setVisibility(self.Swiatelko13Node, false);
		setVisibility(self.Swiatelko14Node, false);
		setVisibility(self.Swiatelko15Node, false);
		setVisibility(self.Swiatelko16Node, false);
		setVisibility(self.Swiatelko17Node, false);
		setVisibility(self.Swiatelko18Node, false);
		setVisibility(self.Swiatelko19Node, false);
		setVisibility(self.Swiatelko20Node, false);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 42 and procent <=46 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node);
		setVisibility(self.Swiatelko6Node);
		setVisibility(self.Swiatelko7Node);
		setVisibility(self.Swiatelko8Node);
		setVisibility(self.Swiatelko9Node);
		setVisibility(self.Swiatelko10Node);
		setVisibility(self.Swiatelko11Node);
		setVisibility(self.Swiatelko12Node, false);
		setVisibility(self.Swiatelko13Node, false);
		setVisibility(self.Swiatelko14Node, false);
		setVisibility(self.Swiatelko15Node, false);
		setVisibility(self.Swiatelko16Node, false);
		setVisibility(self.Swiatelko17Node, false);
		setVisibility(self.Swiatelko18Node, false);
		setVisibility(self.Swiatelko19Node, false);
		setVisibility(self.Swiatelko20Node, false);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 46 and procent <=50 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node);
		setVisibility(self.Swiatelko6Node);
		setVisibility(self.Swiatelko7Node);
		setVisibility(self.Swiatelko8Node);
		setVisibility(self.Swiatelko9Node);
		setVisibility(self.Swiatelko10Node);
		setVisibility(self.Swiatelko11Node);
		setVisibility(self.Swiatelko12Node);
		setVisibility(self.Swiatelko13Node, false);
		setVisibility(self.Swiatelko14Node, false);
		setVisibility(self.Swiatelko15Node, false);
		setVisibility(self.Swiatelko16Node, false);
		setVisibility(self.Swiatelko17Node, false);
		setVisibility(self.Swiatelko18Node, false);
		setVisibility(self.Swiatelko19Node, false);
		setVisibility(self.Swiatelko20Node, false);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 50 and procent <=54 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node);
		setVisibility(self.Swiatelko6Node);
		setVisibility(self.Swiatelko7Node);
		setVisibility(self.Swiatelko8Node);
		setVisibility(self.Swiatelko9Node);
		setVisibility(self.Swiatelko10Node);
		setVisibility(self.Swiatelko11Node);
		setVisibility(self.Swiatelko12Node);
		setVisibility(self.Swiatelko13Node);
		setVisibility(self.Swiatelko14Node, false);
		setVisibility(self.Swiatelko15Node, false);
		setVisibility(self.Swiatelko16Node, false);
		setVisibility(self.Swiatelko17Node, false);
		setVisibility(self.Swiatelko18Node, false);
		setVisibility(self.Swiatelko19Node, false);
		setVisibility(self.Swiatelko20Node, false);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 54 and procent <=58 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node);
		setVisibility(self.Swiatelko6Node);
		setVisibility(self.Swiatelko7Node);
		setVisibility(self.Swiatelko8Node);
		setVisibility(self.Swiatelko9Node);
		setVisibility(self.Swiatelko10Node);
		setVisibility(self.Swiatelko11Node);
		setVisibility(self.Swiatelko12Node);
		setVisibility(self.Swiatelko13Node);
		setVisibility(self.Swiatelko14Node);
		setVisibility(self.Swiatelko15Node, false);
		setVisibility(self.Swiatelko16Node, false);
		setVisibility(self.Swiatelko17Node, false);
		setVisibility(self.Swiatelko18Node, false);
		setVisibility(self.Swiatelko19Node, false);
		setVisibility(self.Swiatelko20Node, false);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 58 and procent <=62 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node);
		setVisibility(self.Swiatelko6Node);
		setVisibility(self.Swiatelko7Node);
		setVisibility(self.Swiatelko8Node);
		setVisibility(self.Swiatelko9Node);
		setVisibility(self.Swiatelko10Node);
		setVisibility(self.Swiatelko11Node);
		setVisibility(self.Swiatelko12Node);
		setVisibility(self.Swiatelko13Node);
		setVisibility(self.Swiatelko14Node);
		setVisibility(self.Swiatelko15Node);
		setVisibility(self.Swiatelko16Node, false);
		setVisibility(self.Swiatelko17Node, false);
		setVisibility(self.Swiatelko18Node, false);
		setVisibility(self.Swiatelko19Node, false);
		setVisibility(self.Swiatelko20Node, false);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 62 and procent <=66 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node);
		setVisibility(self.Swiatelko6Node);
		setVisibility(self.Swiatelko7Node);
		setVisibility(self.Swiatelko8Node);
		setVisibility(self.Swiatelko9Node);
		setVisibility(self.Swiatelko10Node);
		setVisibility(self.Swiatelko11Node);
		setVisibility(self.Swiatelko12Node);
		setVisibility(self.Swiatelko13Node);
		setVisibility(self.Swiatelko14Node);
		setVisibility(self.Swiatelko15Node);
		setVisibility(self.Swiatelko16Node);
		setVisibility(self.Swiatelko17Node, false);
		setVisibility(self.Swiatelko18Node, false);
		setVisibility(self.Swiatelko19Node, false);
		setVisibility(self.Swiatelko20Node, false);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 66 and procent <=71 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node);
		setVisibility(self.Swiatelko6Node);
		setVisibility(self.Swiatelko7Node);
		setVisibility(self.Swiatelko8Node);
		setVisibility(self.Swiatelko9Node);
		setVisibility(self.Swiatelko10Node);
		setVisibility(self.Swiatelko11Node);
		setVisibility(self.Swiatelko12Node);
		setVisibility(self.Swiatelko13Node);
		setVisibility(self.Swiatelko14Node);
		setVisibility(self.Swiatelko15Node);
		setVisibility(self.Swiatelko16Node);
		setVisibility(self.Swiatelko17Node);
		setVisibility(self.Swiatelko18Node, false);
		setVisibility(self.Swiatelko19Node, false);
		setVisibility(self.Swiatelko20Node, false);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 71 and procent <=75 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node);
		setVisibility(self.Swiatelko6Node);
		setVisibility(self.Swiatelko7Node);
		setVisibility(self.Swiatelko8Node);
		setVisibility(self.Swiatelko9Node);
		setVisibility(self.Swiatelko10Node);
		setVisibility(self.Swiatelko11Node);
		setVisibility(self.Swiatelko12Node);
		setVisibility(self.Swiatelko13Node);
		setVisibility(self.Swiatelko14Node);
		setVisibility(self.Swiatelko15Node);
		setVisibility(self.Swiatelko16Node);
		setVisibility(self.Swiatelko17Node);
		setVisibility(self.Swiatelko18Node);
		setVisibility(self.Swiatelko19Node, false);
		setVisibility(self.Swiatelko20Node, false);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 75 and procent <=79 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node);
		setVisibility(self.Swiatelko6Node);
		setVisibility(self.Swiatelko7Node);
		setVisibility(self.Swiatelko8Node);
		setVisibility(self.Swiatelko9Node);
		setVisibility(self.Swiatelko10Node);
		setVisibility(self.Swiatelko11Node);
		setVisibility(self.Swiatelko12Node);
		setVisibility(self.Swiatelko13Node);
		setVisibility(self.Swiatelko14Node);
		setVisibility(self.Swiatelko15Node);
		setVisibility(self.Swiatelko16Node);
		setVisibility(self.Swiatelko17Node);
		setVisibility(self.Swiatelko18Node);
		setVisibility(self.Swiatelko19Node);
		setVisibility(self.Swiatelko20Node, false);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 79 and procent <=83 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node);
		setVisibility(self.Swiatelko6Node);
		setVisibility(self.Swiatelko7Node);
		setVisibility(self.Swiatelko8Node);
		setVisibility(self.Swiatelko9Node);
		setVisibility(self.Swiatelko10Node);
		setVisibility(self.Swiatelko11Node);
		setVisibility(self.Swiatelko12Node);
		setVisibility(self.Swiatelko13Node);
		setVisibility(self.Swiatelko14Node);
		setVisibility(self.Swiatelko15Node);
		setVisibility(self.Swiatelko16Node);
		setVisibility(self.Swiatelko17Node);
		setVisibility(self.Swiatelko18Node);
		setVisibility(self.Swiatelko19Node);
		setVisibility(self.Swiatelko20Node);
		setVisibility(self.Swiatelko21Node, false);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 83 and procent <=87 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node);
		setVisibility(self.Swiatelko6Node);
		setVisibility(self.Swiatelko7Node);
		setVisibility(self.Swiatelko8Node);
		setVisibility(self.Swiatelko9Node);
		setVisibility(self.Swiatelko10Node);
		setVisibility(self.Swiatelko11Node);
		setVisibility(self.Swiatelko12Node);
		setVisibility(self.Swiatelko13Node);
		setVisibility(self.Swiatelko14Node);
		setVisibility(self.Swiatelko15Node);
		setVisibility(self.Swiatelko16Node);
		setVisibility(self.Swiatelko17Node);
		setVisibility(self.Swiatelko18Node);
		setVisibility(self.Swiatelko19Node);
		setVisibility(self.Swiatelko20Node);
		setVisibility(self.Swiatelko21Node);
		setVisibility(self.Swiatelko22Node, false);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 87 and procent <=92 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node);
		setVisibility(self.Swiatelko6Node);
		setVisibility(self.Swiatelko7Node);
		setVisibility(self.Swiatelko8Node);
		setVisibility(self.Swiatelko9Node);
		setVisibility(self.Swiatelko10Node);
		setVisibility(self.Swiatelko11Node);
		setVisibility(self.Swiatelko12Node);
		setVisibility(self.Swiatelko13Node);
		setVisibility(self.Swiatelko14Node);
		setVisibility(self.Swiatelko15Node);
		setVisibility(self.Swiatelko16Node);
		setVisibility(self.Swiatelko17Node);
		setVisibility(self.Swiatelko18Node);
		setVisibility(self.Swiatelko19Node);
		setVisibility(self.Swiatelko20Node);
		setVisibility(self.Swiatelko21Node);
		setVisibility(self.Swiatelko22Node);
		setVisibility(self.Swiatelko23Node, false);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 92 and procent <=96 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node);
		setVisibility(self.Swiatelko6Node);
		setVisibility(self.Swiatelko7Node);
		setVisibility(self.Swiatelko8Node);
		setVisibility(self.Swiatelko9Node);
		setVisibility(self.Swiatelko10Node);
		setVisibility(self.Swiatelko11Node);
		setVisibility(self.Swiatelko12Node);
		setVisibility(self.Swiatelko13Node);
		setVisibility(self.Swiatelko14Node);
		setVisibility(self.Swiatelko15Node);
		setVisibility(self.Swiatelko16Node);
		setVisibility(self.Swiatelko17Node);
		setVisibility(self.Swiatelko18Node);
		setVisibility(self.Swiatelko19Node);
		setVisibility(self.Swiatelko20Node);
		setVisibility(self.Swiatelko21Node);
		setVisibility(self.Swiatelko22Node);
		setVisibility(self.Swiatelko23Node);
		setVisibility(self.Swiatelko24Node, false);
	elseif procent > 96 and procent <=100 then
		setVisibility(self.Swiatelko1Node);
		setVisibility(self.Swiatelko2Node);
		setVisibility(self.Swiatelko3Node);
		setVisibility(self.Swiatelko4Node);
		setVisibility(self.Swiatelko5Node);
		setVisibility(self.Swiatelko6Node);
		setVisibility(self.Swiatelko7Node);
		setVisibility(self.Swiatelko8Node);
		setVisibility(self.Swiatelko9Node);
		setVisibility(self.Swiatelko10Node);
		setVisibility(self.Swiatelko11Node);
		setVisibility(self.Swiatelko12Node);
		setVisibility(self.Swiatelko13Node);
		setVisibility(self.Swiatelko14Node);
		setVisibility(self.Swiatelko15Node);
		setVisibility(self.Swiatelko16Node);
		setVisibility(self.Swiatelko17Node);
		setVisibility(self.Swiatelko18Node);
		setVisibility(self.Swiatelko19Node);
		setVisibility(self.Swiatelko20Node);
		setVisibility(self.Swiatelko21Node);
		setVisibility(self.Swiatelko22Node);
		setVisibility(self.Swiatelko23Node);
		setVisibility(self.Swiatelko24Node);
	end;
	--end--	
	
	--Hektary--
	if self.isThreshing then
		local pixelToQm = 2048 / 4096 * 2048 / 4096; -- 4096px are mapped to 2048m
		self.TreshedNumber = self.TreshedNumber + self.lastArea*pixelToQm/(40000);
		self.TreshedTotalNumber = self.TreshedTotalNumber + self.lastArea*pixelToQm/(40000);
	end;
	--end--
	--AI--
if self.isEntered then
	if g_tmpCourseX == nil and g_tmpCourseZ == nil then
		if	self.helpPanelAI then
			renderText(0.017,0.64,0.024,string.format("Wcisnij 7: Skopiuj kurs"));
		end;
	else
		if	self.helpPanelAI then
			renderText(0.017,0.64,0.024,string.format("Wcisnij 7: Zastosuj kurs"));
		end;
	end;

	if InputBinding.hasEvent(InputBinding.CopyCourse) then
		if g_tmpCourseX == nil and g_tmpCourseZ == nil then
			if self.aiThreshingDirectionX ~= nil and self.aiThreshingDirectionZ ~= nil then
				g_tmpCourseX,g_tmpCourseZ = self.aiThreshingDirectionX,self.aiThreshingDirectionZ
			end;
		else
			self.aiThreshingDirectionX,self.aiThreshingDirectionZ = g_tmpCourseX,g_tmpCourseZ
			g_tmpCourseX,g_tmpCourseZ = nil,nil
		end;
	end;
end;
	--END--
end;

function Tucano480:draw()
	g_currentMission:addExtraPrintText("www.landwirtschafts-simulator.pl");
    if not self.isMotorStarted and not self.automaticStart then	
		if self.helpPanel then
			renderText(0.14, 0.140, 0.02, string.format("Wcisnij NUM Enter: Zapal silnik"));
		end;
	else
		if self.helpPanel then
			renderText(0.14, 0.140, 0.02, string.format("Wcisnij NUM Enter: Zgas silnik"));
		end;
	end;
	
		if not self.helpPanel then
			renderText(0.8335, 0.15, 0.02, string.format("Wcisnij 0: Pokaz info"));
		else
			renderText(0.8335, 0.15, 0.02, string.format("Wcisnij 0: Ukryj info"));
		end;
		if self.helpPanel then
			if self.korntank then
				renderText(0.14, 0.120, 0.02, string.format("Wcisnij M: Zamknij zbiornik"));
			else
				renderText(0.14, 0.120, 0.02, string.format("Wcisnij M: Otworz zbiornik"));
			end;
			if self.hecklightActive then
				renderText(0.14, 0.060, 0.02, string.format("Wcisnij 5: Wylacz swiatla tylne"));
			else
				renderText(0.14, 0.060, 0.02, string.format("Wcisnij 5: Wlacz swiatla tylne"));
			end;
			if self.frontlightActive then
				renderText(0.14, 0.080, 0.02, string.format("Wcisnij 4: Wylacz swiatla robocze"));
			else
				renderText(0.14, 0.080, 0.02, string.format("Wcisnij 4: Wlacz swiatla robocze"));
			end;
			if self.dreschen then
				renderText(0.44, 0.120, 0.02, string.format("Wcisnij N: Sieczkrania wlaczona"));
			else
				renderText(0.44, 0.120, 0.02, string.format("Wcisnij N: Sieczkrania wylaczona"));
			end;
			if self.rotationMaxLeft then
				renderText(0.14, 0.020, 0.02, string.format("Wcisnij K: Otwarty"));
			else
				renderText(0.14, 0.020, 0.02, string.format("Wcisnij K: Zmkniety"));
			end;
			if self.rundumleuchtenAn then
				renderText(0.14, 0.040, 0.02, string.format("Wcisnij 6: Wylacz koguty"));
			else
				renderText(0.14, 0.040, 0.02, string.format("Wcisnij 6: Wlacz koguty"));
			end;			
			if self.motor.speedLevel ~= 0 then
				renderText(0.44, 0.140, 0.02, string.format("Wcisnij NUM +/-: %d RPM",self.motor.maxRpm[self.motor.speedLevel]));
			else
				renderText(0.44, 0.140, 0.02, string.format("Wcisnij NUM +/-: %d RPM",self.motor.maxRpm[3]));
			end;	
			if self.currentGrainTankFruitType == 1 then
				renderText(0.44, 0.080, 0.02, string.format("Aktualna uprawa: Pszenica"));
			elseif self.currentGrainTankFruitType == 2 then
				renderText(0.44, 0.080, 0.02, string.format("Aktualna uprawa: Jeczmien"));
			elseif self.currentGrainTankFruitType == 3 then
				renderText(0.44, 0.080, 0.02, string.format("Aktualna uprawa: Rzepak"));
			elseif self.currentGrainTankFruitType == 4 then
				renderText(0.44, 0.080, 0.02, string.format("Aktualna uprawa: Kukurydza"));
			else
				renderText(0.44, 0.080, 0.02, string.format("Aktualna uprawa: Brak"));
			end;			
			if not self.pipeOpen then
				renderText(0.44, 0.100, 0.02, string.format("Wcisnij B: Otworz rure"));
			else
				if self.abtanken then
					renderText(0.44, 0.100, 0.02, string.format("Wcisnij J: Wysypywanie wlaczone"));
				else
					renderText(0.44, 0.100, 0.02, string.format("Wcisnij J: Wysypywanie wylaczone"));
				end;
			end;
			self.hudClaasOverlay:render();
			setTextBold(true);
			renderText(0.011, 0.065, 0.021, string.format("Skoszone hektary:"));
            renderText(0.011, 0.050, 0.021, string.format("dzisiaj: %.1f", self.TreshedNumber));
			renderText(0.011, 0.035, 0.021, string.format("w sumie: %.1f", self.TreshedTotalNumber));
			setTextBold(false);
		end;
		if not self.helpPanelAI then
			g_currentMission:addExtraPrintText("Wcisnij O: Wlacz Menu AI");
		else
			g_currentMission:addExtraPrintText("Wcisnij O: Wylacz Menu AI");
		end;
		if self.helpPanelAI then
			self.hudClaasAIOverlay:render();
		end;
		
    local percent = self.grainTankFillLevel/self.grainTankCapacity*100;
    if self.drawFillLevel then
        self:drawGrainLevel(self.grainTankFillLevel, self.grainTankCapacity, 95);
    end;
    --[[if self.pipeOpen and not self.pipeParticleActivated and self.grainTankFillLevel > 0 then
        g_currentMission:addExtraPrintText(g_i18n:getText("Move_the_pipe_over_a_trailer"));
    elseif self.grainTankFillLevel == self.grainTankCapacity then
        g_currentMission:addExtraPrintText(g_i18n:getText("Dump_corn_to_continue_threshing"));
    end;
    if self.pipeOpening then
        g_currentMission:addHelpButtonText(g_i18n:getText("Pipe_in"), InputBinding.EMPTY_GRAIN);
    else
        if percent > 80 then
            g_currentMission:addHelpButtonText(g_i18n:getText("Dump_corn"), InputBinding.EMPTY_GRAIN);
        end;
    end;]]--
    if self.numAttachedCutters > 0 then
        if self.isThreshing then
			if self.helpPanel then
				renderText(0.14, 0.100, 0.02, string.format("Wcisnij G: Wylaczenie zespolu zniwnego"));
			end;
        else
			if self.helpPanel then
				renderText(0.14, 0.100, 0.02, string.format("Wcisnij G: Wlaczenie zespolu zniwnego"));
			end;
        end;
	else
		if self.helpPanel then
			renderText(0.14, 0.100, 0.02, string.format("Podlacz heder aby wlaczyc zespol zniwny"));
		end;
    end;
    if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        g_currentMission.fruitOverlays[self.currentGrainTankFruitType]:render();
    end;
	--AI--
        if self.marker == nil then self.marker = 1 ;end
		for cutter,implement in pairs(self.attachedCutters) do
			if cutter.aiLeftMarker ~= nil then
				if self.leftMarker == nil then
					self.leftMarker = cutter.aiLeftMarker;
				end;
			end;
			if cutter.aiRightMarker ~= nil then
				if self.rightMarker == nil then
					self.rightMarker = cutter.aiRightMarker;
				end;
			end;
		end	
		if self.leftMarker then	
			local lInX,  lInY,  lInZ = getTranslation(self.leftMarker);
			local rInX,  rInY,  rInZ = getTranslation(self.rightMarker);
			if self.helpPanelAI then
				setTextBold(true);
				renderText(0.017,0.51,0.024,string.format("Liczba kombajnow: %d",self.marker ));
				renderText(0.017,0.61,0.024,string.format("Wcisnij 8: Zmniejsz"));
				renderText(0.017,0.59,0.024,string.format("liczbe kombajnow"));
				renderText(0.017,0.56,0.024,string.format("Wcisnij 9: Zwieksz"));
				renderText(0.017,0.54,0.024,string.format("liczbe kombajnow"));
			end;
			
			
				if  self.marker == 1 then 
					
			     markerleft = lInX
					markerright = rInX
				end;
		    if InputBinding.hasEvent(InputBinding.AIbigger) then 
				self.marker = self.marker + 1	
				if self.marker > 10 then self.marker = 10 ;end
		    end;
			if InputBinding.hasEvent(InputBinding.AIsmaller) then 
				self.marker = self.marker - 1
				if self.marker < 1 then self.marker = 1 ;end
			
			end;
			setTranslation (self.leftMarker,markerleft * self.marker,  lInY ,  lInZ)
			setTranslation (self.rightMarker,markerright * self.marker,  rInY,  rInZ)
		end;
     --[[
	    local x,y,z = localDirectionToWorld(self.rootNode, 0, 0, 1);
		local length = Utils.vector2Length(x,z);
		local dX = x/length
		local dZ = z/length
		local x,y,z = getWorldTranslation(self.rootNode);
		self.aiTractorTargetX = x;
        self.aiTractorTargetZ = z;
		local TEntfernung = math.sqrt(dX * dX + dZ * dZ)
		local TRichtung = math.deg(math.atan2(dX,dZ))	
		if TRichtung < 0  then 
		TRichtung = 360 - (TRichtung * -1)
        end
		
		
		
		  g_currentMission:addHelpButtonText(g_i18n:getText("Course Right"), InputBinding.CourseRight);
		  g_currentMission:addHelpButtonText(g_i18n:getText("Course Left"), InputBinding.CourseLeft);
		   if InputBinding.hasEvent(InputBinding.CourseLeft) then 
	local x,y,z = localDirectionToWorld(self.rootNode,1*math.tan(math.rad(0.5)),0, 1);
		local length = Utils.vector2Length(x,z);
		self.aiThreshingDirectionX = x/length
		self.aiThreshingDirectionZ = z/length
    end

	if InputBinding.hasEvent(InputBinding.CourseRight) then 
	local x,y,z = localDirectionToWorld(self.rootNode,1*math.tan(math.rad(0.5)),0, 1);
		local length = Utils.vector2Length(x,z);
		self.aiThreshingDirectionX = x/length
		self.aiThreshingDirectionZ = z/length
	end
		renderText(0.75,0.77,0.03,string.format("Richtung: %f ",360 - math.floor(TRichtung + 0.5) ));
		self.KompassX = TEntfernung * math.sin(math.rad( math.floor(TRichtung + 0.5)) )
		self.KompassZ = TEntfernung * math.cos(math.rad( math.floor(TRichtung + 0.5)) )
		
		
		if self.kurs then
		renderText(0.75,0.74,0.03,string.format("neuer kurs: %f ",360 - math.floor(self.turn + 0.5) ));
	
		g_currentMission:addHelpButtonText(g_i18n:getText("Copy Course"), InputBinding.CopyCourse);
		
			if InputBinding.hasEvent(InputBinding.CopyCourse) then
				TRichtung = self.turn
				self.kurs = false
				self.aiThreshingDirectionX = self.KompassX;self.aiThreshingDirectionZ = self.KompassZ
				local x,y,z = getTranslation(self.rootNode);
				local rx,ry,rz = getRotation(self.rootNode);
				setTranslation(self.rootNode, x,  y + 200,  z)
				setRotation(self.rootNode,rx , (math.rad(  math.floor(TRichtung + 0.5)) ), rz)
				setTranslation(self.rootNode, x,  y,  z)
				end
			
			else	
			renderText(0.75,0.74,0.03,string.format("neuer kurs: %f ",360 - math.floor(TRichtung + 0.5) ));	
		end		
		]]
	--AI END--
end;

function Tucano480:onEnter()
    if self.isThreshingStarted then
        self.playThreshingSound = true;
    end;
	self.abtanken = false;
end;

function Tucano480:onLeave()
	self.hecklightActive = false;
	self.frontlightActive = false;
	if not self.deactivateOnLeave then
	    self.allowedIgnition = false;
	    self.ignitionKey = true; 
    else
	    self.allowedIgnition = false;
	    self.ignitionKey = false;
	end;
    if self.deactivateOnLeave then
        Tucano480.onDeactivate(self);
    else
        Tucano480.onDeactivateSounds(self)
    end;
end;

function Tucano480:onDeactivate()
    self:stopThreshing();
    for k,v in pairs(self.chopperParticleSystems) do
        Utils.setEmittingState(v, false);
    end;
    for k,v in pairs(self.strawParticleSystems) do
        Utils.setEmittingState(v, false);
    end;
    self.chopperEnableTime = nil;
    self.chopperDisableTime = nil;
    self.strawEnableTime = nil;
    self.strawDisableTime = nil;
    self.strawEmitState = false;
    Tucano480.onDeactivateSounds(self)
end;

function Tucano480:onDeactivateSounds()
    if self.pipeSound ~= nil and self.pipeSoundEnabled then
        stopSample(self.pipeSound);
        self.pipeSoundEnabled = false;
    end;
    if self.threshingSound ~= nil then
        stopSample(self.threshingSound);
		stopSample(self.cutterthreshingSound);
    end;
end;

function Tucano480:attachImplement(implement)
    local object = implement.object;
    if object.attacherJoint.jointType == Vehicle.JOINTTYPE_CUTTER then
        self.attachedCutters[object] = implement;
        self.numAttachedCutters = self.numAttachedCutters+1;
        object:setFruitType(self.currentGrainTankFruitType);
    end;
end;

function Tucano480:detachImplement(implementIndex)
    local object = self.attachedImplements[implementIndex].object;
    if object.attacherJoint.jointType == Vehicle.JOINTTYPE_CUTTER then
        self.numAttachedCutters = self.numAttachedCutters-1;
        if self.numAttachedCutters == 0 then
            self:stopThreshing()
        end;
        self.attachedCutters[object] = nil;
    end;
end;

function Tucano480:allowGrainTankFruitType(fruitType)
    local allowed = false;
    if self.grainTankFruitTypes[fruitType] then -- is fruit type accepted by combine?
        if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then -- is combine currently not empty?
            if self.currentGrainTankFruitType ~= fruitType then -- is there another fill type in the tank?
                if self.grainTankFillLevel / self.grainTankCapacity <= self.minThreshold then
                    allowed = true; -- fill level is low enough to be overridden
                end;
            else
                allowed = true; -- fill type is the same as the combine's current fill type
            end;
        else
            allowed = true; -- combine is empty --> FruitUtil.FRUITTYPE_UNKNOWN
        end;
    end;

    return allowed;
end;

function Tucano480:emptyGrainTankIfLowFillLevel()
    if self.grainTankFillLevel / self.grainTankCapacity <= self.minThreshold then
        self.grainTankFillLevel = 0; -- empty the combine
        --return true;
    end;
    --return false;
end;

function Tucano480:setGrainTankFillLevel(fillLevel, fruitType)
    if not self:allowGrainTankFruitType(fruitType) then
        return;
    end;
    self.grainTankFillLevel = Utils.clamp(fillLevel, 0, self.grainTankCapacity);
    if self.currentGrainTankFruitType ~= fruitType then
        self.currentGrainTankFruitType = fruitType;
        if self.currentGrainTankPlane ~= nil then
            setVisibility(self.currentGrainTankPlane, false);
        end;
        if self.currentGrainTankPlaneWindow ~= nil then
            setVisibility(self.currentGrainTankPlaneWindow, false);
        end;
    end;
    if self.grainTankPlanes ~= nil and self.defaultGrainTankPlane ~= nil and fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        local fruitTypeName = FruitUtil.fruitIndexToDesc[fruitType].name;
        local grainPlane = self.grainTankPlanes[fruitTypeName];
        if grainPlane == nil then
            grainPlane = self.defaultGrainTankPlane;
        end;
        if grainPlane.node ~= nil then
            local yTranslation = 0;
            if self.grainTankPlaneAnimCurve then
                local scaleX, scaleY, scaleZ , yTrans = self.grainTankPlaneAnimCurve:get(self.grainTankFillLevel/self.grainTankCapacity);
                yTranslation = yTrans;
                setScale(grainPlane.node, scaleX, scaleY, scaleZ);
            else
                local m = (self.grainTankPlaneMaxY - self.grainTankPlaneMinY) / self.grainTankCapacity;
                yTranslation = m*self.grainTankFillLevel + self.grainTankPlaneMinY;
            end;
            local xPos, yPos, zPos = getTranslation(grainPlane.node);
            setTranslation(grainPlane.node, xPos, yTranslation, zPos);
            setVisibility(grainPlane.node, self.grainTankFillLevel > 0);
            self.currentGrainTankPlane = grainPlane.node;
        end;
        if grainPlane.windowNode ~= nil then
            local yTranslation = 0;
            if self.grainTankPlaneWindowAnimCurve then
                local scaleX, scaleY, scaleZ , yTrans, visiblity = self.grainTankPlaneWindowAnimCurve:get(self.grainTankFillLevel/self.grainTankCapacity);
                yTranslation = yTrans;
                setScale(grainPlane.windowNode, scaleX, scaleY, scaleZ);
                setVisibility(self.grainPlaneWindow, visiblity);
            else
                local m = (self.grainTankPlaneMaxY - self.grainTankPlaneMinY) / self.grainTankCapacity;
                local startFillLevel = (self.grainTankPlaneWindowStartY-self.grainTankPlaneMinY)/m;
                local yTranslation = math.min(m*(self.grainTankFillLevel-startFillLevel)+self.grainTankPlaneWindowMinY, self.grainTankPlaneWindowMaxY);
                setVisibility(grainPlane.windowNode, self.grainTankFillLevel >= startFillLevel);
            end;
            local xPos, yPos, zPos = getTranslation(grainPlane.windowNode);
            setTranslation(grainPlane.windowNode, xPos, yTranslation, zPos);
            self.currentGrainTankPlaneWindow = grainPlane.windowNode;
        end;
    end;
end;

function Tucano480:startThreshing()
    if not self.isThreshing then
        if self.numAttachedCutters > 0 then
            self.chopperActivated = self.defaultChopperState;
            self.isThreshing = true;
            for cutter,implement in pairs(self.attachedCutters) do
                local jointDesc = self.attacherJoints[implement.jointDescIndex];
                jointDesc.moveDown = true;
                cutter:setReelSpeed(0.003);
                cutter:onStartReel();
            end;
            if self.cutterthreshingSound ~= nil then
                setSamplePitch(self.cutterthreshingSound, math.min(self.cutterthreshingSoundPitchOffset + self.cutterthreshingSoundPitchScale*math.abs(self.lastSoundSpeed), self.cutterthreshingSoundPitchMax));
               playSample(self.cutterthreshingSound, 0, 1, 0);
            end;
            if not self.isThreshingStarted then
                self.isThreshingStarted = true;
                local threshingSoundOffset = 0;
                if self.threshingStartSound ~= nil and self:getIsActiveForSound() then
                    setSamplePitch(self.threshingStartSound, self.threshingStartSoundPitchOffset);
                    playSample(self.threshingStartSound, 1, 1, 0);
					playSample(self.warningSoundId, 1, 1, 0);
                    threshingSoundOffset = getSampleDuration(self.threshingStartSound);
                end;
                self.playThreshingSound = true;
                self.playThreshingSoundTime = self.time+threshingSoundOffset;
            end;
        end;
    end;
end;

function Tucano480:stopThreshing()
    if self.isThreshing then
        self.isThreshingStarted = false;
        self.playThreshingSound = false;
        if self.threshingSound ~= nil then
            stopSample(self.threshingSound);
			stopSample(self.cutterthreshingSound);
        end;
        if self.threshingStopSound ~= nil and self.threshingSoundActive and self:getIsActiveForSound() then
            setSamplePitch(self.threshingStopSound, self.threshingStopSoundPitchOffset);
            playSample(self.threshingStopSound, 1, 1, 0);
			playSample(self.warningSoundId, 1, 1, 0);
            self.threshingSoundActive = false;
        end;
        self.chopperActivated = false;
        self.isThreshing = false;
        for cutter,implement in pairs(self.attachedCutters) do
            local jointDesc = self.attacherJoints[implement.jointDescIndex];
            jointDesc.moveDown = false;
            cutter:onStopReel();
        end;
    end;

end;

function Tucano480:findTrailerRaycastCallback(transformId, x, y, z, distance)
    if getUserAttribute(transformId, "vehicleType") == 2 then
        self.trailerFound = transformId;
    end;
    return false;
end;

function Tucano480:openPipe()
	if not self.pipeOpening then
		playSample(self.warningSoundId, 1, 1, 0);
	end;
    self.pipeOpening = true;
end;

function Tucano480:closePipe()
	if self.pipeOpening then
		playSample(self.warningSoundId, 1, 1, 0);
	end;
    self.pipeOpening = false;
end;