--
-- OperatingHours
-- Specialization for counting the operating hours of a vehicle
--
-- @author  Manuel Leithner
-- @date  29/12/09
--

OperatingHours = {};

function OperatingHours.prerequisitesPresent(specializations)
    return true;
end;

function OperatingHours:load(xmlFile)

	self.addOperatingTime = SpecializationUtil.callSpecializationsFunction("addOperatingTime");
	self.operatingTime = 0;	
	
	self.ohX = 0.07;
	self.ohY = 0.085;	
	
end;

function OperatingHours:delete()
end;

function OperatingHours:mouseEvent(posX, posY, isDown, isUp, button)
end;

function OperatingHours:keyEvent(unicode, sym, modifier, isDown)
end;

function OperatingHours:update(dt)

    if self:getIsActive() or self.isHired then 
		self:addOperatingTime(dt);
	end;
end;

function OperatingHours:draw()
	if self.helpPanel then
		local operatingHours = math.floor((self.operatingTime / 1000 / 60 / 60)*10) / 10;
		local hours = math.floor(operatingHours);
		local minutes = tostring(math.floor((operatingHours - hours)*10));

		if hours < 10000 then
			offset = 1;
			if hours < 1000 then
				offset = 2;
				if hours < 100 then
					offset = 3;
					if hours < 10 then
						offset = 4;
					end;
				end;
			end;
		end;	
		setTextBold(true);	
		renderText(0.011, 0.087, 0.021, string.format("Czas pracy:"));
		renderText(self.ohX+offset*0.00815, self.ohY+0.002, 0.021, tostring(hours) .. ",");
		setTextColor(0.95,0,0,1);
		renderText(self.ohX+0.0465, self.ohY+0.002, 0.021, minutes);
		setTextColor(1,1,1,1);
		renderText(self.ohX+0.055, 0.087, 0.021, "h");
	end;
end;

function OperatingHours:addOperatingTime(addTime)
	
	local time = math.max(Utils.getNoNil(addTime, 0), 0);	
	self.operatingTime = self.operatingTime + time;	
	
	if self.operatingTime > (99999.9 * 1000 * 60 * 60) then
		self.operatingTime = 0;
	end;
end;

function OperatingHours:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	if not resetVehicles then
		local operatingTime = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#operatingTime"), self.operatingTime) * 1000;
		self:addOperatingTime(operatingTime);
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function OperatingHours:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'operatingTime="' .. tostring((self.operatingTime / 1000)) ..'"';
	return attributes, nil;
end;