--
-- unloadingPlanes.lua
-- choose the Plane where the Name end with _unloading when Trailer tipping
--
-- @author:    	Xentro (www.fs-uk.com)(Marcus@Xentro.se)
-- @version:    v1.0
-- @date:       2013-03-23

UnloadingPlanes = {};

UnloadingPlanes.DEFAULT = 4;
UnloadingPlanes.EXPANDED = 3;
UnloadingPlanes.UNLOAD = 2;
UnloadingPlanes.UNLOAD_EXPANDED = 1;

function UnloadingPlanes.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations) and SpecializationUtil.hasSpecialization(ExpandCapacity, specializations);
end;

function UnloadingPlanes:load(xmlFile)
	self.newPlane = {}
	self.newPlane[1] = {}
	self.newPlane[1].plane = {}
	self.newPlane[2] = {}
	self.newPlane[2].plane = {}
	self.newPlane[3] = {}
	self.newPlane[3].plane = {}
	for k, v in pairs(self.fillPlanes) do
		local n1, i1 = string.gsub(k, "_expand_unloading", "");
		if i1 == 1 then
			self.newPlane[1].plane[n1] = v;
			self.fillPlanes[k] = nil;
		end;
		
		local n2, i2 = string.gsub(k, "_unloading", "");
		if i2 == 1 then
			self.newPlane[2].plane[n2] = v;
			self.fillPlanes[k] = nil;
		end;
		
		local n3, i3 = string.gsub(k, "_expand", "");
		if i3 == 1 then
			self.newPlane[3].plane[n3] = v;
			self.fillPlanes[k] = nil;
		end;
	end;
	
	self.newPlane[4] = {}
	self.newPlane[4].plane = {}
	for k, v in pairs(self.fillPlanes) do
		self.newPlane[4].plane[k] = v;
	end;
	
	self.currentPlaneInUse = UnloadingPlanes.DEFAULT;
	self.lastPlaneInUse = self.currentPlaneInUse;
end;

function UnloadingPlanes:delete()
end;

function UnloadingPlanes:readStream(streamId, connection)
	self.currentPlaneInUse = streamReadInt8(streamId);
	self.lastPlaneInUse = streamReadInt8(streamId);
end;

function UnloadingPlanes:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.currentPlaneInUse);
	streamWriteInt8(streamId, self.lastPlaneInUse);
end;
 
function UnloadingPlanes:mouseEvent(posX, posY, isDown, isUp, button)
end;

function UnloadingPlanes:keyEvent(unicode, sym, modifier, isDown)
end;

function UnloadingPlanes:update(dt)
	if self.currentPlaneInUse == UnloadingPlanes.EXPANDED then
		if getAnimTrackTime(self.expCap.animCharSet, 0) <= self.expCap.animDuration then
			if self.fillPlanes ~= self.newPlane[UnloadingPlanes.DEFAULT].plane then
				self.fillPlanes = self.newPlane[UnloadingPlanes.DEFAULT].plane;
				self:setFillLevel(self.fillLevel, self.currentFillType);
			end;
		elseif getAnimTrackTime(self.expCap.animCharSet, 0) >= self.expCap.animDuration and self.pendingExpansion ~= nil then
			self:setExpansionState(self.pendingExpansion);
			self.pendingExpansion = nil;
		end;
	end;
	
	if self.currentPlaneInUse ~= self.lastPlaneInUse then
		local fillTypeName = Fillable.fillTypeIntToName[self.currentFillType];
		
		local update = true;
		if self.currentPlaneInUse == UnloadingPlanes.EXPANDED and getAnimTrackTime(self.expCap.animCharSet, 0) <= self.expCap.animDuration then
			update = false;
		end;
		
		if update then
			self.fillPlanes = self.newPlane[self.currentPlaneInUse].plane;
			
			local curPlane = self.fillPlanes[fillTypeName];
			if curPlane ~= nil then
				if curPlane.nodes ~= nil then
					for _, v in pairs(curPlane.nodes) do
						if v.node ~= nil then
							setVisibility(v.node, true);
						end;
					end;
				end;
			end;
			
			self:setFillLevel(self.fillLevel, self.currentFillType);
			
			for k, v in pairs(self.newPlane) do
				for _, v2 in pairs(v.plane) do
					for _, v3 in pairs(v2.nodes) do
						if k ~= self.currentPlaneInUse then
							if getVisibility(v3.node) then
								setVisibility(v3.node, false);
							end;
						end;
					end;
				end;
			end;
			
			self.lastPlaneInUse = self.currentPlaneInUse;
		end;
	end;
	 
	if self.expCap ~= nil then
		if self.tipState ~= Trailer.TIPSTATE_CLOSED then
			if not self.expCap.isExpandet then
				if self.currentPlaneInUse ~= UnloadingPlanes.UNLOAD then
					self.currentPlaneInUse = UnloadingPlanes.UNLOAD;
				end;
			else
				if self.currentPlaneInUse ~= UnloadingPlanes.UNLOAD_EXPANDED then
					self.currentPlaneInUse = UnloadingPlanes.UNLOAD_EXPANDED;
				end;
			end;
		else
			if not self.expCap.isExpandet then
				if self.currentPlaneInUse ~= UnloadingPlanes.DEFAULT then
					self.currentPlaneInUse = UnloadingPlanes.DEFAULT;
				end;
			else
				if self.currentPlaneInUse ~= UnloadingPlanes.EXPANDED then
					self.currentPlaneInUse = UnloadingPlanes.EXPANDED;
				end;
			end;
		end;
	end;
end;

function UnloadingPlanes:updateTick(dt)
end;

function UnloadingPlanes:draw()
end;