ExpandCapacityEvent = {};
ExpandCapacityEvent_mt = Class(ExpandCapacityEvent, Event);
InitEventClass(ExpandCapacityEvent, "ExpandCapacityEvent");
function ExpandCapacityEvent:emptyNew()
    local self = Event:new(ExpandCapacityEvent_mt);
    self.className="ExpandCapacityEvent";
    return self;
end;

function ExpandCapacityEvent:new(object, expansionState)
    local self = ExpandCapacityEvent:emptyNew(); 
    self.object = object; 
	self.expansionState = expansionState;
    return self;
end;

function ExpandCapacityEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.expansionState);
end;

function ExpandCapacityEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.expansionState = streamReadBool(streamId);
    self:run(connection);
end;

function ExpandCapacityEvent:run(connection)
	if self.object ~= nil then
		self.object:setExpansionState(self.expansionState, true);
	end;
	if not connection:getIsServer() then
		g_server:broadcastEvent(ExpandCapacityEvent:new(self.object, self.expansionState), nil, connection, self.object);
	end; 
end;

function ExpandCapacityEvent.sendEvent(object, expansionState, noEventSend)
	if noEventSend == nil or noEventSend == false then 
		if g_server ~= nil then   
			g_server:broadcastEvent(ExpandCapacityEvent:new(object, expansionState), nil, nil, object); 
		else  
			g_client:getServerConnection():sendEvent(ExpandCapacityEvent:new(object, expansionState)); 
		end;
	end;
end;