-- ExpandCapacity.lua
--
-- author: rafftnix
-- date: 10.01.2013
-- version: v1.0 (January 2013)

-- Keine Vernderung ohne meine Erlaubnis!
-- No modification without my permission!

ExpandCapacity = {};

function ExpandCapacity.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function ExpandCapacity:load(xmlFile)
	self.setExpansionState = SpecializationUtil.callSpecializationsFunction("setExpansionState");
	
	self.expCap = {}
	
	self.expCap.animNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.capacityExpander#animNodeIndex"));
	self.expCap.animCharSet = getAnimCharacterSet(self.expCap.animNode);
	local clip = getAnimClipIndex(self.expCap.animCharSet, getXMLString(xmlFile, "vehicle.capacityExpander#animName"));
	
	assignAnimTrackClip(self.expCap.animCharSet, 0, clip);
	setAnimTrackLoopState(self.expCap.animCharSet, 0, false);
	self.expCap.animDuration = getAnimClipDuration(self.expCap.animCharSet, clip);
	self.expCap.animEnabled = false;
	
	self.expCap.firstRunDone = false;
	self.expCap.isExpandet = false;
	self.expCap.unexpandetCapacity = self.capacity;
	self.expCap.expandCapacityFactor = getXMLFloat(xmlFile, "vehicle.capacityExpander#expandCapacityFactor");
	self.capacity = self.expCap.unexpandetCapacity * self.expCap.expandCapacityFactor;
	-- self.expCap.decreasedPlanes = self.fillPlanes;
	-- self.expCap.expandedPlanes = {}
	
	self.expCap.fadeInObjects = {}
	self.expCap.fadeOutObjects = {}
	
	local num = 0;
	while true do
		local index = getXMLString(xmlFile, string.format("vehicle.capacityExpander.fadeIn(%d)#index", num));
		if index == nil then
			break;
		end;
		local nodeId = Utils.indexToObject(self.components, index);
		setVisibility(nodeId, false);
		table.insert(self.expCap.fadeInObjects, nodeId);
		num = num + 1;
	end;

	local num = 0;
	while true do
		local index = getXMLString(xmlFile, string.format("vehicle.capacityExpander.fadeOut(%d)#index", num));
		if index == nil then
			break;
		end;
		local nodeId = Utils.indexToObject(self.components, index);
		setVisibility(nodeId, true);
		table.insert(self.expCap.fadeOutObjects, nodeId);
		num = num + 1;
	end;
	
	-- for k, v in pairs(self.fillPlanes) do
		-- local newName, num = string.gsub(k, "_expand", "");
		-- if num == 1 then
			-- self.expCap.expandedPlanes[newName] = v;
			-- self.fillPlanes[k] = nil;
		-- end;
	-- end;
end;

function ExpandCapacity:delete()
  
end;

function ExpandCapacity:readStream(streamId, connection)
	self:setExpansionState(streamReadBool(streamId), true);
end;

function ExpandCapacity:writeStream(streamId, connection)
	streamWriteBool(streamId, self.expCap.isExpandet);
end;

function ExpandCapacity:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	self.expCap.isExpandet = getXMLBool(xmlFile, key.."#capacityExpanded");
	if self.expCap.isExpandet then
		setAnimTrackTime(self.expCap.animCharSet, 0, self.expCap.animDuration);
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;
 
function ExpandCapacity:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'capacityExpanded="'..tostring(self.expCap.isExpandet)..'"';
	return attributes, nil;
end;
 
function ExpandCapacity:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ExpandCapacity:keyEvent(unicode, sym, modifier, isDown)
end;

function ExpandCapacity:update(dt)
	if self:getIsActiveForInput() and self.tipState == Trailer.TIPSTATE_CLOSED then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
			if not self.expCap.isExpandet or self.fillLevel <= self.expCap.unexpandetCapacity then
				self:setExpansionState(not self.expCap.isExpandet);
			end;
		end;
	end;

	-- animation			
	if self.expCap.animEnabled then
		local trackTime = getAnimTrackTime(self.expCap.animCharSet, 0);
		if trackTime < 0 or trackTime > self.expCap.animDuration then
			disableAnimTrack(self.expCap.animCharSet, 0);
			self.expCap.animEnabled = false;
		end;
	end;
end;

function ExpandCapacity:updateTick(dt)
	if not self.expCap.firstRunDone then
		self.expCap.firstRunDone = true;
		self:setExpansionState(self.expCap.isExpandet);
		self:setFillLevel(self.fillLevel, self.currentFillType);
	end;
end;

function ExpandCapacity:draw()
	if self.expCap.isExpandet then
		if self.fillLevel <= self.expCap.unexpandetCapacity then
			g_currentMission:addHelpButtonText(g_i18n:getText("decreaseCapacity"), InputBinding.IMPLEMENT_EXTRA3);
		end;
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("expandCapacity"), InputBinding.IMPLEMENT_EXTRA3);
	end;
end;

function ExpandCapacity:setExpansionState(state, noEventSend)
	self.expCap.isExpandet = state;
		
	-- set capacity & planes
	-- local fillTypeName = Fillable.fillTypeIntToName[self.currentFillType];
	-- local fillPlane = self.fillPlanes[fillTypeName];
	-- if fillPlane ~= nil then
		-- for k, v in pairs(fillPlane) do
			-- setVisibility(v.node, false);
		-- end;
	-- end;
 
	if state then
		if getAnimTrackTime(self.expCap.animCharSet, 0) <= self.expCap.animDuration then
			self.pendingExpansion = state;
		else
			self.capacity = self.expCap.unexpandetCapacity * self.expCap.expandCapacityFactor;
			-- if getAnimTrackTime(self.expCap.animCharSet, 0) == self.expCap.animCharSet then
				-- self.fillPlanes = self.expCap.expandedPlanes;
			-- end;
		end;
	else
		self.capacity = self.expCap.unexpandetCapacity;
		--self.fillPlanes = self.expCap.decreasedPlanes;
	end;
	
	-- local fillPlane = self.fillPlanes[fillTypeName];
	-- if fillPlane ~= nil then
		-- for k, v in pairs(fillPlane) do
			-- setVisibility(v.node, self.fillLevel > 0);
		-- end;
	-- end;
	
	-- self:setFillLevel(self.fillLevel, self.currentFillType);
	
	-- animation
	local speedScale = 1;
	local currentTrackTime = getAnimTrackTime(self.expCap.animCharSet, 0);
	local trackTime = math.max(0, currentTrackTime);
	if not self.expCap.isExpandet then
		speedScale = -1;
		trackTime = math.min(self.expCap.animDuration, currentTrackTime);
	end;
	
	setAnimTrackTime(self.expCap.animCharSet, 0, trackTime);
	setAnimTrackSpeedScale(self.expCap.animCharSet, 0, speedScale);
	enableAnimTrack(self.expCap.animCharSet, 0);
	self.expCap.animEnabled = true;
		
	for a=1, table.getn(self.expCap.fadeInObjects) do
		setVisibility(self.expCap.fadeInObjects[a], state);
	end;
	
	for a=1, table.getn(self.expCap.fadeOutObjects) do
		setVisibility(self.expCap.fadeOutObjects[a], not state);
	end;

	if not noEventSend then
		ExpandCapacityEvent.sendEvent(self, state, noEventSend);
	end;
end;