TransportEvent = {};
TransportEvent_mt = Class(TransportEvent, Event);

InitEventClass(TransportEvent, "TransportEvent");

function TransportEvent:emptyNew()
    local self = Event:new(TransportEvent_mt);
    self.className="TransportEvent";
    return self;
end;

function TransportEvent:new(object, transportMode)
    local self = TransportEvent:emptyNew()
    self.object = object;
	self.transportMode = transportMode;
    return self;
end;

function TransportEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.transportMode = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function TransportEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.transportMode);
end;

function TransportEvent:run(connection)
	self.object:setTransportMode(self.transportMode);
    if not connection:getIsServer() then
        g_server:broadcastEvent(TransportEvent:new(self.object, self.transportMode), nil, connection, self.object);
    end;	
end;

function TransportEvent.sendEvent(vehicle, transportMode, noEventSend)
	if transportMode ~= vehicle.transportMode then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(TransportEvent:new(vehicle, transportMode), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(TransportEvent:new(vehicle, transportMode));
			end;
		end;
	end;
end;

