Claas3200Event = {};
Claas3200Event_mt = Class(Claas3200Event, Event);

InitEventClass(Claas3200Event, "Claas3200Event");

function Claas3200Event:emptyNew()
    local self = Event:new(Claas3200Event_mt);
    self.className="Claas3200Event";
    return self;
end;

function Claas3200Event:new(vehicle, mode, state)
    local self = Claas3200Event:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
	self.state = state;
    return self;
end;

function Claas3200Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function Claas3200Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, self.mode);
	streamWriteBool(streamId, self.state);
end;

function Claas3200Event:run(connection)
	self.vehicle:MPCode(self.mode, self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(Claas3200Event:new(self.vehicle, self.mode, self.state), nil, connection, self.vehicle);
    end;
end;

function Claas3200Event.sendEvent(vehicle, mode, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(Claas3200Event:new(vehicle, mode, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(Claas3200Event:new(vehicle, mode, state));
		end;
	end;
end;