 Claas3200 = {};

function  Claas3200.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function  Claas3200:load(xmlFile)

	self.moveBalesOut =  Claas3200.moveBalesOut;
	self.setJointLimit = SpecializationUtil.callSpecializationsFunction("setJointLimit");
	self.setTransportMode = SpecializationUtil.callSpecializationsFunction("setTransportMode");
	self.allowPickingUp =  Claas3200.allowPickingUp;
	self.setBaleTime = Baler.setBaleTime;
	self.MPCode= SpecializationUtil.callSpecializationsFunction("MPCode");
	
	self.pickupRotLimit = {0};

	local path = Utils.getFilename("Textures/Balecounter_hud.dds", self.baseDirectory);
    self.balecounterHud = Overlay:new("counterOverlay", path, 0.8143, 0.7900, 0.176, 0.100);
	
	self.baleCount = 0;
	self.lastBaleCount = 0;
	self.moveBalesOutside = false;
	self.transportMode = true;
	self.printWait = false;
	self.allowPick = false;

	-- Particles
	
	self.wheatParticleSystems = {};
	local i=0;
	while true do
		local key = string.format("vehicle.PickupParticleSystems.Straw(%d)", i);
		local node = getXMLString(xmlFile, key.. "#node");
		if node == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, node);
		if node ~= nil then
			local psFile = getXMLString(xmlFile, key.. "#file");
			local wheatParticleSystem = {};
			wheatParticleSystem.particleSystem = {};
			StaticParticleSystem.loadParticleSystem(xmlFile, wheatParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			table.insert(self.wheatParticleSystems, wheatParticleSystem);
		end;
		i = i+1;
	end;
	
	self.grassParticleSystems = {};
	local i=0;
	while true do
		local key = string.format("vehicle.PickupParticleSystems.Grass(%d)", i);
		local node = getXMLString(xmlFile, key.. "#node");
		if node == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, node);
		if node ~= nil then
			local psFile = getXMLString(xmlFile, key.. "#file");
			local grassParticleSystem = {};
			grassParticleSystem.particleSystem = {};
			StaticParticleSystem.loadParticleSystem(xmlFile, grassParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			table.insert(self.grassParticleSystems, grassParticleSystem);
		end;
		i = i+1;
	end;
	
	self.dryGrassParticleSystems = {};
	local i=0;
	while true do
		local key = string.format("vehicle.PickupParticleSystems.dryGrass(%d)", i);
		local node = getXMLString(xmlFile, key.. "#node");
		if node == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, node);
		if node ~= nil then
			local psFile = getXMLString(xmlFile, key.. "#file");
			local dryGrassParticleSystem = {};
			dryGrassParticleSystem.particleSystem = {};
			StaticParticleSystem.loadParticleSystem(xmlFile, dryGrassParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
			table.insert(self.dryGrassParticleSystems, dryGrassParticleSystem);
		end;
		i = i+1;
	end;
	
end;

function  Claas3200:delete()
	if self.balecounterHud ~= nil then
		self.balecounterHud:delete();
	end;
	
	for k, wheatParticleSystem in pairs(self.wheatParticleSystems) do
		Utils.setEmittingState(wheatParticleSystem.particleSystem, false);
	end;
	for k, grassParticleSystem in pairs(self.grassParticleSystems) do
		Utils.setEmittingState(grassParticleSystem.particleSystem, false);
	end;
	for k, dryGrassParticleSystem in pairs(self.dryGrassParticleSystems) do
		Utils.setEmittingState(dryGrassParticleSystem.particleSystem, false);
	end;
end;

function  Claas3200:readStream(streamId, connection)
	self.baleCount = streamReadInt32(streamId);
end;

function  Claas3200:writeStream(streamId, connection)
	streamWriteInt32(streamId, self.baleCount);
end;

function  Claas3200:mouseEvent(posX, posY, isDown, isUp, button)
end;

function  Claas3200:keyEvent(unicode, sym, modifier, isDown)
end;

function  Claas3200:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'baleCount="'.. tostring(self.baleCount) ..'"';
	return attributes, nil;
end;

function  Claas3200:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.baleCount = Utils.getNoNil(getXMLInt(xmlFile, key.."#baleCount"), 0);
		if self.animationParts[2].isLoading and self.animationParts[2].inputTime > self.animationParts[2].offSet then
			self:setTransportMode(false);
		end;
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function  Claas3200:update(dt)

	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding. Claas_3200_PICKUP) then
			if self.animationParts[1].clipEndTime then
				self:setAnimationTime(1, self.animationParts[1].offSet);
			elseif self.animationParts[1].clipStartTime then
				self:setAnimationTime(1, self.animationParts[1].animDuration);
			end;
		end;
		if InputBinding.hasEvent(InputBinding. Claas_3200_BALE) then
			self:setTransportMode(not self.transportMode);
		end;
		if InputBinding.hasEvent(InputBinding. Claas_3200_RESET) then
			self.baleCount = 0;
		end;
	end;
	
	if not self.animationParts[2].clipEndTime then
		self.isTurnedOn = false;
	end;
	
	if self.setAnimationTime ~= nil then
		if self.isTurnedOn then
			self:setAnimationTime(3, 1);
		else
			self:setAnimationTime(3, 0);
		end;
	end;
end;

function  Claas3200:setTransportMode(transportMode)
	TransportEvent.sendEvent(self, transportMode, noEventSend);
	self.transportMode = transportMode;
	if self.transportMode then
		self.isTurnedOn = false;
		self:setAnimationTime(1, self.animationParts[1].offSet);
	end;
end;

function  Claas3200:updateTick(dt)

	if table.getn(self.bales) > self.lastBaleCount then
		self.baleCount = self.baleCount + 1;
		self.lastBaleCount = self.lastBaleCount + 1;
		self.balerKnotCleaningTime = (self.time-50);
	elseif table.getn(self.bales) < self.lastBaleCount then
		self.lastBaleCount = self.lastBaleCount - 1;
	end;
	
	if self.transportMode then
		if self.moveBalesOutside then
			self.printWait = false;
			self:setAnimationTime(2, self.animationParts[2].offSet);
		else
			self:moveBalesOut(dt, self);
			self.printWait = true;
		end;
	else
		self.printWait = false;
		self:setAnimationTime(2, self.animationParts[2].animDuration);
		self.moveBalesOutside = false;
	end;
	if self.previousLevel ~= self.fillLevel then
			Utils.setEmittingState(self.dustParticles, true);
			self.previousLevel = self.fillLevel;
			self:MPCode(4, true);
		else
			Utils.setEmittingState(self.dustParticles, false);
			self:MPCode(4, false);
		end;
	
	local newRot = Utils.getMovedLimitedValues(self.pickupRotLimit, {8}, {0}, 1, 2000, dt, not self.animationParts[1].clipEndTime);
	local jointDesc = self.componentJoints[2];
	setJointRotationLimit(jointDesc.jointIndex, 0, true, Utils.degToRad(-newRot[1]), Utils.degToRad(newRot[1]));
	self.pickupRotLimit = newRot;
	
	if self.isTurnedOn then
		if self.movingDirection == -1 then
			self.backTimer = self.backTimer+dt;
			if self.backTimer > 50 then
				self.allowPick = false;
			end;
		else
			self.allowPick = true;
			self.backTimer = 0;
		end;
	end;
end;

function  Claas3200:allowPickingUp()
	local allow = false;
	if self.animationParts[1].currentPosition > 300 then
		allow = true;
	end;
	if not self.allowPick then
		allow = false;
	end;
	return allow;
end;

function  Claas3200:moveBalesOut(dt, self)
	local done = true;
	local balesToDrive = 0;
	local drive = true;
	for k, bale in pairs(self.bales) do
		if bale.time > 0.4384 then
			local sendTime = math.min(1, bale.time+dt/10000);
			self.setBaleTime(self, k, sendTime, true);
			done = false;
			balesToDrive = balesToDrive+1;
		end;
	end;
	if balesToDrive == 0 and not self.moveBalesOutside then
		drive = false;
	end;
	if self.attacherVehicle ~= nil then
		local kmh = self.attacherVehicle.lastSpeed*self.attacherVehicle.speedDisplayScale*3600;
		if drive then
			if kmh < 3 then
				self.attacherVehicle.motor:setSpeedLevel(1, true);
			else
				self.attacherVehicle.motor:setSpeedLevel(0, false);
			end;
		elseif not drive and table.getn(self.bales) > 0 then
			self.attacherVehicle.motor:setSpeedLevel(0, false);
		end;
	end;
	self.moveBalesOutside = done;
	return;
end;
	
function  Claas3200:draw()
	if self.animationParts[1].clipStartTime then
		g_currentMission:addHelpButtonText(g_i18n:getText("Claas_3200_1"), InputBinding. Claas_3200_PICKUP);
	elseif self.animationParts[1].clipEndTime then
		g_currentMission:addHelpButtonText(g_i18n:getText("Claas_3200_2"), InputBinding. Claas_3200_PICKUP);
	end;
	if self.animationParts[2].clipStartTime then
		g_currentMission:addHelpButtonText(g_i18n:getText("Claas_3200_3"), InputBinding. Claas_3200_BALE);
		g_currentMission:addExtraPrintText(g_i18n:getText("Claas_3200_5"));
	elseif self.animationParts[2].clipEndTime then
		g_currentMission:addHelpButtonText(g_i18n:getText("Claas_3200_4"), InputBinding. Claas_3200_BALE);
		g_currentMission:addHelpButtonText(g_i18n:getText("Claas_3200_6"), InputBinding. Claas_3200_RESET);
		self.balecounterHud:render();
		setTextAlignment(RenderText.ALIGN_RIGHT);
		setTextBold(true);	
		setTextColor(1, 1, 1, 1);
		renderText(0.9653, 0.8265, 0.032, tostring(self.baleCount));
	end;
	if self.printWait then
		g_currentMission:addWarning(g_i18n:getText("BaleWarning"), 0.040, 0.035);
	end;
	if self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
		local fillType = self.currentFillType;
		if fillType == Fillable.FILLTYPE_GRASS then
			fillType = Fillable.FILLTYPE_DRYGRASS_WINDROW;
		end;
    end;
end;

function Claas3200:MPCode(mode, state, noEventSend)
	Claas3200Event.sendEvent(self, mode, state, noEventSend);
	
--______________________________________________________________________________
    if mode == 4 then
--_________________________________ PARTICLES __________________________________
	if state then
		if FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_WHEAT or FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_BARLEY
		or FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_OAT or FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_RYE
		or FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_TRITICALE then
			for k, wheatParticleSystem in pairs(self.wheatParticleSystems) do
				Utils.setEmittingState(wheatParticleSystem.particleSystem, true);
			end;
		elseif FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_GRASS then
			for k, grassParticleSystem in pairs(self.grassParticleSystems) do
				Utils.setEmittingState(grassParticleSystem.particleSystem, true);
			end;
		elseif FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_DRYGRASS or FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_GREENWHEAT then
			for k, dryGrassParticleSystem in pairs(self.dryGrassParticleSystems) do
				Utils.setEmittingState(dryGrassParticleSystem.particleSystem, true);
			end;
		end;
	else
		for k, wheatParticleSystem in pairs(self.wheatParticleSystems) do
			Utils.setEmittingState(wheatParticleSystem.particleSystem, false);
		end;
		for k, grassParticleSystem in pairs(self.grassParticleSystems) do
			Utils.setEmittingState(grassParticleSystem.particleSystem, false);
		end;
		for k, dryGrassParticleSystem in pairs(self.dryGrassParticleSystems) do
			Utils.setEmittingState(dryGrassParticleSystem.particleSystem, false);
		end;
	end;
	
end;	

end;

--_______________________________________________________________________________________
function  Claas3200:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
end;

function  Claas3200:onDetach()
end;