-- by RivalBomb
-- !!!!! NO EDITING WITHOUT MY PERMISSION !!!!!
-- strawAndPipeAnimations.lua
--> chopper, straw and pipe animations for combines
-- Version History
 		-- Version 0.1 @ 03.06.2014 by RivalBomb: initial version only with chopper
 		-- Version 0.2 @ 09.06.2014 by RivalBomb: added multifruit compatibility with new xml-entries (Thanks to Michii and Bluebaby210!)
		-- Version 0.3 FIRST (BETA) RELEASE IN CLAAS LEXION 540 @ 22.06.2014 by RivalBomb: straw Animation finished

strawAndPipeAnimations = {};

function strawAndPipeAnimations.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Combine, specializations);
end;

function strawAndPipeAnimations:load(xmlFile)
		
	self.scale = {};
	self.scale.X = 0;
	self.scale.Z = 0;
	self.scale.Z2 = 1;
	self.scalePipe = {};
	self.scalePipe.X = 0;
	self.scalePipe.Z = 0;
	self.scalePipe.Z2 = 1;
	self.scalePipe.Y2 = 1;
	self.scalePipe.X2 = 1;
	self.scaleStraw = {};
	self.scaleStraw.X = 0;
	self.scaleStraw.Z = 0;
	self.scaleStraw.Z2 = 1;
	self.speed = 0.1;
	self.stopAnim = false;
	self.stopPipeAnim = false;
	
	
		-- Chopper Animation 
	self.chopper = {};
	self.chopperMesh = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.strawAndPipeAnimations.chopper.fruit(%d)", i);
		local chopperMesh = {};
		chopperMesh.nodes = {};
		chopperMesh.nodes2 = {};
		local fruitType = getXMLString(xmlFile, key.."#type");
		if fruitType == nil then
			break;
		end;
		if fruitType ~= nil then
			local nodeI = 0;
			while true do
				local Nodekey = string.format("vehicle.strawAndPipeAnimations.chopper.fruit(%d)", nodeI);
				local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, Nodekey.."#maxScales"));
				local node = Utils.indexToObject(self.components, getXMLString(xmlFile, Nodekey.."#index"));
				local node2 = Utils.indexToObject(self.components, getXMLString(xmlFile, Nodekey.."#index2"));
				if node == nil then
					break;
				end;
				if node2 == nil then
					break;
				end;
				if node ~= nil and node2 ~= nil then
					table.insert(chopperMesh.nodes, node);
					table.insert(chopperMesh.nodes2, node2);
				end;
				self.scaleX = x;
				self.scaleY = y;
				self.scaleZ = z;
				nodeI = nodeI +1;
			end;
			if table.getn(chopperMesh.nodes) > 0 then
				if self.defaultchopperMesh == nil then
					self.defaultchopperMesh = chopperMesh;
				end;
				self.chopperMesh[fruitType] = chopperMesh;
			end;
		end;
		i = i +1;
	end;
	
	-- straw Animation
	self.strawMesh = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.strawAndPipeAnimations.straw.fruit(%d)", i);
		local strawMesh = {};
		strawMesh.nodes = {};
		strawMesh.nodes2 = {};
		local fruitType = getXMLString(xmlFile, key.."#type");
		if fruitType == nil then
			break;
		end;
		if fruitType ~= nil then
			local nodeI = 0;
			while true do
				local NodekeyStraw = string.format("vehicle.strawAndPipeAnimations.straw.fruit(%d)", nodeI);
				local sx,sy,sz = Utils.getVectorFromString(getXMLString(xmlFile, NodekeyStraw.."#maxScales"));
				local node = Utils.indexToObject(self.components, getXMLString(xmlFile, NodekeyStraw.."#index"));
				local node2 = Utils.indexToObject(self.components, getXMLString(xmlFile, NodekeyStraw.."#index2"));
				if node == nil then
					break;
				end;
				if node2 == nil then
					break;
				end;
				if node ~= nil and node2 ~= nil then
					table.insert(strawMesh.nodes, node);
					table.insert(strawMesh.nodes2, node2);
				end;
				self.scaleStrawX = sx;
				self.scaleStrawY = sy;
				self.scaleStrawZ = sz;
				nodeI = nodeI +1;
			end;
			if table.getn(strawMesh.nodes) > 0 then
				if self.defaultstrawMesh == nil then
					self.defaultstrawMesh = strawMesh;
				end;
				self.strawMesh[fruitType] = strawMesh;
			end;
		end;
		i = i +1;
	end;
	
	self.pipeMesh = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.strawAndPipeAnimations.pipe.fruit(%d)", i);
		local pipeMesh = {};
		pipeMesh.nodes = {};
		pipeMesh.nodes2 = {};
		local fruitType = getXMLString(xmlFile, key.."#type");
		if fruitType == nil then
			break;
		end;
		if fruitType ~= nil then
			local nodeI = 0;
			while true do
				local NodekeyPipe = string.format("vehicle.strawAndPipeAnimations.pipe.fruit(%d)", nodeI);
				local px,py,pz = Utils.getVectorFromString(getXMLString(xmlFile, NodekeyPipe.."#maxScales"));
				local node = Utils.indexToObject(self.components, getXMLString(xmlFile, NodekeyPipe.."#index"));
				local node2 = Utils.indexToObject(self.components, getXMLString(xmlFile, NodekeyPipe.."#index2"));
				if node == nil then
					break;
				end;
				if node2 == nil then
					break;
				end;
				if node ~= nil and node2 ~= nil then
					table.insert(pipeMesh.nodes, node);
					table.insert(pipeMesh.nodes2, node2);
				end;
				self.scalePipeX = px;
				self.scalePipeY = py;
				self.scalePipeZ = pz;
				nodeI = nodeI +1;
			end;
			if table.getn(pipeMesh.nodes) > 0 then
				if self.defaultpipeMesh == nil then
					self.defaultpipeMesh = pipeMesh;
				end;
				self.pipeMesh[fruitType] = pipeMesh;
			end;
		end;
		i = i +1;
	end;
	
end;
function strawAndPipeAnimations:delete()
end;
function strawAndPipeAnimations:mouseEvent(posX, posY, isDown, isUp, button)
end;
function strawAndPipeAnimations:keyEvent(unicode, sym, modifier, isDown)
end;
function strawAndPipeAnimations:update(dt)

	-- Chopper
	if self.chopperPSenabled then
		self.scale.X = math.min(self.scale.X + self.speed, self.scaleX);
		self.scale.Z = math.min(self.scale.Z + self.speed*1.8, self.scaleZ);
	else
		if self.scale.X == self.scaleX or self.scale.Z == self.scaleZ then
			self.stopAnim = true;
		end;
		if self.stopAnim then
			self.scale.Z2 = math.max(self.scale.Z2 - self.speed, 0);
			if self.scale.Z2 == 0 then
				self.stopAnim = false;
			end;
		end;
	end;
	if not self.chopperPSenabled and not self.stopAnim then
		self.scale.X = 0;
		self.scale.Z = 0;
		self.scale.Z2 = 1;
	end;
	
	-- Straw
	if self.strawPSenabled then
		self.scaleStraw.X = math.min(self.scaleStraw.X + self.speed, self.scaleX);
		self.scaleStraw.Z = math.min(self.scaleStraw.Z + self.speed*1.8, self.scaleZ);
	else
		if self.scaleStraw.X == self.scaleStrawX or self.scaleStraw.Z == self.scaleStrawZ then
			self.stopStrawAnim = true;
		end;
		if self.stopAnim then
			self.scaleStraw.Z2 = math.max(self.scaleStraw.Z2 - self.speed, 0);
			if self.scaleStraw.Z2 == 0 then
				self.stopStrawAnim = false;
			end;
		end;
	end;
	if not self.strawPSenabled and not self.stopStrawAnim then
		self.scaleStraw.X = 0;
		self.scaleStraw.Z = 0;
		self.scaleStraw.Z2 = 1;
	end;
		
	-- Pipe
	if self.pipeIsUnloading and self.grainTankFillLevel > 100 then
		self.scalePipe.X = math.min(self.scalePipe.X + self.speed, self.scalePipeX);
		self.scalePipe.Z = math.min(self.scalePipe.Z + self.speed*1.8, self.scalePipeZ);
	end;
	if self.scalePipe.X == self.scalePipeX and self.scalePipe.Z == self.scalePipeZ and self.grainTankFillLevel < 100 then
		self.stopPipeAnim = true;
	end;
	if self.stopPipeAnim then
		self.scalePipe.X2 = math.max(self.scalePipe.X2 - self.speed, 0);
		self.scalePipe.Y2 = math.max(self.scalePipe.Y2 - self.speed, 0);
		self.scalePipe.Z2 = math.max(self.scalePipe.Z2 - self.speed, 0.1);
		if self.scalePipe.Z2 == 0.1 and self.scalePipe.X2 == 0 and self.scalePipe.Y2 == 0 then
			self.stopPipeAnim = false;
		end;
	end;
	if not self.pipeIsUnloading and not self.stopPipeAnim then
		self.scalePipe.X = 0;
		self.scalePipe.Z = 0;
		self.scalePipe.X2 = 1;
		self.scalePipe.Y2 = 1;
		self.scalePipe.Z2 = 1;
	end;

	--		Chopper		--

	local fruitType = self.currentGrainTankFruitType;
	local lastFruitType = self.lastValidGrainTankFruitType;
	local chopperMesh = self.chopperMesh[t];
	if fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
		local fruitTypeName = FruitUtil.fruitIndexToDesc[fruitType].name;
		if chopperMesh == nil then
			chopperMesh = self.defaultchopperMesh;
		end;
	else
		local lastFruitType = self.lastValidGrainTankFruitType;
		local chopperMesh = self.chopperMesh[lastFruitType];
	end;
	if self.currentGrainTankFruitType == FruitUtil.FRUITTYPE_UNKNOWN or self.currentGrainTankFruitType == nil then
		lastFruitType = self.lastValidGrainTankFruitType;
	else
		lastFruitType = self.currentGrainTankFruitType;
	end;
	if self.grainTankFillLevel > 0 then
		for node, node2 in ipairs(chopperMesh.nodes) do
			setScale(chopperMesh.nodes[lastFruitType], self.scale.X, 1, self.scale.Z);
			setScale(chopperMesh.nodes2[lastFruitType], 1, 1, self.scale.Z2);
		end;
	end;

	--		Straw		--

	local fruitType = self.currentGrainTankFruitType;
	local lastFruitType = self.lastValidGrainTankFruitType;
	local strawMesh = self.strawMesh[t];
	if fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
		local fruitTypeName = FruitUtil.fruitIndexToDesc[fruitType].name;
		if strawMesh == nil then
			strawMesh = self.defaultstrawMesh;
		end;
	else
		local lastFruitType = self.lastValidGrainTankFruitType;
		local strawMesh = self.strawMesh[lastFruitType];
	end;
	if self.currentGrainTankFruitType == FruitUtil.FRUITTYPE_UNKNOWN or self.currentGrainTankFruitType == nil then
		lastFruitType = self.lastValidGrainTankFruitType;
	else
		lastFruitType = self.currentGrainTankFruitType;
	end;
	if self.grainTankFillLevel > 0 then
		for node, node2 in ipairs(strawMesh.nodes) do
			setScale(strawMesh.nodes[lastFruitType], self.scaleStraw.X, 1, self.scaleStraw.Z);
			setScale(strawMesh.nodes2[lastFruitType], 1, 1, self.scaleStraw.Z2);
		end;
	end;

	--		Pipe		--

	local fruitType = self.currentGrainTankFruitType;
	local lastFruitType = self.lastValidGrainTankFruitType;
	local pipeMesh = self.pipeMesh[t]
	if fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
		if pipeMesh == nil then
			pipeMesh = self.defaultpipeMesh;
		end;
	else
		local lastFruitType = self.lastValidGrainTankFruitType;
		pipeMesh = self.pipeMesh[lastFruitType];
	end;
	if self.currentGrainTankFruitType == FruitUtil.FRUITTYPE_UNKNOWN or self.currentGrainTankFruitType == nil then
		lastFruitType = self.lastValidGrainTankFruitType;
	else
		lastFruitType = self.currentGrainTankFruitType;
	end;
	if self.grainTankFillLevel > 0 then
		for node, node2 in ipairs(pipeMesh.nodes) do
			setScale(pipeMesh.nodes[lastFruitType], self.scalePipe.X, 1, self.scalePipe.Z);
			setScale(pipeMesh.nodes2[lastFruitType], self.scalePipe.X2, self.scalePipe.Y2, self.scalePipe.Z2);
		end;
	end;

		--  DEBUGMODE (not up to date, only chopper...) --
	local debugMode = false; 
	if debugMode and self.isEntered then
		if self.stopAnim then
			renderText(0.2, 0.85, 0.04, "STOPANIMATION ACTIVE!");
		end;
		if self.chopperPSenabled then
			renderText(0.4, 0.75, 0.025, "Scale X: " .. self.scale.X .. "; Scale Z: " .. self.scale.Z .. "; Scale 2 Z: " .. self.scale.Z2);
			local fruitType = self.currentGrainTankFruitType;
			local fruitTypeName = FruitUtil.fruitIndexToDesc[fruitType].name
			renderText(0.4, 0.7, 0.025, "Fruchttyp: " .. tostring(fruitTypeName));
		end;
	end;
end;
function strawAndPipeAnimations:updateTick(dt)
end;
function strawAndPipeAnimations:draw()	
end;
