--
-- Vario 660
-- Specialization for Vario 660
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		03/09/11
-- @history:	v1.0 - Initial version
-- 10/03/13		Michi77 - small changes for Vario 660
--
-- free for noncommerical-usage
--

Vario660 = {};

function Vario660.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations) and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function Vario660:load(xmlFile)
	
	self.foldCameras = SpecializationUtil.callSpecializationsFunction("foldCameras");
	
	self.Vario660 = {};
	self.Vario660.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vario#index"));
	self.Vario660.fixpoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vario#fixpoint"));
	self.Vario660.maxTrans = {Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.vario#maxTrans"))};
	self.Vario660.minTrans = {getTranslation(self.Vario660.node)};
	self.Vario660.offset = 10;
	self.Vario660.speed = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.vario#speed"), 11);
	self.Vario660.speedScaleTime = 5000;
	self.Vario660.speedScaleBackup = self.reelSpeedScale;
	self.Vario660.rollSpeedBackup = self.rollNodes[1].speed;

	self.reelSpeedScale = 0;
	for _, rollNode in pairs(self.rollNodes) do
		rollNode.speed = 0;
	end;
	
	self.blades = {};
	local vertical = {};
	vertical.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.blades#vertical"));
	vertical.max = getXMLFloat(xmlFile, "vehicle.blades#vertMax");
	vertical.speed = getXMLFloat(xmlFile, "vehicle.blades#vertSpeed") * 1000;	
	vertical.dir = 1;
	local horizontal = {};
	horizontal.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.blades#horizontal"));
	horizontal.max = getXMLFloat(xmlFile, "vehicle.blades#horizMax");
	horizontal.speed = getXMLFloat(xmlFile, "vehicle.blades#horizSpeed") * 1000;
	horizontal.dir = 1;
	
	self.blades.vertical = vertical;
	self.blades.horizontal = horizontal;
	
	self.specialJoint = {};
	self.specialJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.specialJoint#node"));
	self.specialJoint.backup = self.attacherJoint.node;
	
	self.Vario660.isExtended = false;
	self.Vario660.lastFruit = FRUITTYPE_UNKNOWN;
end;

function Vario660:postLoad(xmlFile)
	self.mouseControlsIconsBackup = self.mouseControlsIcons;
	self.movingToolsBackup = self.movingTools;
	self.mouseControlsIcons = {};
	self.movingTools = {};
end;

function Vario660:delete()
end;

function Vario660:readStream(streamId, connection)
end;

function Vario660:writeStream(streamId, connection)
end;

function Vario660:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Vario660:keyEvent(unicode, sym, modifier, isDown)
end;

function Vario660:update(dt)

	Utils.setEmittingState(self.threshingParticleSystems, (self.reelStarted and self.lastCutterAreaBiggerZero));
	
	if self:getIsActive() and self.reelStarted then
		if self.attacherVehicle ~= nil and self.attacherVehicle.allowsThreshing ~= nil then
			if not self.attacherVehicle.allowsThreshing then
				self.lastAreaBiggerZero = false;
				if self.lastAreaBiggerZero ~= self.lastAreaBiggerZeroSent then
					self:raiseDirtyFlags(self.cutterGroundFlag);
					self.lastAreaBiggerZeroSent = self.lastAreaBiggerZero;
				end;
			end;
		end;
	
		local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.Vario660.speed, 1.3));
	
		local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.Vario660.speedScaleBackup * percent}, {0}, 1, self.Vario660.speedScaleTime, dt, false);
		self.reelSpeedScale = speedScale[1];
		for _, rollNode in pairs(self.rollNodes) do
			local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.Vario660.rollSpeedBackup * percent}, {0}, 1, self.Vario660.speedScaleTime, dt, false);
			rollNode.speed = rollSpeed[1];
		end;
		
		if self.blades.vertical.node ~= nil then
			local _,y,_ = getTranslation(self.blades.vertical.node);
			if y < 0.005 or y > (self.blades.vertical.max - 0.005) then
				self.blades.vertical.dir = math.abs(self.blades.vertical.dir - 1);
			end;
			local newTrans = Utils.getMovedLimitedValues({y}, {self.blades.vertical.max}, {0}, 1, self.blades.vertical.speed / percent, dt, self.blades.vertical.dir ~= 0);
			setTranslation(self.blades.vertical.node, 0, unpack(newTrans), 0);
		end;
		if self.blades.horizontal.node ~= nil then
			local x,_,_ = getTranslation(self.blades.horizontal.node);
			if x < 0.005 or x > (self.blades.horizontal.max - 0.005) then
				self.blades.horizontal.dir = math.abs(self.blades.horizontal.dir - 1);
			end;
			local newTrans = Utils.getMovedLimitedValues({x}, {self.blades.horizontal.max}, {0}, 1, self.blades.horizontal.speed / percent, dt, self.blades.horizontal.dir ~= 0);
			setTranslation(self.blades.horizontal.node, unpack(newTrans), 0, 0);
		end;
	else
		if self.reelSpeedScale ~= 0 or self.rollNodes[1].speed ~= 0 then
			local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.Vario660.speed, 1.5));
			
			local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.Vario660.speedScaleBackup * percent}, {0}, 1, self.Vario660.speedScaleTime*1.5, dt, true);
			self.reelSpeedScale = speedScale[1];
			rotate(self.reelNode, -dt*self.reelSpeed*self.reelSpeedScale, 0, 0);
			for _, rollNode in pairs(self.rollNodes) do
				local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.Vario660.rollSpeedBackup * percent}, {0}, 1, self.Vario660.speedScaleTime*1.5, dt, true);
				rollNode.speed = rollSpeed[1];
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;
			
			local atx, aty, atz = getRotation(self.reelNode);
			for i=1, self.spikesCount do
				local spike = getChildAt(self.spikesRootNode, i-1);
				setRotation(spike, -atx, aty, atz);
			end;
		end;
	end;
end;

function Vario660:updateTick(dt)
end;

function Vario660:draw()	
end;

function Vario660:onSelect()
	self.mouseControlsIcons = self.mouseControlsIconsBackup;
	self.movingTools = self.movingToolsBackup;
end;

function Vario660:onDeselect()
	self.mouseControlsIcons = {};
	self.movingTools = {};
end;

function Vario660:onAttach(attacherVehicle)
end;

function Vario660:onDetach()	
	Cutter.updateExtraObjects(self);
	self:foldCameras(false);
end;

function Vario660:foldCameras(reverse, speed)
	if speed == nil then
		speed = 1;
	end;
	local direction = -1;
	if reverse then
		direction = 1;
	end;

	local animTimeLadder = nil;
	if self:getIsAnimationPlaying("openCams") then			
		animTimeLadder = self:getAnimationTime("openCams");
	end;
	self:playAnimation("openCams", direction*speed, animTimeLadder, true);
end;

local oldUpdateExtraObjects = Cutter.updateExtraObjects;
Cutter.updateExtraObjects = function(self)
	oldUpdateExtraObjects(self);
	
	if self.Vario660 ~= nil and self.Vario660.lastFruit ~= fruitType then
		if fruitType == FruitUtil.FRUITTYPE_RAPE then
			if not self.Vario660.isExtended then
				setTranslation(self.Vario660.node, unpack(self.Vario660.maxTrans));
				self.Vario660.isExtended = true;
			end;		
		else
			if self.Vario660.isExtended then
				setTranslation(self.Vario660.node, unpack(self.Vario660.minTrans));
				self.Vario660.isExtended = false;
			end;		
		end;
		self.Vario660.lastFruit = fruitType;
	end;
end;
