PipeLight = {};
PipeLight_mt = Class(PipeLight, Event);

InitEventClass(PipeLight, "PipeLight");

function PipeLight:emptyNew()
    local self = Event:new(PipeLight_mt);
    self.className="PipeLight";
    return self;
end;

function PipeLight:new(vehicle, mode)
    local self = PipeLight:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
    return self;
end;

function PipeLight:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function PipeLight:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.mode);
end;

function PipeLight:run(connection)
	self.vehicle:BLightBB9090(self.mode, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(PipeLight:new(self.vehicle, self.mode), nil, connection, self.vehicle);
    end;
end;

function PipeLight.sendEvent(vehicle, mode, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(PipeLight:new(vehicle, mode), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(PipeLight:new(vehicle, mode));
		end;
	end;
end;