--
-- Lexion420
-- Specialization for Lexion420
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		14/12/11
-- @history:	v1.0 - Initial version
--
-- free for noncommerical-usage
--

Lexion420 = {};

function Lexion420.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Combine, specializations) and SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(ChopperSwitcher, specializations);
end;

function Lexion420:load(xmlFile)
self.rotor = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotor#index"));
self.rotorGrainTank = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotorGrainTank#index"));
self.fan = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fan#index"));
self.chopperRotorLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chopperRotorLeft#index"));
self.chopperRotorRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chopperRotorRight#index"));
self.PipeLight= SpecializationUtil.callSpecializationsFunction("PipeLight");
self.pipeLight = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.pipeLight#index"));
self.pipeCone = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.pipeCone#index"));

self.pipeLightStatus = false;
	

end;

function Lexion420:delete()
end;

function Lexion420:readStream(streamId, connection)
end;

function Lexion420:writeStream(streamId, connection)
end;

function Lexion420:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Lexion420:keyEvent(unicode, sym, modifier, isDown)
end;

function Lexion420:update(dt)
    if self:getIsActive() then
	    if InputBinding.hasEvent(InputBinding.PipeLIGHT) then
			self:PipeLight(not self.pipeLightStatus);
		end;
		
        if self.isMotorStarted and self.fan ~= nil then
		  rotate(self.fan,dt*0.02,0,0); 
        end;
        if self.isThreshing and self.rotor ~= nil then
          rotate(self.rotor, dt*0.007, 0, 0); 
        end;
        if self.isThreshing and self.rotorGrainTank ~= nil then
		  rotate(self.rotorGrainTank,0,dt*0.02,0);
        end;
		if self.isThreshing and self.chopperState == ChopperSwitcher.CHOPPER and self.chopperRotorLeft ~= nil then
		  rotate(self.chopperRotorLeft,0,dt*0.01,0);
		end;  
		if self.isThreshing and self.chopperState == ChopperSwitcher.CHOPPER and self.chopperRotorRight ~= nil then
		  rotate(self.chopperRotorRight,0,dt*-0.01,0);
		end;
    end;

	
end;

function Lexion420:updateTick(dt)
	if self:getIsActive() then
		
		for _, part in pairs(self.movingParts) do
			Cylindered.updateMovingPart(self,  part);	
		end;
  

	end;	
end;

function Lexion420:PipeLight(mode, noEventSend)
	PipeLight.sendEvent(self, mode, noEventSend);
	
	if self:getIsActiveForSound() and mode then
		setVisibility(self.pipeLight, true);
		setVisibility(self.pipeCone, false);
		self.pipeLightStatus = true;
	elseif not self:getIsActiveForSound() and mode then
		setVisibility(self.pipeLight, false);
		setVisibility(self.pipeCone, true);
		self.pipeLightStatus = false;
	else
		setVisibility(self.pipeLight, false);
		setVisibility(self.pipeCone, false);
		self.pipeLightStatus = false;
	end;

end;

function Lexion420:draw()
    if self.pipeLightStatus then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PIPELIGHT_OFF"), self.typeDesc), InputBinding.PipeLIGHT);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PIPELIGHT_ON"), self.typeDesc), InputBinding.PipeLIGHT);
	end;
end;

function Lexion420:onLeave()
        local l = Lexion420;
        if self.deactivateOnLeave then
          Lexion420.onDeactivate(self);
		else
		  return l ;
	    end;  
end;

function Lexion420:onEnter()
end;


function Lexion420:onDeactivate()
end;


  



