-- AbladeSound.lua
--
-- Autor: ls-for-ever
-- Datum: 27.08.2012
-- 
-- Copyright (C) ls-for-ever
-- 
--
-- Spielt einen Sound ab wenn man abldt.

Abladesound = {};

function Abladesound.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Abladesound:load(xmlFile)
    AbladesoundFile = Utils.getFilename("unload.wav", self.baseDirectory);
    self.AbladesoundId = createSample("Abladesound");
    loadSample(self.AbladesoundId, AbladesoundFile, false);
    self.AbladesoundPlaying = false;
end;

function Abladesound:delete()
    delete(self.AbladesoundId);
end;

function Abladesound:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Abladesound:keyEvent(unicode, sym, modifier, isDown)
end;

function Abladesound:update(dt)
	if self.isEntered and self.pipeParticleActivated then
        if not self.AbladesoundPlaying then
            playSample(self.hornSoundId, 0, 1, 0);
            self.AbladesoundPlaying = true;
        end;
    else
        if self.AbladesoundPlaying then
            stopSample(self.AbladesoundSoundId);
            self.AbladesoundPlaying = false;
        end;
    end;
end;

function Abladesound:draw()
end;

