--
-- SafetyLoad.lua
-- safetyLoad visibility on/off when loading chaff
--
-- author: Brndi
-- date: 21.01.2013
-- version: v1.0 (January 2013)

-- Keine Vernderung ohne meine Erlaubnis!
-- No modification without my permission!

SafetyLoad = {};

function SafetyLoad.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function SafetyLoad:load(xmlFile)

	self.safetyLoadOn = {}
	self.safetyLoadOff = {}
	
	local i = 0;
	while true do
		local index = getXMLString(xmlFile, string.format("vehicle.safetyLoad.safetyLoadOn(%d)#index", i));
		if index == nil then
			break;
		end;
		local nodeId = Utils.indexToObject(self.components, index);
		setVisibility(nodeId, true);
		table.insert(self.safetyLoadOn, nodeId);
		i = i + 1;
	end;

	local i = 0;
	while true do
		local index = getXMLString(xmlFile, string.format("vehicle.safetyLoad.safetyLoadOff(%d)#index", i));
		if index == nil then
			break;
		end;
		local nodeId = Utils.indexToObject(self.components, index);
		setVisibility(nodeId, false);
		table.insert(self.safetyLoadOff, nodeId);
		i = i + 1;
	end;
end;

function SafetyLoad:onDeactivate()	
end;

function SafetyLoad:delete()
end;

function SafetyLoad:readStream(streamId, connection)
end;

function SafetyLoad:writeStream(streamId, connection)
end;

function SafetyLoad:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SafetyLoad:keyEvent(unicode, sym, modifier, isDown)
end;

function SafetyLoad:update(dt)
end;

function SafetyLoad:updateTick(dt)
	if self.currentFillType == Fillable.FILLTYPE_CHAFF then
		for _, v in ipairs(self.safetyLoadOn) do
			if getVisibility(v) then
				setVisibility(v, false);
			end;
		end;
		for _, v in ipairs(self.safetyLoadOff) do
			if not getVisibility(v) then
				setVisibility(v, true);
			end;
		end;
	else
		for _, v in ipairs(self.safetyLoadOn) do
			if not getVisibility(v) then
				setVisibility(v, true);
			end;
		end;
		for _, v in ipairs(self.safetyLoadOff) do
			if getVisibility(v) then
				setVisibility(v, false);
			end;
		end;
	end;
end;

function SafetyLoad:draw()
end;

function SafetyLoad:onDetach()
end;