--
-- pesticideFrontTank
-- Specialization for pesticideFrontTank
--
-- @author Felix "Outlaw" Sorge
-- @date  25/05/09
-- @web www.ls-modsource.de - www.ls-mods.de
--
-- Copyright (C) Outlaw, All Rights Reserved.
--

pesticideFrontTank = {};

function pesticideFrontTank.prerequisitesPresent(specializations)
    return true;
	end;


function pesticideFrontTank:load(xmlFile)
self.checkfL = 0;
end;


function pesticideFrontTank:update(dt)

	if self.attacherVehicle then
	-- forced arm to rotation 0 0 0 
		if self.fixAttacher then
			local implement = self.attacherVehicle:getImplementByObject(self);
			if implement ~= nil then
				local joint = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
				self.saveJoint = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
				self.maxRotJoint = joint.maxRotLimit;
				self.attacherJointIndex = implement.jointDescIndex;
				self.rotationCopy  = joint.minRot;
				joint.minRot = {0,0,0};			
				joint.maxRotLimit = {0, 0, 0};
				setJointRotationLimit(joint.jointIndex, 2, true, 0, 0);
			end;
			self.fixAttacher = false;
		end;
		
		-- checks fruittype and fillLevel on active vehicle implement 
		
		
		if self.fillLevel <= self.checkfL then
			for k,implement in pairs(self.attacherVehicle.attachedImplements) do
				local object = implement.object;
				if object.setFillLevel ~= nil and self.fillLevel ~= 0 and self.currentFillType ~= 0 then
					for fruitType,v in pairs(object.fillTypes) do
						if fruitType == self.currentFillType and object.fillLevel ~= object.capacity and object.rootNode ~= self.rootNode then
							local deltaLevel = 10*dt/1000.0;
							deltaLevel = math.min(deltaLevel, object.capacity - object.fillLevel);
							self.fillLevel = self.fillLevel-deltaLevel;
							self:setFillLevel(self.fillLevel, self.currentFillType);
							object:setFillLevel(object.fillLevel + deltaLevel, self.currentFillType);
						end; 
					end; 	
				end; 	
	        end;
		end; 
		
		-- shuttle only, when trigger is out of range
		self.checkfL = self.fillLevel; 
		
	end; 
	
end;

function pesticideFrontTank:draw()
end;


function pesticideFrontTank:onAttach()
	self.fixAttacher = true; 
end; 	


function pesticideFrontTank:onDetach()
	-- resets arm rotation to normal 
	local joint = self.saveJoint; 
	joint.minRot = self.rotationCopy;
	joint.maxRotLimit = self.maxRotJoint;
end;


function pesticideFrontTank:delete()
end;


function pesticideFrontTank:mouseEvent(posX, posY, isDown, isUp, button)
end;


function pesticideFrontTank:keyEvent(unicode, sym, modifier, isDown)
end;