--
-- TamLeguan
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date:		27/08/11
-- @version:	v1.0
-- @history:	v1.0 - initial implementation
--
-- free for noncommerical-usage
--


TamLeguan = {};

function TamLeguan.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cylindered, specializations);
end;

function TamLeguan:load(xmlFile)
end;

function TamLeguan:delete()
end;

function TamLeguan:readStream(streamId, connection)
end;

function TamLeguan:writeStream(streamId, connection)
end;

function TamLeguan:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TamLeguan:keyEvent(unicode, sym, modifier, isDown)
end;

function TamLeguan:update(dt)
	if self:getIsActive() then
		TamLeguan.setBackAxle(self);
	end;
end;

function TamLeguan:updateTick(dt)
	if not self:getIsActive() then
		TamLeguan.setBackAxle(self);			
		Cylindered.updateMovingPart(self, self.movingParts[1]);
		Cylindered.updateMovingPart(self, self.movingParts[2]);
	end;
end;

function TamLeguan.setBackAxle(self)
	if self.isServer then
		local jointNode = self.componentJoints[2].jointNode;
		local jointIndex = self.componentJoints[2].jointIndex;
		local x,_,z = worldDirectionToLocal(self.components[1].node, localDirectionToWorld(self.components[2].node, 0, 0, 1));
		local dot = z / Utils.vector2Length(x,z);
		local angle = math.acos(dot);
		if x > 0 then
			angle = -angle;
		end;
		setRotation(jointNode, 0, angle , 0);
		setJointFrame(jointIndex, 0, jointNode);
	end;
end;

function TamLeguan:onDetach()
  for i=table.getn(self.attachedImplements), 1, -1 do
    self:detachImplement(1);
  end;

end;

function TamLeguan:draw()
end;