--
-- montana
-- Specialization for montana combines from claas
--
-- @author  	Michi77
-- @version 	v1.0
-- @date  		16/03/14
-- @history:	v1.0 - Initial version
--
-- free for noncommerical-usage
--

montana = {};

function montana.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Combine, specializations);
end;

function montana:load(xmlFile)
    self.comp2Rotation = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.montana.comp2#index"));
	self.comp1Rotation = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.montana.comp1#index"));
	
	self.attacherCutter = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.montana.attacherCutter#index"));
	
	self.front = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.montana.front#index"));
	self.backRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.montana.backRight#index"));
	self.backLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.montana.backLeft#index"));
	
	self.currentRotXComp1 = 0;
	self.currentRotZComp1 = 0;
	self.rotateValueB = 0;
	self.rotateValueF = 0;
	self.rotateValueZ = 0;
	self.rotateValueX = 0;
end;

function montana:delete()
end;

function montana:readStream(streamId, connection)
end;

function montana:writeStream(streamId, connection)
end;

function montana:mouseEvent(posX, posY, isDown, isUp, button)
end;

function montana:keyEvent(unicode, sym, modifier, isDown)
end;

function montana:update(dt)
	--if self:getIsActive() and self:getIsActiveForInput(false) then
		local x_f,y_f,z_f = getWorldTranslation(self.front);
		local x_br,y_br,z_br = getWorldTranslation(self.backRight);
		local x_bl,y_bl,z_bl = getWorldTranslation(self.backLeft);
	
	
		
		if y_br > y_bl then
			self.rotateValueB = y_br - y_bl;
		else
			self.rotateValueB = y_bl - y_br;
		end;
	
		self.rotateValueZ = self.rotateValueB*-0.1;
		
		if self.rotateValueZ > 9 then
			self.rotateValueZ = 9;
		end;
		if self.rotateValueZ < -9 then
			self.rotateValueZ = -9;
		end;
		
	--	if y_br > y_bl then
	--		if y_f > y_br then
				self.rotateValueF = y_f - y_br;
	--		else
	--			self.rotateValueF = y_br - y_f;
	--		end;
	--	else
	--		if y_f > y_bl then
	--			self.rotateValueF = y_f - y_bl;
	--		else
	--			self.rotateValueF = y_bl - y_f;
	--		end;
	--	end;
	
		--print(self.rotateValueF);
		self.rotateValueX = self.rotateValueF*0.1;
		
		if self.rotateValueX > 6 then
			self.rotateValueX = 6;
		end;
		if self.rotateValueX < -6 then
			self.rotateValueX = -6;
		end;
		setRotation(self.comp1Rotation, self.rotateValueX, 0, self.rotateValueZ);
		
		local x, y, z = getTranslation(self.attacherCutter);
		x = 0;
		y = 0;
		z = 0;
		setTranslation(self.attacherCutter, x, y, z);
		
		if self.attacherJoints ~= nil then
             for _,joint in ipairs(self.attacherJoints) do
                 if joint.jointIndex ~= 0 then
                     setJointFrame(joint.jointIndex, 0, joint.jointTransform);
                 end;
                 --joint.jointFrameInvalid = true;
             end;
         end;
         if self.attacherVehicle ~= nil then
             local implement = self.attacherVehicle:getImplementByObject(self);
             if implement ~= nil then
                 local jointDesc = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
                 if jointDesc.jointIndex ~= 0 then
                     setJointFrame(jointDesc.jointIndex, 1, self.attacherJoint.node);
                 end;
             end;
         end;
	--end;
end;

function montana:updateTick(dt)
end;

function montana:draw()
end;

function montana:startThreshing()
end;

function montana:stopThreshing()
end;

function montana:onAttach()
end;

function montana:onDetach()	
end; 