PipelightsEvent = {};
PipelightsEvent_mt = Class(PipelightsEvent, Event);

InitEventClass(PipelightsEvent, "PipelightsEvent");

function PipelightsEvent:emptyNew()
    local self = Event:new(PipelightsEvent_mt);
    self.className="PipelightsEvent";
    return self;
end;

function PipelightsEvent:new(object, isActive)
    local self = PipelightsEvent:emptyNew()
    self.object = object;
	self.isActive = isActive;
    return self;
end;

function PipelightsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isActive = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function PipelightsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isActive);
end;

function PipelightsEvent:run(connection)
	self.object:setPipelightsActive(self.isActive, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(PipelightsEvent:new(self.object, self.isActive), nil, connection, self.object);
    end;	
end;

function PipelightsEvent.sendEvent(pipelights, isActive)
	if g_server ~= nil then
		g_server:broadcastEvent(PipelightsEvent:new(pipelights, isActive), nil, nil, pipelights);
	else
		g_client:getServerConnection():sendEvent(PipelightsEvent:new(pipelights, isActive));
	end;
end;

