--
-- Cutter
-- This is the specialization for cutters
-- It reacts both to steerable and attachable events
--
-- @author  Stefan Geiger, tune: MySQly
-- @date  04/12/08
--
-- Copyright (C) GIANTS Software GmbH, tune: MySQly , Confidential, All Rights Reserved.

c750 = {};

function c750.prerequisitesPresent(specializations)
    return true;
end;

function c750:load(xmlFile)
	self.stol = true;

    self.dual1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.dual1#index"));
    self.dual2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.dual2#index"));
	setVisibility(self.dual1, true);

	--***************************************HILLMASTER*********************************************
    local rotationPartNodeLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 2)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;

    local rotationPartNodeLeft2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft2#index"));
    if rotationPartNodeLeft2 ~= nil then
        self.rotationPartLeft2 = {};
        self.rotationPartLeft2.node = rotationPartNodeLeft2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#minRot"));
        self.rotationPartLeft2.minRot = {};
        self.rotationPartLeft2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#maxRot"));
        self.rotationPartLeft2.maxRot = {};
        self.rotationPartLeft2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#rotTime"), 2)*1000;
        self.rotationPartLeft2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeLeft3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft3#index"));
    if rotationPartNodeLeft3 ~= nil then
        self.rotationPartLeft3 = {};
        self.rotationPartLeft3.node = rotationPartNodeLeft3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft3#minRot"));
        self.rotationPartLeft3.minRot = {};
        self.rotationPartLeft3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft3#maxRot"));
        self.rotationPartLeft3.maxRot = {};
        self.rotationPartLeft3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft3#rotTime"), 2)*1000;
        self.rotationPartLeft3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft3#touchRotLimit"), 10));
    end;
	
	
    --**************************************Haspel***********************************************
	local translationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);
	print ("load doTranslate and transMax")
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#touchTransLimit"), 10);
    end;
	
	local translationPartNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart2#index"));
    if translationPartNode2 ~= nil then
        self.translationPart2 = {};
        self.translationPart2.node = translationPartNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#minTrans"));
        self.translationPart2.minTrans = {};
        self.translationPart2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#maxTrans"));
        self.translationPart2.maxTrans = {};
        self.translationPart2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#transTime"), 2)*1000;
        self.translationPart2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#touchTransLimit"), 10);
    end;
	
	local translationPartNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart3#index"));
    if translationPartNode3 ~= nil then
        self.translationPart3 = {};
        self.translationPart3.node = translationPartNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart3#minTrans"));
        self.translationPart3.minTrans = {};
        self.translationPart3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart3#maxTrans"));
        self.translationPart3.maxTrans = {};
        self.translationPart3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart3#transTime"), 2)*1000;
        self.translationPart3.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart3#touchTransLimit"), 10);
    end;

	self.translationMax2 = false;
	
    local rotationPartNodeRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRight#index"));
    if rotationPartNodeRight ~= nil then
        self.rotationPartRight = {};
        self.rotationPartRight.node = rotationPartNodeRight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#minRot"));
        self.rotationPartRight.minRot = {};
        self.rotationPartRight.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#maxRot"));
        self.rotationPartRight.maxRot = {};
        self.rotationPartRight.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRight.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#rotTime"), 2)*1000;
        self.rotationPartRight.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#touchRotLimit"), 10));
    end;
	
    self.setReelSpeed = SpecializationUtil.callSpecializationsFunction("setReelSpeed");
    self.onStartReel = SpecializationUtil.callSpecializationsFunction("onStartReel");
    self.onStopReel = SpecializationUtil.callSpecializationsFunction("onStopReel");
    self.isReelStarted = Cutter.isReelStarted;
    self.resetFruitType = SpecializationUtil.callSpecializationsFunction("resetFruitType");
    self.setFruitType = SpecializationUtil.callSpecializationsFunction("setFruitType");

    self.reelNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.reel#index"));

    self.rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.roll#index"));

    local indexSpikesStr = getXMLString(xmlFile, "vehicle.reelspikes#index");
    self.spikesCount = getXMLInt(xmlFile, "vehicle.reelspikes#count");
    self.spikesRootNode = Utils.indexToObject(self.components, indexSpikesStr);

    self.sideArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sidearms#index"));
    self.sideArmMovable = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.sidearms#movable"), false);

    self.threshingParticleSystems = {};
    local psName = "vehicle.threshingParticleSystem";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems, psName, self.components, false, nil, self.baseDirectory)

    self.fruitExtraObjects = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.fruitExtraObjects.fruitExtraObject(%d)", i);
        local t = getXMLString(xmlFile, key.."#fruitType");
        local index = getXMLString(xmlFile, key.."#index");
        if t==nil or index==nil then
            break;
        end;

        local node = Utils.indexToObject(self.components, index);
        if node ~= nil then
            if self.currentExtraObject == nil then
                self.currentExtraObject = node;
                setVisibility(node, true);
            else
                setVisibility(node, false);
            end;
            self.fruitExtraObjects[t] = node;
        end;
        i = i +1;
    end;

    self.preferedCombineSize = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.preferedCombineSize"), 1);

    self.fruitTypes = {};
    self.fruitTypes[FruitUtil.FRUITTYPE_UNKNOWN] = true;
    local fruitTypes = getXMLString(xmlFile, "vehicle.fruitTypes#fruitTypes");
    if fruitTypes ~= nil then
        local types = Utils.splitString(" ", fruitTypes);
        for k,v in pairs(types) do
            local desc = FruitUtil.fruitTypes[v];
            if desc ~= nil then
                self.fruitTypes[desc.index] = true;
            end;
        end;
    end;

    self.currentFruitType = FruitUtil.FRUITTYPE_UNKNOWN;

    self.reelStarted = false;

    self.forceLowSpeed = false;
    self.speedLimitLow = 12;
    self.speedLimit = 17.5;

    self.speedViolationMaxTime = 50;
    self.speedViolationTimer = self.speedViolationMaxTime;
    self.printRainWarning = false;


    self.lastArea = 0;

end;

function c750:delete()
    Utils.deleteParticleSystem(self.threshingParticleSystems);
end;

function c750:mouseEvent(posX, posY, isDown, isUp, button)
end;

function c750:keyEvent(unicode, sym, modifier, isDown)

--[[	if InputBinding.isPressed(InputBinding.Hrauf) then
		self.rotationMaxRight = isDown;
	end;
	if InputBinding.isPressed(InputBinding.Hrunter) then
		self.rotationMinRight = isDown;
	end;
	
	if InputBinding.isPressed(InputBinding.Rapstisch) then
		self.stol = not self.stol;
		setVisibility(self.dual1, self.stol);
		setVisibility(self.dual2, not self.stol);
	end;
	
	if InputBinding.isPressed(InputBinding.Hvor) then
		self.translationMax = isDown;
		self.translationMax3 = isDown;
	end;
	if InputBinding.isPressed(InputBinding.Hzurueck) then
		self.translationMin = isDown;
		self.translationMin3 = isDown;
	end;
	
	if InputBinding.isPressed(InputBinding.Hlangsam) then
		if self.Haspel > 0.001 then
			self.Haspel = self.Haspel - 0.001;
		end;
	end;
	if InputBinding.isPressed(InputBinding.Hschnell) then
		if self.Haspel < 0.005 then
			self.Haspel = self.Haspel + 0.001;
		end;
	end;]]
	
	if sym == Input.KEY_KP_8 then
		self.rotationMaxRight = isDown;
	end;
	if sym == Input.KEY_KP_2 then
		self.rotationMinRight = isDown;
	end;
	
	if InputBinding.isPressed(InputBinding.Rapstisch) then
		self.stol = not self.stol;
		setVisibility(self.dual1, self.stol);
		setVisibility(self.dual2, not self.stol);
	end;	
	
	if sym == Input.KEY_KP_4 then
		self.translationMax = isDown;
		self.translationMax3 = isDown;
	end;
	if sym == Input.KEY_KP_6 then
		self.translationMin = isDown;
		self.translationMin3 = isDown;
	end;
	if isDown and sym == Input.KEY_KP_7 then
		if self.reelSpeed > 0.001 then
			self.reelSpeed = self.reelSpeed - 0.001;
		end;
	end;
	if isDown and sym == Input.KEY_KP_9 then
		if self.reelSpeed < 0.005 then
			self.reelSpeed = self.reelSpeed + 0.001;
		end;
	end;	
end;

function c750:update(dt)

	--**********************************************HILLMASTER*********************************************
    if self.rotation2PartRight ~= nil and (self.rotation2MaxRight or self.rotation2MinRight) then
        local x, y, z = getRotation(self.rotation2PartRight.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation2PartRight.maxRot, self.rotation2PartRight.minRot, 3, self.rotation2PartRight.rotTime, dt, not self.rotation2MaxRight);
        setRotation(self.rotation2PartRight.node, unpack(newRot));
    end;

    if self.rotation2PartLeft ~= nil and (self.rotation2MaxLeft or self.rotation2MinLeft) then
        local x, y, z = getRotation(self.rotation2PartLeft.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation2PartLeft.maxRot, self.rotation2PartLeft.minRot, 3, self.rotation2PartLeft.rotTime, dt, not self.rotation2MaxLeft);
        setRotation(self.rotation2PartLeft.node, unpack(newRot));
    end;
	--********************************************Haspel***********************************************
		if self.translationPart2 ~= nil then
			local x, y, z = getTranslation(self.translationPart2.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart2.maxTrans, self.translationPart2.minTrans, 3, self.translationPart2.transTime, dt, not self.translationMax2);
			setTranslation(self.translationPart2.node, unpack(newTrans));
		end;
		
		local doTranslate = self.translationMax or self.translationMin
		if self.translationPart ~= nil and doTranslate then
			--translate = button { }  = isDown
			local x, y, z = getTranslation(self.translationPart.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax);
			setTranslation(self.translationPart.node, unpack(newTrans));
		end;
		if self.translationPart3 ~= nil and doTranslate then
			--translate = button { }  = isDown
			local x, y, z = getTranslation(self.translationPart3.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart3.maxTrans, self.translationPart3.minTrans, 3, self.translationPart3.transTime, dt, not self.translationMax3);
			setTranslation(self.translationPart3.node, unpack(newTrans));
		end;
	
    if self.rotationPartRight ~= nil and (self.rotationMaxRight or self.rotationMinRight) then
        local x, y, z = getRotation(self.rotationPartRight.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight.maxRot, self.rotationPartRight.minRot, 3, self.rotationPartRight.rotTime, dt, not self.rotationMaxRight);
        setRotation(self.rotationPartRight.node, unpack(newRot));
    end;

    if self.rotationPartLeft ~= nil and (self.rotationMaxLeft or self.rotationMinLeft) then
        local x, y, z = getRotation(self.rotationPartLeft.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft.maxRot, self.rotationPartLeft.minRot, 3, self.rotationPartLeft.rotTime, dt, not self.rotationMaxLeft);
        setRotation(self.rotationPartLeft.node, unpack(newRot));
    end;
	
    if self.rotationPartLeft2 ~= nil and (self.rotationMaxLeft2 or self.rotationMinLeft2) then
        local x, y, z = getRotation(self.rotationPartLeft2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft2.maxRot, self.rotationPartLeft2.minRot, 3, self.rotationPartLeft2.rotTime, dt, not self.rotationMaxLeft2);
        setRotation(self.rotationPartLeft2.node, unpack(newRot));
    end;
	
    if self.rotationPartLeft3 ~= nil and (self.rotationMaxLeft3 or self.rotationMinLeft3) then
        local x, y, z = getRotation(self.rotationPartLeft3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft3.maxRot, self.rotationPartLeft3.minRot, 3, self.rotationPartLeft3.rotTime, dt, not self.rotationMaxLeft3);
        setRotation(self.rotationPartLeft3.node, unpack(newRot));
    end;
	
	
    self.lastArea = 0;
    if self.reelStarted and self.movingDirection < 0 then

        local speedLimit = self.speedLimit;
        if Cutter.getUseLowSpeedLimit(self) then
            speedLimit = self.speedLimitLow;
        end;

        if self:doCheckSpeedLimit() and self.lastSpeed*3600 > speedLimit then
            self.speedViolationTimer = self.speedViolationTimer - dt;
        else
            self.speedViolationTimer = self.speedViolationMaxTime;
        end;

        if self.speedViolationTimer > 0 then
            if Cutter.allowThreshing(false) then
                self.printRainWarning = false;

                -- during low fill level new fruit types are allowed to "take over"
                local lowFillLevel = false;
                if self.attacherVehicle ~= nil then
                    if self.attacherVehicle.grainTankFillLevel > 0 and self.attacherVehicle.grainTankFillLevel / self.attacherVehicle.grainTankCapacity <= self.attacherVehicle.minThreshold then
                        lowFillLevel = true;
                    end;
                end;

                local foundFruitType = false;
                local oldFruitType = self.currentFruitType;
                
                local allowsThreshing = true;
                if self.attacherVehicle ~= nil then
                    allowsThreshing = self.attacherVehicle.allowsThreshing;
                end;

                if allowsThreshing then
                    if self.currentFruitType == FruitUtil.FRUITTYPE_UNKNOWN or lowFillLevel then
                        for fruitType,v in pairs(self.fruitTypes) do
                            local isOk = true;
                            if self.attacherVehicle ~= nil then
                                if self.attacherVehicle.allowGrainTankFruitType ~= nil then
                                    isOk = self.attacherVehicle:allowGrainTankFruitType(fruitType);
                                end;
                            end;
                            if isOk then
                                for k,area in pairs(self.cuttingAreas) do
                                    local x,y,z = getWorldTranslation(area.start);
                                    local x1,y1,z1 = getWorldTranslation(area.width);
                                    local x2,y2,z2 = getWorldTranslation(area.height);
                                    local area = Utils.getFruitArea(fruitType, x, z, x1, z1, x2, z2);
                                    if area > 0 then
                                        self.currentFruitType = fruitType;
                                        if self.currentFruitType ~= oldFruitType then
                                            Cutter.updateExtraObjects(self)
                                            if self.attacherVehicle ~= nil then
                                                self.attacherVehicle:emptyGrainTankIfLowFillLevel();
                                            end;
                                        end;
                                        foundFruitType = true;
                                        break;
                                    end;
                                end;

                                if foundFruitType then
                                    break;
                                end;
                            end;
                        end;
                    end;
                    if self.currentFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
                        local realArea = 0;
                        for k,area in pairs(self.cuttingAreas) do
                            local x,y,z = getWorldTranslation(area.start);
                            local x1,y1,z1 = getWorldTranslation(area.width);
                            local x2,y2,z2 = getWorldTranslation(area.height);
                            Utils.updateFruitCutShortArea(self.currentFruitType, x, z, x1, z1, x2, z2, 1);
                            local area = Utils.cutFruitArea(self.currentFruitType, x, z, x1, z1, x2, z2);
                            if area > 0 then
                                local spray = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.sprayChannel, x, z, x1, z1, x2, z2);
                                local multi = 1;
                                if spray > 0 then
                                    multi = 2;
                                end;
                                self.lastArea = self.lastArea + area*multi;
                                realArea = realArea + area/g_currentMission.maxFruitValue;
                            end;
                        end;
                        local pixelToQm = 2048 / 4096 * 2048 / 4096; -- 4096px are mapped to 2048m
                        local qm = realArea*pixelToQm;
                        local ha = qm/10000;

                        g_currentMission.missionStats.hectaresThreshedTotal = g_currentMission.missionStats.hectaresThreshedTotal + ha;
                        g_currentMission.missionStats.hectaresThreshedSession = g_currentMission.missionStats.hectaresThreshedSession + ha;

                        g_currentMission.missionStats.threshingDurationTotal = g_currentMission.missionStats.threshingDurationTotal + dt/(1000*60);
                        g_currentMission.missionStats.threshingDurationSession= g_currentMission.missionStats.threshingDurationSession + dt/(1000*60);
                    end;
                end;
            else
                self.printRainWarning = true;
            end;
        end;
    else
        self.speedViolationTimer = self.speedViolationMaxTime;
    end;

    Utils.setEmittingState(self.threshingParticleSystems, (self.reelStarted and self.lastArea > 0.0));

    if self.reelStarted then

        rotate(self.rollNode, -dt*self.reelSpeed*3, 0, 0);

        if self.reelNode ~= nil then
            rotate(self.reelNode, -dt*self.reelSpeed, 0, 0);

            if self.sideArmMovable then
                --:TODO: move arm downwards
            end;

            --correct spikes, so that they always look down
            atx, aty, atz = getRotation(self.reelNode);

            for i=1, self.spikesCount do
                local spike    =    getChildAt(self.spikesRootNode, i-1);
                tx, ty, tz = getRotation(spike);
                setRotation(spike, -atx, aty, atz);
            end;
        end;

    end;
end;

function c750:draw()

    if math.abs(self.speedViolationTimer - self.speedViolationMaxTime) > 2 then
        local str = "2";
        local keyStr = InputBinding.getButtonKeyName(InputBinding.SPEED_LEVEL2)
        if Cutter.getUseLowSpeedLimit(self) then
            str = "1";
            keyStr = InputBinding.getButtonKeyName(InputBinding.SPEED_LEVEL1)
        end;
        g_currentMission:addWarning("Nie jedz tak szybko!", 0.018, 0.033);
    end;

    if self.printRainWarning then
        g_currentMission:addWarning("Nie zbieraj mokrego ziarna!", 0.018, 0.033);
    end;
end;

function c750:onDetach()
    if self.deactivateOnDetach then
        Cutter.onDeactivate(self);
    end;
end;

function c750:onLeave()
    if self.deactivateOnLeave then
        Cutter.onDeactivate(self);
    end;
end;

function c750:onDeactivate()
    self:onStopReel();
    Utils.setEmittingState(self.threshingParticleSystems, false);
    self.speedViolationTimer = self.speedViolationMaxTime;
end;

function c750:setReelSpeed(speed)
    self.reelSpeed = speed;
	
end;

function c750:onStartReel()
    self.reelStarted = true;

end;

function c750:onStopReel()
    self.reelStarted = false;
    Utils.setEmittingState(self.threshingParticleSystems, false);
    self.speedViolationTimer = self.speedViolationMaxTime;
end;

function c750:isReelStarted()
    return self.reelStarted;
end;

function c750:resetFruitType()
    self.currentFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.lastArea = 0;
end;

function c750:setFruitType(fruitType)
    if self.currentFruitType ~= fruitType then
        self.currentFruitType = fruitType;
        self.lastArea = 0;

        Cutter.updateExtraObjects(self)
    end;
end;

function c750.getUseLowSpeedLimit(self)
    if self.forceLowSpeed or (self.attacherVehicle ~= nil and self.preferedCombineSize > self.attacherVehicle.combineSize) then
        return true;
    end;
    return false;
end;

function c750.updateExtraObjects(self)
    if self.currentExtraObject ~= nil then
        setVisibility(self.currentExtraObject, false);
        self.currentExtraObject = nil;
    end;
    if self.currentFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        local name = FruitUtil.fruitIndexToDesc[self.currentFruitType].name;
        local extraObject = self.fruitExtraObjects[name];
        if extraObject ~= nil then
            setVisibility(extraObject, true);
            self.currentExtraObject = extraObject;
        end;
    end;
end;

function c750.allowThreshing(earlyWarning)
    if early ~= nil and early == true then
        if g_currentMission.environment.lastRainScale <= 0.02 and g_currentMission.environment.timeSinceLastRain > 20 then
            return true;
        end;
    else
        if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 20 then
            return true;
        end;
    end;
    return false;
end;
