

dominator58cutter = {};

function dominator58cutter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations) and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function dominator58cutter:load(xmlFile)
	
	self.dominator58cutter = {};
	
	self.dominator58cutter.speed = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.vario#speed"), 11);
	self.dominator58cutter.speedScaleTime = 5000;
	self.dominator58cutter.speedScaleBackup = self.reelSpeedScale;
	self.dominator58cutter.rollSpeedBackup = self.rollNodes[1].speed;
	
	self.reelSpeedScale = 0;
	for _, rollNode in pairs(self.rollNodes) do
		rollNode.speed = 0;
	end;
end;

function dominator58cutter:delete()
end;

function dominator58cutter:readStream(streamId, connection)
end;

function dominator58cutter:writeStream(streamId, connection)
end;

function dominator58cutter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function dominator58cutter:keyEvent(unicode, sym, modifier, isDown)
end;

function dominator58cutter:update(dt)
	if self:getIsActive() and self.reelStarted then
		if self.attacherVehicle ~= nil and self.attacherVehicle.allowsThreshing ~= nil then
			if not self.attacherVehicle.allowsThreshing then
				self.lastAreaBiggerZero = false;
				if self.lastAreaBiggerZero ~= self.lastAreaBiggerZeroSent then
					self:raiseDirtyFlags(self.cutterGroundFlag);
					self.lastAreaBiggerZeroSent = self.lastAreaBiggerZero;
				end;
			end;
		end;
	
		local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.dominator58cutter.speed, 1.3));
	
		local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.dominator58cutter.speedScaleBackup * percent}, {0}, 1, self.dominator58cutter.speedScaleTime, dt, false);
		self.reelSpeedScale = speedScale[1];
		for _, rollNode in pairs(self.rollNodes) do
			local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.dominator58cutter.rollSpeedBackup * percent}, {0}, 1, self.dominator58cutter.speedScaleTime, dt, false);
			rollNode.speed = rollSpeed[1];
		end;
		
		
	else
		if self.reelSpeedScale ~= 0 or self.rollNodes[1].speed ~= 0 then
			local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.dominator58cutter.speed, 1.5));
			
			local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.dominator58cutter.speedScaleBackup * percent}, {0}, 1, self.dominator58cutter.speedScaleTime*1.5, dt, true);
			self.reelSpeedScale = speedScale[1];
			rotate(self.reelNode, -dt*self.reelSpeed*self.reelSpeedScale, 0, 0);
			for _, rollNode in pairs(self.rollNodes) do
				local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.dominator58cutter.rollSpeedBackup * percent}, {0}, 1, self.dominator58cutter.speedScaleTime*1.5, dt, true);
				rollNode.speed = rollSpeed[1];
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;
			
			local atx, aty, atz = getRotation(self.reelNode);
			for i=1, self.spikesCount do
				local spike = getChildAt(self.spikesRootNode, i-1);
				setRotation(spike, -atx, aty, atz);
			end;
		end;
	end;
end;

function dominator58cutter:updateTick(dt)
	
end;

function dominator58cutter:draw()	
end;

function dominator58cutter:onAttach(attacherVehicle)
	
end;

function dominator58cutter:onDetach()
	Cutter.updateExtraObjects(self);
end;

