

Varifeet1070 = {};

function Varifeet1070.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations) and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function Varifeet1070:load(xmlFile)
	
	self.foldCameras = SpecializationUtil.callSpecializationsFunction("foldCameras");
	
	self.Varifeet1070 = {};
	
	self.Varifeet1070.speed = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.vario#speed"), 11);
	self.Varifeet1070.speedScaleTime = 5000;
	self.Varifeet1070.speedScaleBackup = self.reelSpeedScale;
	self.Varifeet1070.rollSpeedBackup = self.rollNodes[1].speed;
	
	self.reelSpeedScale = 0;
	for _, rollNode in pairs(self.rollNodes) do
		rollNode.speed = 0;
	end;
	
	self.blades = {};
	local vertical = {};
	vertical.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.blades#vertical"));
	vertical.max = getXMLFloat(xmlFile, "vehicle.blades#vertMax");
	vertical.speed = getXMLFloat(xmlFile, "vehicle.blades#vertSpeed") * 1000;	
	vertical.dir = 1;
	local horizontal = {};
	horizontal.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.blades#horizontal"));
	horizontal.max = getXMLFloat(xmlFile, "vehicle.blades#horizMax");
	horizontal.speed = getXMLFloat(xmlFile, "vehicle.blades#horizSpeed") * 1000;
	horizontal.dir = 1;
	
	self.blades.vertical = vertical;
	self.blades.horizontal = horizontal;
	
	
	self.Varifeet1070.lastFruit = FRUITTYPE_UNKNOWN;
end;

function Varifeet1070:delete()
end;

function Varifeet1070:readStream(streamId, connection)
end;

function Varifeet1070:writeStream(streamId, connection)
end;

function Varifeet1070:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Varifeet1070:keyEvent(unicode, sym, modifier, isDown)
end;

function Varifeet1070:update(dt)

	Utils.setEmittingState(self.threshingParticleSystems, (self.reelStarted and self.lastAreaBiggerZero and self.particleSystemsVisible));

	
	
	if self:getIsActive() and self.reelStarted then
		if self.attacherVehicle ~= nil and self.attacherVehicle.allowsThreshing ~= nil then
			if not self.attacherVehicle.allowsThreshing then
				self.lastAreaBiggerZero = false;
				if self.lastAreaBiggerZero ~= self.lastAreaBiggerZeroSent then
					self:raiseDirtyFlags(self.cutterGroundFlag);
					self.lastAreaBiggerZeroSent = self.lastAreaBiggerZero;
				end;
			end;
		end;
	
		local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.Varifeet1070.speed, 1.3));
	
		local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.Varifeet1070.speedScaleBackup * percent}, {0}, 1, self.Varifeet1070.speedScaleTime, dt, false);
		self.reelSpeedScale = speedScale[1];
		for _, rollNode in pairs(self.rollNodes) do
			local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.Varifeet1070.rollSpeedBackup * percent}, {0}, 1, self.Varifeet1070.speedScaleTime, dt, false);
			rollNode.speed = rollSpeed[1];
		end;
		
		if self.blades.vertical.node ~= nil then
			local _,y,_ = getTranslation(self.blades.vertical.node);
			if y < 0.005 or y > (self.blades.vertical.max - 0.005) then
				self.blades.vertical.dir = math.abs(self.blades.vertical.dir - 1);
			end;
			local newTrans = Utils.getMovedLimitedValues({y}, {self.blades.vertical.max}, {0}, 1, self.blades.vertical.speed / percent, dt, self.blades.vertical.dir ~= 0);
			setTranslation(self.blades.vertical.node, 0, unpack(newTrans), 0);
		end;
		if self.blades.horizontal.node ~= nil then
			local x,_,_ = getTranslation(self.blades.horizontal.node);
			if x < 0.005 or x > (self.blades.horizontal.max - 0.005) then
				self.blades.horizontal.dir = math.abs(self.blades.horizontal.dir - 1);
			end;
			local newTrans = Utils.getMovedLimitedValues({x}, {self.blades.horizontal.max}, {0}, 1, self.blades.horizontal.speed / percent, dt, self.blades.horizontal.dir ~= 0);
			setTranslation(self.blades.horizontal.node, unpack(newTrans), 0, 0);
		end;
	else
		if self.reelSpeedScale ~= 0 or self.rollNodes[1].speed ~= 0 then
			local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.Varifeet1070.speed, 1.5));
			
			local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.Varifeet1070.speedScaleBackup * percent}, {0}, 1, self.Varifeet1070.speedScaleTime*1.5, dt, true);
			self.reelSpeedScale = speedScale[1];
			rotate(self.reelNode, -dt*self.reelSpeed*self.reelSpeedScale, 0, 0);
			for _, rollNode in pairs(self.rollNodes) do
				local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.Varifeet1070.rollSpeedBackup * percent}, {0}, 1, self.Varifeet1070.speedScaleTime*1.5, dt, true);
				rollNode.speed = rollSpeed[1];
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;
			
			local atx, aty, atz = getRotation(self.reelNode);
			for i=1, self.spikesCount do
				local spike = getChildAt(self.spikesRootNode, i-1);
				setRotation(spike, -atx, aty, atz);
			end;
		end;
	end;
end;

function Varifeet1070:updateTick(dt)
	
end;

function Varifeet1070:draw()	
end;

function Varifeet1070:onAttach(attacherVehicle)
	
end;

function Varifeet1070:onDetach()
	self:setFruitType(FruitUtil.FRUITTYPE_UNKNOWN);	
	Cutter.updateExtraObjects(self);
	
end;

