--
-- NHCR9090
-- Specialization for NHCR9090
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		14/12/11
-- @history:	v1.0 - Initial version
--

NHCR9090 = {};

function NHCR9090.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(ChopperSwitcher, specializations);
end;

function NHCR9090:load(xmlFile)
	
	-- chopper particle system
	self.addChopperParticleSystems = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.addChopperParticleSystems.chopperParticleSystem(%d)", i);
		local t = getXMLString(xmlFile, key .. "#type");
		if t == nil then
			break;
		end;
		local desc = FruitUtil.fruitTypes[t];
		if desc ~= nil then
			local currentPS = {};

			local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/threshingChopperParticleSystem.i3d", self.baseDirectory);
			self.addChopperParticleSystems[desc.index] = currentPS;
			if self.addDefaultChopperParticleSystem == nil then
				self.addDefaultChopperParticleSystem = currentPS;
			end;
		end;
		i = i + 1;
	end;
	
	-- chopper dust particle system
	self.chopperDustParticleSystems = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.chopperDustParticleSystems.chopperDustParticleSystem(%d)", i);
		local t = getXMLString(xmlFile, key .. "#type");
		if t == nil then
			break;
		end;
		local desc = FruitUtil.fruitTypes[t];
		if desc ~= nil then
			local currentPS = {};

			local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/threshingChopperParticleSystem.i3d", self.baseDirectory);
			self.chopperDustParticleSystems[desc.index] = currentPS;
			if self.defaultChopperDustParticleSystem == nil then
				self.defaultChopperDustParticleSystem = currentPS;
			end;
		end;
		i = i + 1;
	end;
	
	
	
	
	
	self.chopperLeftDirection = false;	
	
	self.lastStrawPSState = false;
	self.lastChopperPSState = false;
	
	
	
	self.particleSystemsVisible = true;
end;

function NHCR9090:delete()
    for k,v in pairs(self.addChopperParticleSystems) do
        Utils.deleteParticleSystem(v);
    end;
	for k,v in pairs(self.chopperDustParticleSystems) do
        Utils.deleteParticleSystem(v);
    end;
end;

function NHCR9090:readStream(streamId, connection)
	
end;

function NHCR9090:writeStream(streamId, connection)
	
end;

function NHCR9090:mouseEvent(posX, posY, isDown, isUp, button)
end;

function NHCR9090:keyEvent(unicode, sym, modifier, isDown)
end;

function NHCR9090:update(dt)
	
end;

function NHCR9090:updateTick(dt)
	if self:getIsActive() then
		
		
	
		for key, particle in pairs(self.addChopperParticleSystems) do
			Utils.setEmittingState(particle, Utils.getNoNil(self.chopperParticleSystems[key].isEmitting, false));
		end;
		for key, particle in pairs(self.chopperDustParticleSystems) do
			Utils.setEmittingState(particle, Utils.getNoNil(self.chopperParticleSystems[key].isEmitting, false));
		end;
		
		
	end;	
end;

function NHCR9090:draw()	
	
end;

function NHCR9090:detachImplement(implementIndex)

	
end;

function NHCR9090:onDeactivate()
    for k,v in pairs(self.addChopperParticleSystems) do
        Utils.setEmittingState(v, false);
    end;
	for k,v in pairs(self.chopperDustParticleSystems) do
        Utils.setEmittingState(v, false);
    end;
end;

function NHCR9090:startThreshing()
	
end;

function NHCR9090:stopThreshing()
    for k,v in pairs(self.addChopperParticleSystems) do
        Utils.setEmittingState(v, false);
    end;
	for k,v in pairs(self.chopperDustParticleSystems) do
        Utils.setEmittingState(v, false);
    end;
	
end;

local oldCombineSetChopperEnableEventExecute = CombineSetChopperEnableEvent.execute;
CombineSetChopperEnableEvent.execute = function(object, enabled, fruitType)
	oldCombineSetChopperEnableEventExecute(object, enabled, fruitType);
	object.lastChopperPSState = enabled;
	if object.particleSystemsVisible ~= nil then
		Utils.setEmittingState(object.currentChopperParticleSystem, enabled and object.particleSystemsVisible);
	end;
end;	

local oldCombineSetStrawEnableEventExecute = CombineSetStrawEnableEvent.execute;
CombineSetStrawEnableEvent.execute = function(object, enabled, fruitType)
	oldCombineSetStrawEnableEventExecute(object, enabled, fruitType);
	object.lastStrawPSState = enabled;
	if object.particleSystemsVisible ~= nil then
		Utils.setEmittingState(object.currentStrawParticleSystem, enabled and object.particleSystemsVisible);
	end;
end;


