
--Written by "ihc-433" 
--Update by "Werkstattleiter" und "Ordaton"  NAS-Moddingsquad
--Date: 10.11.2012

Chieftain_Foresty = {};

function Chieftain_Foresty.prerequisitesPresent(specializations)
    return true; 
end;

function Chieftain_Foresty:load(xmlFile)
		--Erster Trigger
	self.Trigger1 = Chieftain_Foresty.Trigger1;
	self.TriggerIndex1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Trigger1#index"));
	addTrigger(self.TriggerIndex1, "Trigger1", self);
	self.enteredTrigger1 = false;

	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));
		if self.hydraulics[i].punch ~= nil and self.hydraulics[i].translationPunch ~= nil then
			local ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	
end;

function Chieftain_Foresty:Trigger1(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if (g_currentMission.player and otherId == g_currentMission.player.rootNode) then
		if onEnter then
			self.enteredTrigger1 = true;
		end;
		if onLeave then 
			self.enteredTrigger1 = false;
		end;
	end;
end;


function Chieftain_Foresty:readStream(streamId, connection)
	
end;

function Chieftain_Foresty:writeStream(streamId, connection)	
	
end;

function Chieftain_Foresty:delete()

	removeTrigger(self.TriggerIndex1, "Trigger1", self);
	
end;

function Chieftain_Foresty:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Chieftain_Foresty:keyEvent(unicode, sym, modifier, isDown)
end;

function Chieftain_Foresty:update(dt)

	if self.enteredTrigger1 == true then
		if InputBinding.isPressed(InputBinding.Chieftain_Foresty_1) then
			self:setAnimationTime(1, self.animationParts[1].currentPosition+(self.animationParts[1].offSet*(dt/10)));
		end;
		
		if InputBinding.isPressed(InputBinding.Chieftain_Foresty_2) then
			self:setAnimationTime(1, self.animationParts[1].currentPosition-(self.animationParts[1].offSet*(dt/10)));
		end;
		if self.animationParts[1].clipEndTime then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Chieftain_Foresty_GH_1")), InputBinding.Chieftain_Foresty_2);
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Chieftain_Foresty_GH_1")), InputBinding.Chieftain_Foresty_1);
		end;
	
	if self:getIsActiveForInput() then
		if InputBinding.isPressed(InputBinding.Chieftain_Foresty_GH_1) then
			self:setAnimationTime(1, self.animationParts[1].currentPosition+(self.animationParts[1].offSet*(dt/10)));
		end;
		
		if InputBinding.isPressed(InputBinding.Chieftain_Foresty_GH_2) then
			self:setAnimationTime(1, self.animationParts[1].currentPosition-(self.animationParts[1].offSet*(dt/10)));
		end;
		if self.animationParts[1].clipEndTime then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Chieftain_Foresty_GH_2")), InputBinding.Chieftain_Foresty_GH_2);
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Chieftain_Foresty_GH_1")), InputBinding.Chieftain_Foresty_GH_1);
		end;
	end;
  end;
end;

function Chieftain_Foresty:updateTick(dt)

	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		if bx ~= nil and by ~= nil and bz ~= nil then
			local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
			setDirection(self.hydraulics[i].node, x, y, z, 0, 0, 1);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			if self.hydraulics[i].punch ~= nil and self.hydraulics[i].punchDistance ~= nil and self.hydraulics[i].translationPunch then
				if self.hydraulics[i].doScale then
					local xScale, yScale, zScale = getScale(self.hydraulics[i].punch);
					local newScale = xScale * (distance / self.hydraulics[i].punchDistance);
					setScale(self.hydraulics[i].punch, 1, 1, newScale);
				else
					setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
				end;
			end;
		end;
	end;
	
end;

function Chieftain_Foresty:draw()


end;

function Chieftain_Foresty:onLeave()
	
end;